/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.Permissions;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PermissionTicketAwareDecisionResultCollector;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.LockObjectsForModification;

public class AuthorizationTokenService {
    public static final String CLAIM_TOKEN_FORMAT_ID_TOKEN = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken";
    public static final String CLAIM_TOKEN_FORMAT_JWT = "urn:ietf:params:oauth:token-type:jwt";
    private static final Logger logger = Logger.getLogger(AuthorizationTokenService.class);
    private static final String RESPONSE_MODE_DECISION = "decision";
    private static final String RESPONSE_MODE_PERMISSIONS = "permissions";
    private static final String RESPONSE_MODE_DECISION_RESULT = "result";
    private static Map<String, BiFunction<KeycloakAuthorizationRequest, AuthorizationProvider, EvaluationContext>> SUPPORTED_CLAIM_TOKEN_FORMATS = new HashMap<String, BiFunction<KeycloakAuthorizationRequest, AuthorizationProvider, EvaluationContext>>();
    private static final AuthorizationTokenService INSTANCE;

    public static AuthorizationTokenService instance() {
        return INSTANCE;
    }

    private static void fireErrorEvent(EventBuilder event, String error, Exception cause) {
        if (cause instanceof CorsErrorResponseException) {
            CorsErrorResponseException originalCause = (CorsErrorResponseException)((Object)cause);
            event.detail("reason", originalCause.getErrorDescription() == null ? "<unknown>" : originalCause.getErrorDescription()).error(error);
        } else {
            event.detail("reason", cause == null || cause.getMessage() == null ? "<unknown>" : cause.getMessage()).error(error);
        }
        logger.debug((Object)event.getEvent().getType(), (Throwable)cause);
    }

    public Response authorize(KeycloakAuthorizationRequest request) {
        EventBuilder event = request.getEvent();
        if (this.isPublicClientRequestingEntitlementWithClaims(request)) {
            CorsErrorResponseException forbiddenClientException = new CorsErrorResponseException(request.getCors(), "invalid_grant", "Public clients are not allowed to send claims", Response.Status.FORBIDDEN);
            AuthorizationTokenService.fireErrorEvent(event, "invalid_request", (Exception)((Object)forbiddenClientException));
            throw forbiddenClientException;
        }
        try {
            PermissionTicketToken ticket = this.getPermissionTicket(request);
            request.setClaims(ticket.getClaims());
            EvaluationContext evaluationContext = this.createEvaluationContext(request);
            KeycloakIdentity identity = (KeycloakIdentity)KeycloakIdentity.class.cast(evaluationContext.getIdentity());
            if (identity != null) {
                event.user(identity.getId());
            }
            ResourceServer resourceServer = this.getResourceServer(ticket, request);
            Collection<Permission> permissions = request.getTicket() != null ? this.evaluateUserManagedPermissions(request, ticket, resourceServer, evaluationContext) : (ticket.getPermissions().isEmpty() && request.getRpt() == null ? this.evaluateAllPermissions(request, resourceServer, evaluationContext) : this.evaluatePermissions(request, ticket, resourceServer, evaluationContext, identity));
            if (this.isGranted(ticket, request, permissions)) {
                String responseMode;
                AuthorizationProvider authorization = request.getAuthorization();
                ClientModel targetClient = authorization.getRealm().getClientById(resourceServer.getClientId());
                AuthorizationRequest.Metadata metadata = request.getMetadata();
                String string = responseMode = metadata != null ? metadata.getResponseMode() : null;
                if (responseMode != null) {
                    if (RESPONSE_MODE_DECISION.equals(metadata.getResponseMode())) {
                        HashMap<String, Boolean> responseClaims = new HashMap<String, Boolean>();
                        responseClaims.put(RESPONSE_MODE_DECISION_RESULT, true);
                        return this.createSuccessfulResponse(responseClaims, request);
                    }
                    if (RESPONSE_MODE_PERMISSIONS.equals(metadata.getResponseMode())) {
                        return this.createSuccessfulResponse(permissions, request);
                    }
                    CorsErrorResponseException invalidResponseModeException = new CorsErrorResponseException(request.getCors(), "invalid_request", "Invalid response_mode", Response.Status.BAD_REQUEST);
                    AuthorizationTokenService.fireErrorEvent(event, "invalid_request", (Exception)((Object)invalidResponseModeException));
                    throw invalidResponseModeException;
                }
                return this.createSuccessfulResponse(this.createAuthorizationResponse(identity, permissions, request, targetClient), request);
            }
            if (request.isSubmitRequest()) {
                CorsErrorResponseException submittedRequestException = new CorsErrorResponseException(request.getCors(), "access_denied", "request_submitted", Response.Status.FORBIDDEN);
                AuthorizationTokenService.fireErrorEvent(event, "access_denied", (Exception)((Object)submittedRequestException));
                throw submittedRequestException;
            }
            CorsErrorResponseException notAuthorizedException = new CorsErrorResponseException(request.getCors(), "access_denied", "not_authorized", Response.Status.FORBIDDEN);
            AuthorizationTokenService.fireErrorEvent(event, "access_denied", (Exception)((Object)notAuthorizedException));
            throw notAuthorizedException;
        }
        catch (CorsErrorResponseException | ErrorResponseException cause) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error while evaluating permissions", (Throwable)cause);
            }
            throw cause;
        }
        catch (Exception cause) {
            logger.error((Object)"Unexpected error while evaluating permissions", (Throwable)cause);
            throw new CorsErrorResponseException(request.getCors(), "server_error", "Unexpected error while evaluating permissions", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response createSuccessfulResponse(Object response, KeycloakAuthorizationRequest request) {
        return Cors.add(request.getHttpRequest(), Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response)).allowedOrigins(request.getKeycloakSession(), request.getKeycloakSession().getContext().getClient()).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private boolean isPublicClientRequestingEntitlementWithClaims(KeycloakAuthorizationRequest request) {
        return request.getClaimToken() != null && request.getKeycloakSession().getContext().getClient().isPublicClient() && request.getTicket() == null;
    }

    private Collection<Permission> evaluatePermissions(KeycloakAuthorizationRequest request, PermissionTicketToken ticket, ResourceServer resourceServer, EvaluationContext evaluationContext, KeycloakIdentity identity) {
        AuthorizationProvider authorization = request.getAuthorization();
        return authorization.evaluators().from(this.createPermissions(ticket, request, resourceServer, authorization, evaluationContext), evaluationContext).evaluate(resourceServer, (AuthorizationRequest)request);
    }

    private Collection<Permission> evaluateUserManagedPermissions(KeycloakAuthorizationRequest request, PermissionTicketToken ticket, ResourceServer resourceServer, EvaluationContext evaluationContext) {
        AuthorizationProvider authorization = request.getAuthorization();
        return ((PermissionTicketAwareDecisionResultCollector)authorization.evaluators().from(this.createPermissions(ticket, request, resourceServer, authorization, evaluationContext), evaluationContext).evaluate((Decision)new PermissionTicketAwareDecisionResultCollector((AuthorizationRequest)request, ticket, evaluationContext.getIdentity(), resourceServer, authorization))).results();
    }

    private Collection<Permission> evaluateAllPermissions(KeycloakAuthorizationRequest request, ResourceServer resourceServer, EvaluationContext evaluationContext) {
        AuthorizationProvider authorization = request.getAuthorization();
        return authorization.evaluators().from(evaluationContext, resourceServer, (AuthorizationRequest)request).evaluate(resourceServer, (AuthorizationRequest)request);
    }

    private AuthorizationResponse createAuthorizationResponse(KeycloakIdentity identity, Collection<Permission> entitlements, KeycloakAuthorizationRequest request, ClientModel targetClient) {
        DefaultClientSessionContext clientSessionCtx;
        UserSessionModel userSessionModel;
        KeycloakSession keycloakSession = request.getKeycloakSession();
        AccessToken accessToken = identity.getAccessToken();
        RealmModel realm = request.getRealm();
        UserSessionProvider sessions = keycloakSession.sessions();
        if (accessToken.getSessionState() == null) {
            UserModel user = TokenManager.lookupUserFromStatelessToken(keycloakSession, realm, accessToken);
            userSessionModel = sessions.createUserSession(KeycloakModelUtils.generateId(), realm, user, user.getUsername(), request.getClientConnection().getRemoteAddr(), "client_auth", false, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
        } else {
            userSessionModel = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)keycloakSession, () -> sessions.getUserSession(realm, accessToken.getSessionState()));
            if (userSessionModel == null) {
                userSessionModel = sessions.getOfflineUserSession(realm, accessToken.getSessionState());
            }
        }
        ClientModel client = realm.getClientByClientId(accessToken.getIssuedFor());
        AuthenticatedClientSessionModel clientSession = userSessionModel.getAuthenticatedClientSessionByClient(targetClient.getId());
        if (clientSession == null) {
            RootAuthenticationSessionModel rootAuthSession = keycloakSession.authenticationSessions().getRootAuthenticationSession(realm, userSessionModel.getId());
            if (rootAuthSession == null) {
                rootAuthSession = userSessionModel.getUser().getServiceAccountClientLink() == null ? keycloakSession.authenticationSessions().createRootAuthenticationSession(realm, userSessionModel.getId()) : new AuthenticationSessionManager(keycloakSession).createAuthenticationSession(realm, false);
            }
            AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(targetClient);
            authSession.setAuthenticatedUser(userSessionModel.getUser());
            authSession.setProtocol("openid-connect");
            authSession.setClientNote("iss", Urls.realmIssuer(keycloakSession.getContext().getUri().getBaseUri(), realm.getName()));
            AuthenticationManager.setClientScopesInSession(authSession);
            clientSessionCtx = TokenManager.attachAuthenticationSession(keycloakSession, userSessionModel, authSession);
        } else {
            clientSessionCtx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSession, keycloakSession);
        }
        TokenManager tokenManager = request.getTokenManager();
        EventBuilder event = request.getEvent();
        TokenManager.AccessTokenResponseBuilder responseBuilder = tokenManager.responseBuilder(realm, client, event, keycloakSession, userSessionModel, clientSessionCtx).generateAccessToken();
        AccessToken rpt = responseBuilder.getAccessToken();
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(entitlements);
        rpt.setAuthorization(authorization);
        if (accessToken.getSessionState() == null) {
            rpt.setSessionState(null);
        } else if (OIDCAdvancedConfigWrapper.fromClientModel(client).isUseRefreshToken()) {
            responseBuilder.generateRefreshToken();
            RefreshToken refreshToken = responseBuilder.getRefreshToken();
            refreshToken.issuedFor(client.getClientId());
            refreshToken.setAuthorization(authorization);
        }
        if (!rpt.hasAudience(targetClient.getClientId())) {
            rpt.audience(new String[]{targetClient.getClientId()});
        }
        return new AuthorizationResponse(responseBuilder.build(), this.isUpgraded(request, authorization));
    }

    private boolean isUpgraded(AuthorizationRequest request, AccessToken.Authorization authorization) {
        Collection previousPermissions;
        AccessToken previousRpt = request.getRpt();
        if (previousRpt == null) {
            return false;
        }
        AccessToken.Authorization previousAuthorization = previousRpt.getAuthorization();
        if (previousAuthorization != null && (previousPermissions = previousAuthorization.getPermissions()) != null) {
            for (Permission previousPermission : previousPermissions) {
                if (authorization.getPermissions().contains(previousPermission)) continue;
                return false;
            }
        }
        return true;
    }

    private PermissionTicketToken getPermissionTicket(KeycloakAuthorizationRequest request) {
        if (request.getTicket() != null) {
            return this.verifyPermissionTicket(request);
        }
        PermissionTicketToken permissions = request.getPermissions();
        permissions.issuedFor(request.getAudience());
        return permissions;
    }

    private ResourceServer getResourceServer(PermissionTicketToken ticket, KeycloakAuthorizationRequest request) {
        AuthorizationProvider authorization = request.getAuthorization();
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
        String issuedFor = ticket.getIssuedFor();
        if (issuedFor == null) {
            CorsErrorResponseException missingIssuedForException = new CorsErrorResponseException(request.getCors(), "invalid_request", "You must provide the issuedFor", Response.Status.BAD_REQUEST);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_request", (Exception)((Object)missingIssuedForException));
            throw missingIssuedForException;
        }
        ClientModel clientModel = request.getRealm().getClientByClientId(issuedFor);
        if (clientModel == null) {
            CorsErrorResponseException unknownServerIdException = new CorsErrorResponseException(request.getCors(), "invalid_request", "Unknown resource server id: [" + issuedFor + "]", Response.Status.BAD_REQUEST);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_request", (Exception)((Object)unknownServerIdException));
            throw unknownServerIdException;
        }
        ResourceServer resourceServer = resourceServerStore.findByClient(clientModel);
        if (resourceServer == null) {
            CorsErrorResponseException unsupportedPermissionsException = new CorsErrorResponseException(request.getCors(), "invalid_request", "Client does not support permissions", Response.Status.BAD_REQUEST);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_request", (Exception)((Object)unsupportedPermissionsException));
            throw unsupportedPermissionsException;
        }
        return resourceServer;
    }

    private EvaluationContext createEvaluationContext(KeycloakAuthorizationRequest request) {
        BiFunction<KeycloakAuthorizationRequest, AuthorizationProvider, EvaluationContext> evaluationContextProvider;
        String claimTokenFormat = request.getClaimTokenFormat();
        if (claimTokenFormat == null) {
            claimTokenFormat = CLAIM_TOKEN_FORMAT_JWT;
        }
        if ((evaluationContextProvider = SUPPORTED_CLAIM_TOKEN_FORMATS.get(claimTokenFormat)) == null) {
            CorsErrorResponseException unsupportedClaimTokenFormatException = new CorsErrorResponseException(request.getCors(), "invalid_request", "Claim token format [" + claimTokenFormat + "] not supported", Response.Status.BAD_REQUEST);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_request", (Exception)((Object)unsupportedClaimTokenFormatException));
            throw unsupportedClaimTokenFormatException;
        }
        return evaluationContextProvider.apply(request, request.getAuthorization());
    }

    private Collection<ResourcePermission> createPermissions(PermissionTicketToken ticket, KeycloakAuthorizationRequest request, ResourceServer resourceServer, AuthorizationProvider authorization, EvaluationContext context) {
        KeycloakIdentity identity = (KeycloakIdentity)context.getIdentity();
        StoreFactory storeFactory = authorization.getStoreFactory();
        LinkedHashMap<String, ResourcePermission> permissionsToEvaluate = new LinkedHashMap<String, ResourcePermission>();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        ScopeStore scopeStore = storeFactory.getScopeStore();
        AuthorizationRequest.Metadata metadata = request.getMetadata();
        AtomicInteger limit = metadata != null && metadata.getLimit() != null ? new AtomicInteger(metadata.getLimit()) : null;
        for (Permission permission : ticket.getPermissions()) {
            if (limit != null && limit.get() <= 0) break;
            Set<Scope> requestedScopesModel = this.resolveRequestedScopes(request, resourceServer, scopeStore, permission);
            String resourceId = permission.getResourceId();
            if (resourceId != null) {
                this.resolveResourcePermission(request, resourceServer, identity, authorization, storeFactory, permissionsToEvaluate, resourceStore, limit, permission, requestedScopesModel, resourceId);
                continue;
            }
            this.resolveScopePermissions(request, resourceServer, authorization, permissionsToEvaluate, resourceStore, limit, requestedScopesModel);
        }
        this.resolvePreviousGrantedPermissions(request, resourceServer, permissionsToEvaluate, resourceStore, scopeStore, limit);
        return permissionsToEvaluate.values();
    }

    private void resolvePreviousGrantedPermissions(KeycloakAuthorizationRequest request, ResourceServer resourceServer, Map<String, ResourcePermission> permissionsToEvaluate, ResourceStore resourceStore, ScopeStore scopeStore, AtomicInteger limit) {
        Collection permissions;
        AccessToken.Authorization authorizationData;
        AccessToken rpt = request.getRpt();
        RealmModel realm = resourceServer.getRealm();
        if (rpt != null && rpt.isActive() && (authorizationData = rpt.getAuthorization()) != null && (permissions = authorizationData.getPermissions()) != null) {
            for (Permission grantedPermission : permissions) {
                if (limit != null && limit.get() <= 0) break;
                Resource resource = resourceStore.findById(realm, resourceServer, grantedPermission.getResourceId());
                if (resource == null) continue;
                ResourcePermission permission = permissionsToEvaluate.get(resource.getId());
                if (permission == null) {
                    permission = new ResourcePermission(resource, new ArrayList(), resourceServer, grantedPermission.getClaims());
                    permissionsToEvaluate.put(resource.getId(), permission);
                    if (limit != null) {
                        limit.decrementAndGet();
                    }
                } else if (grantedPermission.getClaims() != null) {
                    for (Map.Entry entry : grantedPermission.getClaims().entrySet()) {
                        Set claims = (Set)permission.getClaims().get(entry.getKey());
                        if (claims == null) continue;
                        claims.addAll((Collection)entry.getValue());
                    }
                }
                for (String string : grantedPermission.getScopes()) {
                    Scope scope = scopeStore.findByName(resourceServer, string);
                    if (scope == null || permission.getScopes().contains(scope)) continue;
                    permission.getScopes().add(scope);
                }
            }
        }
    }

    private void resolveScopePermissions(KeycloakAuthorizationRequest request, ResourceServer resourceServer, AuthorizationProvider authorization, Map<String, ResourcePermission> permissionsToEvaluate, ResourceStore resourceStore, AtomicInteger limit, Set<Scope> requestedScopesModel) {
        AtomicBoolean processed = new AtomicBoolean();
        resourceStore.findByScopes(resourceServer, requestedScopesModel, resource -> {
            if (limit != null && limit.get() <= 0) {
                return;
            }
            ResourcePermission perm = (ResourcePermission)permissionsToEvaluate.get(resource.getId());
            if (perm == null) {
                perm = Permissions.createResourcePermissions((Resource)resource, (ResourceServer)resourceServer, (Collection)requestedScopesModel, (AuthorizationProvider)authorization, (AuthorizationRequest)request);
                permissionsToEvaluate.put(resource.getId(), perm);
                if (limit != null) {
                    limit.decrementAndGet();
                }
            } else {
                for (Scope scope : requestedScopesModel) {
                    perm.addScope(scope);
                }
            }
            processed.compareAndSet(false, true);
        });
        if (!processed.get()) {
            for (Scope scope : requestedScopesModel) {
                if (limit != null && limit.getAndDecrement() <= 0) break;
                permissionsToEvaluate.computeIfAbsent(scope.getId(), s -> new ResourcePermission(null, new ArrayList<Scope>(Arrays.asList(scope)), resourceServer, request.getClaims()));
            }
        }
    }

    private void resolveResourcePermission(KeycloakAuthorizationRequest request, ResourceServer resourceServer, KeycloakIdentity identity, AuthorizationProvider authorization, StoreFactory storeFactory, Map<String, ResourcePermission> permissionsToEvaluate, ResourceStore resourceStore, AtomicInteger limit, Permission permission, Set<Scope> requestedScopesModel, String resourceId) {
        String resourceType;
        Resource resource = resourceId.indexOf(45) != -1 ? resourceStore.findById(resourceServer.getRealm(), resourceServer, resourceId) : null;
        if (resource != null) {
            this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, resource);
        } else if (resourceId.startsWith("resource-type:")) {
            resourceType = resourceId.substring("resource-type:".length());
            resourceStore.findByType(resourceServer, resourceType, resourceServer.getClientId(), resource1 -> this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, (Resource)resource1));
        } else if (resourceId.startsWith("resource-type-any:")) {
            resourceType = resourceId.substring("resource-type-any:".length());
            resourceStore.findByType(resourceServer, resourceType, null, resource12 -> this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, (Resource)resource12));
        } else if (resourceId.startsWith("resource-type-instance:")) {
            resourceType = resourceId.substring("resource-type-instance:".length());
            resourceStore.findByTypeInstance(resourceServer, resourceType, resource13 -> this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, (Resource)resource13));
        } else if (resourceId.startsWith("resource-type-owner:")) {
            resourceType = resourceId.substring("resource-type-owner:".length());
            resourceStore.findByType(resourceServer, resourceType, identity.getId(), resource14 -> this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, (Resource)resource14));
        } else {
            Resource ownerResource = resourceStore.findByName(resourceServer, resourceId, identity.getId());
            if (ownerResource != null) {
                permission.setResourceId(ownerResource.getId());
                this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, ownerResource);
            }
            if (!identity.isResourceServer() || !identity.getId().equals(resourceServer.getClientId())) {
                Resource serverResource;
                List tickets = storeFactory.getPermissionTicketStore().findGranted(resourceServer, resourceId, identity.getId());
                if (!tickets.isEmpty()) {
                    ArrayList<Scope> scopes = new ArrayList<Scope>();
                    Resource grantedResource = null;
                    for (PermissionTicket permissionTicket : tickets) {
                        if (grantedResource == null) {
                            grantedResource = permissionTicket.getResource();
                        }
                        scopes.add(permissionTicket.getScope());
                    }
                    requestedScopesModel.retainAll(scopes);
                    ResourcePermission resourcePermission = this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, grantedResource);
                    resourcePermission.setGranted(true);
                }
                if ((serverResource = resourceStore.findByName(resourceServer, resourceId)) != null) {
                    permission.setResourceId(serverResource.getId());
                    this.addPermission(request, resourceServer, authorization, permissionsToEvaluate, limit, requestedScopesModel, serverResource);
                }
            }
        }
        if (permissionsToEvaluate.isEmpty()) {
            CorsErrorResponseException invalidResourceException = new CorsErrorResponseException(request.getCors(), "invalid_resource", "Resource with id [" + resourceId + "] does not exist.", Response.Status.BAD_REQUEST);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_request", (Exception)((Object)invalidResourceException));
            throw invalidResourceException;
        }
    }

    private Set<Scope> resolveRequestedScopes(KeycloakAuthorizationRequest request, ResourceServer resourceServer, ScopeStore scopeStore, Permission permission) {
        String clientAdditionalScopes = request.getScope();
        HashSet<String> requestedScopes = permission.getScopes();
        if (permission.getScopes() == null) {
            requestedScopes = new HashSet<String>();
        }
        if (clientAdditionalScopes != null) {
            requestedScopes.addAll(Arrays.asList(clientAdditionalScopes.split(" ")));
        }
        Set<Scope> requestedScopesModel = requestedScopes.stream().map(s -> scopeStore.findByName(resourceServer, s)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!requestedScopes.isEmpty() && requestedScopesModel.isEmpty()) {
            CorsErrorResponseException invalidScopeException = new CorsErrorResponseException(request.getCors(), "invalid_scope", "One of the given scopes " + permission.getScopes() + " is invalid", Response.Status.BAD_REQUEST);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_request", (Exception)((Object)invalidScopeException));
            throw invalidScopeException;
        }
        return requestedScopesModel;
    }

    private ResourcePermission addPermission(KeycloakAuthorizationRequest request, ResourceServer resourceServer, AuthorizationProvider authorization, Map<String, ResourcePermission> permissionsToEvaluate, AtomicInteger limit, Set<Scope> requestedScopesModel, Resource resource) {
        ResourcePermission permission = permissionsToEvaluate.get(resource.getId());
        if (permission == null) {
            permission = new ResourcePermission(resource, (Collection)Permissions.resolveScopes((Resource)resource, (ResourceServer)resourceServer, requestedScopesModel, (AuthorizationProvider)authorization), resourceServer, request.getClaims());
            if (!requestedScopesModel.isEmpty() && permission.getScopes().isEmpty()) {
                return null;
            }
            permissionsToEvaluate.put(resource.getId(), permission);
            if (limit != null) {
                limit.decrementAndGet();
            }
        }
        return permission;
    }

    private PermissionTicketToken verifyPermissionTicket(KeycloakAuthorizationRequest request) {
        String ticketString = request.getTicket();
        PermissionTicketToken ticket = (PermissionTicketToken)request.getKeycloakSession().tokens().decode(ticketString, PermissionTicketToken.class);
        if (ticket == null) {
            CorsErrorResponseException ticketVerificationException = new CorsErrorResponseException(request.getCors(), "invalid_ticket", "Ticket verification failed", Response.Status.FORBIDDEN);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_permission_ticket", (Exception)((Object)ticketVerificationException));
            throw ticketVerificationException;
        }
        if (!ticket.isActive()) {
            CorsErrorResponseException invalidTicketException = new CorsErrorResponseException(request.getCors(), "invalid_ticket", "Invalid permission ticket.", Response.Status.FORBIDDEN);
            AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_permission_ticket", (Exception)((Object)invalidTicketException));
            throw invalidTicketException;
        }
        return ticket;
    }

    private boolean isGranted(PermissionTicketToken ticket, AuthorizationRequest request, Collection<Permission> permissions) {
        List requestedPermissions = ticket.getPermissions();
        if (request.getRpt() != null && !requestedPermissions.isEmpty() && requestedPermissions.stream().anyMatch(permission -> !permissions.contains(permission))) {
            return false;
        }
        return !permissions.isEmpty();
    }

    static {
        SUPPORTED_CLAIM_TOKEN_FORMATS.put(CLAIM_TOKEN_FORMAT_JWT, (request, authorization) -> {
            KeycloakIdentity identity;
            Map claims = request.getClaims();
            String claimToken = request.getClaimToken();
            if (claimToken != null) {
                try {
                    claims = (Map)JsonSerialization.readValue((byte[])Base64Url.decode((String)request.getClaimToken()), Map.class);
                    request.setClaims(claims);
                }
                catch (Exception cause) {
                    throw new CorsErrorResponseException(request.getCors(), "invalid_request", "Invalid claims", Response.Status.BAD_REQUEST);
                }
            }
            try {
                identity = new KeycloakIdentity(authorization.getKeycloakSession(), (IDToken)Tokens.getAccessToken(request.getSubjectToken(), authorization.getKeycloakSession()));
            }
            catch (Exception cause) {
                AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_token", cause);
                throw new CorsErrorResponseException(request.getCors(), "unauthorized_client", "Invalid identity", Response.Status.BAD_REQUEST);
            }
            return new DefaultEvaluationContext(identity, claims, authorization.getKeycloakSession());
        });
        SUPPORTED_CLAIM_TOKEN_FORMATS.put(CLAIM_TOKEN_FORMAT_ID_TOKEN, (request, authorization) -> {
            KeycloakIdentity identity;
            IDToken idToken;
            KeycloakSession keycloakSession = authorization.getKeycloakSession();
            String subjectToken = request.getSubjectToken();
            if (subjectToken == null) {
                throw new CorsErrorResponseException(request.getCors(), "invalid_request", "Subject token can not be null and must be a valid ID or Access Token", Response.Status.BAD_REQUEST);
            }
            try {
                idToken = new TokenManager().verifyIDTokenSignature(keycloakSession, subjectToken);
            }
            catch (Exception cause) {
                AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_signature", cause);
                throw new CorsErrorResponseException(request.getCors(), "unauthorized_client", "Invalid signature", Response.Status.BAD_REQUEST);
            }
            try {
                identity = new KeycloakIdentity(keycloakSession, idToken);
            }
            catch (Exception cause) {
                AuthorizationTokenService.fireErrorEvent(request.getEvent(), "invalid_token", cause);
                throw new CorsErrorResponseException(request.getCors(), "unauthorized_client", "Invalid identity", Response.Status.BAD_REQUEST);
            }
            return new DefaultEvaluationContext(identity, request.getClaims(), keycloakSession);
        });
        INSTANCE = new AuthorizationTokenService();
    }

    public static class KeycloakAuthorizationRequest
    extends AuthorizationRequest {
        private final AuthorizationProvider authorization;
        private final TokenManager tokenManager;
        private final EventBuilder event;
        private final HttpRequest httpRequest;
        private final Cors cors;
        private final ClientConnection clientConnection;

        public KeycloakAuthorizationRequest(AuthorizationProvider authorization, TokenManager tokenManager, EventBuilder event, HttpRequest request, Cors cors, ClientConnection clientConnection) {
            this.authorization = authorization;
            this.tokenManager = tokenManager;
            this.event = event;
            this.httpRequest = request;
            this.cors = cors;
            this.clientConnection = clientConnection;
        }

        TokenManager getTokenManager() {
            return this.tokenManager;
        }

        EventBuilder getEvent() {
            return this.event;
        }

        HttpRequest getHttpRequest() {
            return this.httpRequest;
        }

        AuthorizationProvider getAuthorization() {
            return this.authorization;
        }

        Cors getCors() {
            return this.cors;
        }

        KeycloakSession getKeycloakSession() {
            return this.getAuthorization().getKeycloakSession();
        }

        RealmModel getRealm() {
            return this.getKeycloakSession().getContext().getRealm();
        }

        ClientConnection getClientConnection() {
            return this.clientConnection;
        }
    }
}

