/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPGroup;

public class UPConfig {
    private List<UPAttribute> attributes;
    private List<UPGroup> groups;

    public List<UPAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<UPAttribute> attributes) {
        this.attributes = attributes;
    }

    public UPConfig addAttribute(UPAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<UPAttribute>();
        }
        this.attributes.add(attribute);
        return this;
    }

    public List<UPGroup> getGroups() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        return this.groups;
    }

    public void setGroups(List<UPGroup> groups) {
        this.groups = groups;
    }

    public UPConfig addGroup(UPGroup group) {
        if (this.groups == null) {
            this.groups = new ArrayList<UPGroup>();
        }
        this.groups.add(group);
        return this;
    }

    @JsonIgnore
    public UPAttribute getAttribute(String name) {
        for (UPAttribute attribute : this.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public String toString() {
        return "UPConfig [attributes=" + this.attributes + ", groups=" + this.groups + "]";
    }
}

