/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class UsernameMutationValidator
implements SimpleValidator {
    public static final String ID = "up-username-mutation";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values = (List)input;
        if (values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        if (Validation.isBlank(value)) {
            return context;
        }
        AttributeContext attributeContext = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext();
        UserModel user = attributeContext.getUser();
        RealmModel realm = context.getSession().getContext().getRealm();
        if (!KeycloakModelUtils.isUsernameCaseSensitive((RealmModel)realm)) {
            value = value.toLowerCase();
        }
        if (!realm.isEditUsernameAllowed() && user != null && !value.equals(user.getFirstAttribute("username"))) {
            if (realm.isRegistrationEmailAsUsername() && UserProfileContext.UPDATE_PROFILE.equals((Object)attributeContext.getContext())) {
                return context;
            }
            context.addError(new ValidationError(ID, inputHint, "readOnlyUsernameMessage"));
        }
        return context;
    }
}

