/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;

public class EventBuilder {
    private static final Logger log = Logger.getLogger(EventBuilder.class);
    private EventStoreProvider store;
    private List<EventListenerProvider> listeners;
    private RealmModel realm;
    private Event event;

    public EventBuilder(RealmModel realm, KeycloakSession session, ClientConnection clientConnection) {
        this.realm = realm;
        this.event = new Event();
        if (realm.isEventsEnabled()) {
            EventStoreProvider store = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            if (store != null) {
                this.store = store;
            } else {
                log.error((Object)"Events enabled, but no event store provider configured");
            }
        }
        this.listeners = realm.getEventsListenersStream().map(id -> {
            EventListenerProvider listener = (EventListenerProvider)session.getProvider(EventListenerProvider.class, id);
            if (listener != null) {
                return listener;
            }
            log.error((Object)("Event listener '" + id + "' registered, but provider not found"));
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.realm(realm);
        this.ipAddress(clientConnection.getRemoteAddr());
    }

    private EventBuilder(EventStoreProvider store, List<EventListenerProvider> listeners, RealmModel realm, Event event) {
        this.store = store;
        this.listeners = listeners;
        this.realm = realm;
        this.event = event;
    }

    public EventBuilder realm(RealmModel realm) {
        this.event.setRealmId(realm == null ? null : realm.getId());
        return this;
    }

    public EventBuilder realm(String realmId) {
        this.event.setRealmId(realmId);
        return this;
    }

    public EventBuilder client(ClientModel client) {
        this.event.setClientId(client == null ? null : client.getClientId());
        return this;
    }

    public EventBuilder client(String clientId) {
        this.event.setClientId(clientId);
        return this;
    }

    public EventBuilder user(UserModel user) {
        this.event.setUserId(user == null ? null : user.getId());
        return this;
    }

    public EventBuilder user(String userId) {
        this.event.setUserId(userId);
        return this;
    }

    public EventBuilder session(UserSessionModel session) {
        this.event.setSessionId(session == null ? null : session.getId());
        return this;
    }

    public EventBuilder session(String sessionId) {
        this.event.setSessionId(sessionId);
        return this;
    }

    public EventBuilder ipAddress(String ipAddress) {
        this.event.setIpAddress(ipAddress);
        return this;
    }

    public EventBuilder event(EventType e) {
        this.event.setType(e);
        return this;
    }

    public EventBuilder detail(String key, String value) {
        if (value == null || value.equals("")) {
            return this;
        }
        if (this.event.getDetails() == null) {
            this.event.setDetails(new HashMap<String, String>());
        }
        this.event.getDetails().put(key, value);
        return this;
    }

    public EventBuilder detail(String key, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        return this.detail(key, values.stream().filter(Objects::nonNull).collect(Collectors.joining("::")));
    }

    public EventBuilder detail(String key, Stream<String> values) {
        if (values == null) {
            return this;
        }
        return this.detail(key, values.filter(Objects::nonNull).collect(Collectors.joining("::")));
    }

    public EventBuilder removeDetail(String key) {
        if (this.event.getDetails() != null) {
            this.event.getDetails().remove(key);
        }
        return this;
    }

    public Event getEvent() {
        return this.event;
    }

    public void success() {
        this.send();
    }

    public void error(String error) {
        if (Objects.isNull((Object)this.event.getType())) {
            throw new IllegalStateException("Attempted to define event error without first setting the event type");
        }
        if (!this.event.getType().name().endsWith("_ERROR")) {
            this.event.setType(EventType.valueOf(this.event.getType().name() + "_ERROR"));
        }
        this.event.setError(error);
        this.send();
    }

    public EventBuilder clone() {
        return new EventBuilder(this.store, this.listeners, this.realm, this.event.clone());
    }

    private void send() {
        Set eventTypes;
        this.event.setTime(Time.currentTimeMillis());
        this.event.setId(UUID.randomUUID().toString());
        if (this.store != null && (!(eventTypes = this.realm.getEnabledEventTypesStream().collect(Collectors.toSet())).isEmpty() ? eventTypes.contains(this.event.getType().name()) : this.event.getType().isSaveByDefault())) {
            this.store.onEvent(this.event);
        }
        if (this.listeners != null) {
            for (EventListenerProvider l : this.listeners) {
                try {
                    l.onEvent(this.event);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to send type to " + l), t);
                }
            }
        }
    }
}

