/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;

public class EntityField {
    public final String name;
    public final String descriptor;
    public String signature;
    public final Set<EntityFieldAnnotation> annotations = new HashSet<EntityFieldAnnotation>(2);

    public EntityField(String name, String descriptor) {
        this.name = name;
        this.descriptor = descriptor;
    }

    public String getGetterName() {
        return JavaBeanUtil.getGetterName((String)this.name, (String)this.descriptor);
    }

    public String getSetterName() {
        return JavaBeanUtil.getSetterName((String)this.name);
    }

    public boolean hasAnnotation(String descriptor) {
        for (EntityFieldAnnotation fieldAnnotation : this.annotations) {
            if (!fieldAnnotation.descriptor.equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public static class EntityFieldAnnotation {
        public final String descriptor;
        public final Map<String, Object> attributes = new HashMap<String, Object>(2);
        public final List<EntityFieldAnnotation> nestedAnnotations = new ArrayList<EntityFieldAnnotation>(2);

        public EntityFieldAnnotation(String desc) {
            this.descriptor = desc;
        }

        public void writeToVisitor(MethodVisitor mv) {
            AnnotationVisitor av = mv.visitAnnotation(this.descriptor, true);
            for (Map.Entry<String, Object> e : this.attributes.entrySet()) {
                av.visit(e.getKey(), e.getValue());
            }
            if (!this.nestedAnnotations.isEmpty()) {
                AnnotationVisitor nestedVisitor = av.visitArray("value");
                for (EntityFieldAnnotation nestedAnno : this.nestedAnnotations) {
                    AnnotationVisitor arrayAnnoVisitor = nestedVisitor.visitAnnotation(null, nestedAnno.descriptor);
                    for (Map.Entry<String, Object> e : nestedAnno.attributes.entrySet()) {
                        arrayAnnoVisitor.visit(e.getKey(), e.getValue());
                    }
                    arrayAnnoVisitor.visitEnd();
                }
                nestedVisitor.visitEnd();
            }
            av.visitEnd();
        }
    }
}

