/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.check;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.jboss.byteman.agent.check.BytecodeChecker;

public class CheckerCache {
    private final String DUMPSTATS = "org.jboss.byteman.checker.dumpstats";
    private final boolean dumpstats = Boolean.valueOf(System.getProperty("org.jboss.byteman.checker.dumpstats"));
    private WeakHashMap<ClassLoader, HashMap<String, BytecodeChecker>> loaderMaps = new WeakHashMap();
    private final CheckerStats stats = this.dumpstats ? new CheckerStats() : null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytecodeChecker lookup(ClassLoader loader, String name) {
        HashMap<String, BytecodeChecker> loaderMap = null;
        AbstractMap abstractMap = this.loaderMaps;
        synchronized (abstractMap) {
            loaderMap = this.loaderMaps.get(loader);
            if (loaderMap == null) {
                return null;
            }
        }
        abstractMap = loaderMap;
        synchronized (abstractMap) {
            BytecodeChecker checker = loaderMap.get(name);
            if (this.dumpstats && checker != null) {
                this.stats.record_hit(loader, name, checker);
            }
            return checker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ClassLoader loader, String name, BytecodeChecker checker) {
        HashMap<String, BytecodeChecker> loaderMap = null;
        AbstractMap abstractMap = this.loaderMaps;
        synchronized (abstractMap) {
            loaderMap = this.loaderMaps.get(loader);
            if (loaderMap == null) {
                loaderMap = new HashMap();
                this.loaderMaps.put(loader, loaderMap);
                if (this.dumpstats) {
                    this.stats.record_map(loader);
                }
            }
        }
        abstractMap = loaderMap;
        synchronized (abstractMap) {
            loaderMap.put(name, checker);
            if (this.dumpstats && checker != null) {
                this.stats.record_put(loader, name, checker);
            }
        }
    }

    private static class CheckerStats {
        private long maps = 0L;
        private long classes = 0L;
        private long bytes = 0L;
        private long hits = 0L;
        private long hit_bytes = 0L;

        public synchronized void record_hit(ClassLoader loader, String name, BytecodeChecker checker) {
            ++this.hits;
            this.hit_bytes += (long)checker.getBytesize();
            this.dump("Hit: ", loader, name);
        }

        public synchronized void record_map(ClassLoader loader) {
            ++this.maps;
        }

        public synchronized void record_put(ClassLoader loader, String name, BytecodeChecker checker) {
            ++this.classes;
            this.bytes += (long)checker.getBytesize();
            this.dump("Put:", loader, name);
        }

        public void dump(String prefix, ClassLoader loader, String name) {
            System.out.format("\n  *** %s %s (%s)\n  ***maps %d classes %d bytes %d hits %d hit bytes %d\n", prefix, name, loader != null ? loader.toString() : "null", this.maps, this.classes, this.bytes, this.hits, this.hit_bytes);
        }
    }
}

