/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.UnaryOperExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class TwiddleExpression
extends UnaryOperExpression {
    public TwiddleExpression(Rule rule, ParseNode token, Expression operand) {
        super(rule, 65568, operand.getType(), token, operand);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.type = this.getOperand(0).typeCheck(Type.N);
        if (this.type == Type.F || this.type == Type.D) {
            this.type = Type.J;
        }
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("TwiddleExpression.typeCheck() : invalid result type : " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            Number value = (Number)this.getOperand(0).interpret(helper);
            if (this.type == Type.B) {
                return (byte)(~value.intValue());
            }
            if (this.type == Type.S) {
                return (short)(~value.intValue());
            }
            if (this.type == Type.I) {
                return ~value.intValue();
            }
            if (this.type == Type.J) {
                return value.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return ~value.intValue();
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("TwiddleExpression.typeCheck() : unexpected exception : " + this.token.getText() + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper = this.getOperand(0);
        Type operType = oper.getType();
        int currentStack = compileContext.getStackCount();
        int expected = 0;
        oper.compile(mv, compileContext);
        compileContext.addStackCount(operType.getNBytes() > 4 ? 2 : 1);
        compileContext.compileTypeConversion(operType, this.type);
        if (this.type == Type.B) {
            expected = 1;
            mv.visitInsn(4);
            mv.visitInsn(130);
            mv.visitInsn(145);
        } else if (this.type == Type.S) {
            expected = 1;
            mv.visitInsn(4);
            mv.visitInsn(130);
            mv.visitInsn(147);
        } else if (this.type == Type.C) {
            expected = 1;
            mv.visitInsn(4);
            mv.visitInsn(130);
            mv.visitInsn(146);
        } else if (this.type == Type.I) {
            expected = 1;
            mv.visitInsn(4);
            mv.visitInsn(130);
        } else if (this.type == Type.J) {
            expected = 2;
            mv.visitInsn(10);
            mv.visitInsn(131);
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("MinusExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

