/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.common.delegate.HasDelegateProvider;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserEntityFields;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;

public class MapUserEntityDelegate
implements MapUserEntity,
HasDelegateProvider<MapUserEntity> {
    private final DelegateProvider<MapUserEntity> delegateProvider;

    public MapUserEntityDelegate(DelegateProvider<MapUserEntity> delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public DelegateProvider<MapUserEntity> getDelegateProvider() {
        return this.delegateProvider;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.ATTRIBUTES, new Object[0]).getAttributes();
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ATTRIBUTES, attributes).setAttributes(attributes);
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.ATTRIBUTES, name).getAttribute(name);
    }

    @Override
    public void setAttribute(String name, List<String> value) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ATTRIBUTES, name, value).setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ATTRIBUTES, name).removeAttribute(name);
    }

    @Override
    public boolean isUpdated() {
        return this.delegateProvider.isUpdated();
    }

    @Override
    public String getId() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.ID, new Object[0]).getId();
    }

    @Override
    public void setId(String id) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ID, id).setId(id);
    }

    @Override
    public String getRealmId() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.REALM_ID, new Object[0]).getRealmId();
    }

    @Override
    public void setRealmId(String realmId) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.REALM_ID, realmId).setRealmId(realmId);
    }

    @Override
    public String getUsername() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.USERNAME, new Object[0]).getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.USERNAME, username).setUsername(username);
    }

    @Override
    public String getFirstName() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.FIRST_NAME, new Object[0]).getFirstName();
    }

    @Override
    public void setFirstName(String firstName) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.FIRST_NAME, firstName).setFirstName(firstName);
    }

    @Override
    public Long getCreatedTimestamp() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.CREATED_TIMESTAMP, new Object[0]).getCreatedTimestamp();
    }

    @Override
    public void setCreatedTimestamp(Long createdTimestamp) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.CREATED_TIMESTAMP, createdTimestamp).setCreatedTimestamp(createdTimestamp);
    }

    @Override
    public String getLastName() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.LAST_NAME, new Object[0]).getLastName();
    }

    @Override
    public void setLastName(String lastName) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.LAST_NAME, lastName).setLastName(lastName);
    }

    @Override
    public String getEmail() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.EMAIL, new Object[0]).getEmail();
    }

    @Override
    public void setEmail(String email) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.EMAIL, email).setEmail(email);
    }

    @Override
    public void setEmail(String email, boolean duplicateEmailsAllowed) {
        this.delegateProvider.getDelegate(false, null, email, duplicateEmailsAllowed).setEmail(email, duplicateEmailsAllowed);
    }

    @Override
    public Boolean isEnabled() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.ENABLED, new Object[0]).isEnabled();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ENABLED, enabled).setEnabled(enabled);
    }

    @Override
    public Boolean isEmailVerified() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.EMAIL_VERIFIED, new Object[0]).isEmailVerified();
    }

    @Override
    public void setEmailVerified(Boolean emailVerified) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.EMAIL_VERIFIED, emailVerified).setEmailVerified(emailVerified);
    }

    @Override
    public String getEmailConstraint() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.EMAIL_CONSTRAINT, new Object[0]).getEmailConstraint();
    }

    @Override
    public void setEmailConstraint(String emailConstraint) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.EMAIL_CONSTRAINT, emailConstraint).setEmailConstraint(emailConstraint);
    }

    @Override
    public Set<String> getRequiredActions() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.REQUIRED_ACTIONS, new Object[0]).getRequiredActions();
    }

    @Override
    public void setRequiredActions(Set<String> requiredActions) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.REQUIRED_ACTIONS, requiredActions).setRequiredActions(requiredActions);
    }

    @Override
    public void addRequiredAction(String requiredAction) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.REQUIRED_ACTIONS, requiredAction).addRequiredAction(requiredAction);
    }

    @Override
    public void removeRequiredAction(String requiredAction) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.REQUIRED_ACTIONS, requiredAction).removeRequiredAction(requiredAction);
    }

    @Override
    public List<MapUserCredentialEntity> getCredentials() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.CREDENTIALS, new Object[0]).getCredentials();
    }

    @Override
    public Optional<MapUserCredentialEntity> getCredential(String id) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.CREDENTIALS, id).getCredential(id);
    }

    @Override
    public void setCredentials(List<MapUserCredentialEntity> credentials) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.CREDENTIALS, credentials).setCredentials(credentials);
    }

    @Override
    public void addCredential(MapUserCredentialEntity credentialEntity) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.CREDENTIALS, credentialEntity).addCredential(credentialEntity);
    }

    @Override
    public Boolean removeCredential(MapUserCredentialEntity credentialEntity) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.CREDENTIALS, credentialEntity).removeCredential(credentialEntity);
    }

    @Override
    public Boolean removeCredential(String id) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.CREDENTIALS, id).removeCredential(id);
    }

    @Override
    public Boolean moveCredential(String credentialId, String newPreviousCredentialId) {
        return this.delegateProvider.getDelegate(true, null, credentialId, newPreviousCredentialId).moveCredential(credentialId, newPreviousCredentialId);
    }

    @Override
    public Set<MapUserFederatedIdentityEntity> getFederatedIdentities() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.FEDERATED_IDENTITIES, new Object[0]).getFederatedIdentities();
    }

    @Override
    public Optional<MapUserFederatedIdentityEntity> getFederatedIdentity(String identityProviderId) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.FEDERATED_IDENTITIES, identityProviderId).getFederatedIdentity(identityProviderId);
    }

    @Override
    public void setFederatedIdentities(Set<MapUserFederatedIdentityEntity> federatedIdentities) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.FEDERATED_IDENTITIES, federatedIdentities).setFederatedIdentities(federatedIdentities);
    }

    @Override
    public void addFederatedIdentity(MapUserFederatedIdentityEntity federatedIdentity) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.FEDERATED_IDENTITIES, federatedIdentity).addFederatedIdentity(federatedIdentity);
    }

    @Override
    public Boolean removeFederatedIdentity(MapUserFederatedIdentityEntity providerId) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.FEDERATED_IDENTITIES, providerId).removeFederatedIdentity(providerId);
    }

    @Override
    public Boolean removeFederatedIdentity(String identityProviderId) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.FEDERATED_IDENTITIES, identityProviderId).removeFederatedIdentity(identityProviderId);
    }

    @Override
    public Set<MapUserConsentEntity> getUserConsents() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.USER_CONSENTS, new Object[0]).getUserConsents();
    }

    @Override
    public Optional<MapUserConsentEntity> getUserConsent(String clientId) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.USER_CONSENTS, clientId).getUserConsent(clientId);
    }

    @Override
    public void setUserConsents(Set<MapUserConsentEntity> userConsentEntity) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.USER_CONSENTS, userConsentEntity).setUserConsents(userConsentEntity);
    }

    @Override
    public void addUserConsent(MapUserConsentEntity userConsentEntity) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.USER_CONSENTS, userConsentEntity).addUserConsent(userConsentEntity);
    }

    @Override
    public Boolean removeUserConsent(MapUserConsentEntity userConsentEntity) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.USER_CONSENTS, userConsentEntity).removeUserConsent(userConsentEntity);
    }

    @Override
    public Boolean removeUserConsent(String clientId) {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.USER_CONSENTS, clientId).removeUserConsent(clientId);
    }

    @Override
    public Set<String> getGroupsMembership() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.GROUPS_MEMBERSHIP, new Object[0]).getGroupsMembership();
    }

    @Override
    public void setGroupsMembership(Set<String> groupsMembership) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.GROUPS_MEMBERSHIP, groupsMembership).setGroupsMembership(groupsMembership);
    }

    @Override
    public void addGroupsMembership(String groupId) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.GROUPS_MEMBERSHIP, groupId).addGroupsMembership(groupId);
    }

    @Override
    public void removeGroupsMembership(String groupId) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.GROUPS_MEMBERSHIP, groupId).removeGroupsMembership(groupId);
    }

    @Override
    public Set<String> getRolesMembership() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.ROLES_MEMBERSHIP, new Object[0]).getRolesMembership();
    }

    @Override
    public void setRolesMembership(Set<String> rolesMembership) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ROLES_MEMBERSHIP, rolesMembership).setRolesMembership(rolesMembership);
    }

    @Override
    public void addRolesMembership(String roleId) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ROLES_MEMBERSHIP, roleId).addRolesMembership(roleId);
    }

    @Override
    public void removeRolesMembership(String roleId) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.ROLES_MEMBERSHIP, roleId).removeRolesMembership(roleId);
    }

    @Override
    public String getFederationLink() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.FEDERATION_LINK, new Object[0]).getFederationLink();
    }

    @Override
    public void setFederationLink(String federationLink) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.FEDERATION_LINK, federationLink).setFederationLink(federationLink);
    }

    @Override
    public String getServiceAccountClientLink() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.SERVICE_ACCOUNT_CLIENT_LINK, new Object[0]).getServiceAccountClientLink();
    }

    @Override
    public void setServiceAccountClientLink(String serviceAccountClientLink) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.SERVICE_ACCOUNT_CLIENT_LINK, serviceAccountClientLink).setServiceAccountClientLink(serviceAccountClientLink);
    }

    @Override
    public Long getNotBefore() {
        return this.delegateProvider.getDelegate(true, MapUserEntityFields.NOT_BEFORE, new Object[0]).getNotBefore();
    }

    @Override
    public void setNotBefore(Long notBefore) {
        this.delegateProvider.getDelegate(false, MapUserEntityFields.NOT_BEFORE, notBefore).setNotBefore(notBefore);
    }
}

