/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.account;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.json.StringListMapDeserializer;
import org.keycloak.representations.account.UserProfileMetadata;

public class UserRepresentation {
    private String id;
    private String username;
    private String firstName;
    private String lastName;
    private String email;
    private boolean emailVerified;
    private UserProfileMetadata userProfileMetadata;
    @JsonDeserialize(using=StringListMapDeserializer.class)
    private Map<String, List<String>> attributes;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public void singleAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, List<String>>();
        }
        this.attributes.put(name, value == null ? new ArrayList() : Arrays.asList(value));
    }

    public String firstAttribute(String key) {
        return this.attributes == null ? null : (this.attributes.containsKey(key) ? this.attributes.get(key).get(0) : null);
    }

    public Map<String, List<String>> toAttributes() {
        HashMap<String, List<String>> attrs = new HashMap<String, List<String>>();
        if (this.getAttributes() != null) {
            attrs.putAll(this.getAttributes());
        }
        if (this.getUsername() != null) {
            attrs.put("username", Collections.singletonList(this.getUsername()));
        } else {
            attrs.remove("username");
        }
        if (this.getEmail() != null) {
            attrs.put("email", Collections.singletonList(this.getEmail()));
        } else {
            attrs.remove("email");
        }
        if (this.getLastName() != null) {
            attrs.put("lastName", Collections.singletonList(this.getLastName()));
        }
        if (this.getFirstName() != null) {
            attrs.put("firstName", Collections.singletonList(this.getFirstName()));
        }
        return attrs;
    }

    public UserProfileMetadata getUserProfileMetadata() {
        return this.userProfileMetadata;
    }

    public void setUserProfileMetadata(UserProfileMetadata userProfileMetadata) {
        this.userProfileMetadata = userProfileMetadata;
    }
}

