/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.file.FileMapStorage;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.SearchableModelField;

public class FileMapKeycloakTransaction<V extends AbstractEntity & UpdatableEntity, M>
extends ConcurrentHashMapKeycloakTransaction<String, V, M> {
    private final List<Path> pathsToDelete = new LinkedList<Path>();
    private final Map<Path, Path> renameOnCommit = new HashMap<Path, Path>();
    private final String txId = StringKeyConverter.StringKey.INSTANCE.yieldNewUniqueKey();

    public static <V extends AbstractEntity & UpdatableEntity, M> FileMapKeycloakTransaction<V, M> newInstance(Class<V> entityClass, Function<String, Path> dataDirectoryFunc, Function<V, String[]> suggestedPath, boolean isExpirableEntity, Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<String, V, M>> fieldPredicates) {
        FileMapKeycloakTransaction<V, ? super M> tx;
        Crud<V, ? super M> crud = new Crud<V, M>(entityClass, dataDirectoryFunc, suggestedPath, isExpirableEntity, fieldPredicates);
        crud.tx = tx = new FileMapKeycloakTransaction<V, M>(entityClass, crud);
        return tx;
    }

    private FileMapKeycloakTransaction(Class<V> entityClass, Crud<V, M> crud) {
        super(crud, (StringKeyConverter)StringKeyConverter.StringKey.INSTANCE, DeepCloner.DUMB_CLONER, MapFieldPredicates.getPredicates((Class)ModelEntityUtil.getModelType(entityClass)), ModelEntityUtil.getRealmIdField(entityClass));
    }

    public void rollback() {
        this.renameOnCommit.keySet().forEach(FileMapKeycloakTransaction::silentDelete);
        this.pathsToDelete.forEach(FileMapKeycloakTransaction::silentDelete);
        super.rollback();
    }

    public void commit() {
        super.commit();
        this.renameOnCommit.forEach(FileMapKeycloakTransaction::move);
        this.pathsToDelete.forEach(FileMapKeycloakTransaction::silentDelete);
    }

    private static void move(Path from, Path to) {
        try {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void silentDelete(Path p) {
        try {
            if (Files.exists(p, new LinkOption[0])) {
                Files.delete(p);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void touch(Path path) throws FileAlreadyExistsException, IOException {
        Files.createFile(path, new FileAttribute[0]);
        this.pathsToDelete.add(path);
    }

    public boolean removeIfExists(Path path) {
        boolean res = !this.pathsToDelete.contains(path) && Files.exists(path, new LinkOption[0]);
        this.pathsToDelete.add(path);
        return res;
    }

    void registerRenameOnCommit(Path from, Path to) {
        this.renameOnCommit.put(from, to);
        this.pathsToDelete.remove(to);
        this.pathsToDelete.add(from);
    }

    public V registerEntityForChanges(V origEntity) {
        AbstractEntity watchedValue = super.registerEntityForChanges(origEntity);
        return (V)DeepCloner.DUMB_CLONER.entityFieldDelegate(watchedValue, (EntityFieldDelegate)new IdProtector(this, watchedValue));
    }

    private static class IdProtector
    extends EntityFieldDelegate.WithEntity<V> {
        final /* synthetic */ FileMapKeycloakTransaction this$0;

        public IdProtector(V entity) {
            this.this$0 = var1_1;
            super(entity);
        }

        public <T, EF extends Enum<? extends EntityField<V>>> void set(EF field, T value) {
            String id = ((AbstractEntity)this.entity).getId();
            super.set(field, value);
            if (!Objects.equals(id, this.this$0.map.determineKeyFromValue((AbstractEntity)this.entity, false))) {
                throw new ReadOnlyException("Cannot change " + field + " as that would change primary key");
            }
        }

        public String toString() {
            return super.toString() + " [protected ID]";
        }
    }

    private static class Crud<V extends AbstractEntity & UpdatableEntity, M>
    extends FileMapStorage.Crud<V, M> {
        private FileMapKeycloakTransaction tx;

        public Crud(Class<V> entityClass, Function<String, Path> dataDirectoryFunc, Function<V, String[]> suggestedPath, boolean isExpirableEntity, Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<String, V, M>> fieldPredicates) {
            super(entityClass, dataDirectoryFunc, suggestedPath, isExpirableEntity, fieldPredicates);
        }

        @Override
        protected void touch(Path sp) throws IOException {
            this.tx.touch(sp);
        }

        @Override
        protected void registerRenameOnCommit(Path from, Path to) {
            this.tx.registerRenameOnCommit(from, to);
        }

        @Override
        protected boolean removeIfExists(Path sp) {
            return this.tx.removeIfExists(sp);
        }

        @Override
        protected String getTxId() {
            return this.tx.txId;
        }
    }
}

