/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.map.storage.file.common.BlockContext;
import org.keycloak.models.map.storage.file.common.BlockContextStack;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.NodeEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.resolver.JsonScalarResolver;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;
import org.snakeyaml.engine.v2.scanner.StreamReader;

public class YamlParser<E> {
    private static final Logger LOG = Logger.getLogger(YamlParser.class);
    public static final String ARRAY_CONTEXT = "$@[]@$";
    private static final ScalarResolver RESOLVER = new JsonScalarResolver();
    private final Parser parser;
    private final BlockContextStack contextStack;
    private static final LoadSettings SETTINGS = LoadSettings.builder().setAllowRecursiveKeys(false).setParseComments(false).build();
    private static final EnumMap<Event.ID, Supplier<BlockContext<?>>> CONTEXT_CONSTRUCTORS = new EnumMap(Event.ID.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> E parse(Path path, BlockContext<E> initialContext) {
        LOG.tracef("parse(%s,%s)%s", (Object)path, initialContext, StackUtil.getShortStackTrace());
        Objects.requireNonNull(path, "Path invalid");
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            if (Files.size(path) == 0L) {
                E e = null;
                return e;
            }
            ParserImpl p = new ParserImpl(SETTINGS, new StreamReader(SETTINGS, (Reader)new YamlUnicodeReader(is)));
            E e = new YamlParser<E>((Parser)p, initialContext).parse();
            return e;
        }
        catch (IOException ex) {
            LOG.warn((Object)ex);
            return null;
        }
    }

    protected YamlParser(Parser p, BlockContext<E> initialContext) {
        this.parser = p;
        this.contextStack = new BlockContextStack(initialContext);
    }

    protected <E> E parse() {
        this.consumeEvent(Event.ID.StreamStart, "Expected a stream");
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            this.consumeEvent(Event.ID.DocumentStart, "Expected a document in the stream");
            this.parseNode();
            this.consumeEvent(Event.ID.DocumentEnd, "Expected a single document in the stream");
        }
        this.consumeEvent(Event.ID.StreamEnd, "Expected a single document in the stream");
        return (E)((BlockContext)this.contextStack.pop()).getResult();
    }

    protected Object parseNode() {
        if (this.parser.checkEvent(Event.ID.Alias)) {
            throw new IllegalStateException("Aliases are not handled at this moment");
        }
        Event ev = this.parser.next();
        if (!(ev instanceof NodeEvent)) {
            throw new IllegalArgumentException("Invalid event " + ev);
        }
        switch (ev.getEventId()) {
            case Scalar: {
                return this.parseScalar((ScalarEvent)ev);
            }
            case SequenceStart: {
                return this.parseSequence();
            }
            case MappingStart: {
                return this.parseMapping();
            }
        }
        throw new IllegalStateException("Event not expected " + ev);
    }

    protected Object parseSequence() {
        LOG.tracef("Parsing sequence", new Object[0]);
        BlockContext context = (BlockContext)this.contextStack.peek();
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            context.add(this.parseNodeInFreshContext(ARRAY_CONTEXT));
        }
        this.consumeEvent(Event.ID.SequenceEnd, "Expected end of sequence");
        return context.getResult();
    }

    protected Object parseMapping() {
        LOG.tracef("Parsing mapping", new Object[0]);
        BlockContext context = (BlockContext)this.contextStack.peek();
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            Object key = this.parseNodeInFreshContext();
            LOG.tracef("Parsed mapping key: %s", key);
            if (!(key instanceof String)) {
                throw new IllegalStateException("Invalid key in map: " + key);
            }
            Object value = this.parseNodeInFreshContext((String)key);
            LOG.tracef("Parsed mapping value: %s", value);
            context.add((String)key, value);
        }
        this.consumeEvent(Event.ID.MappingEnd, "Expected end of mapping");
        return context.getResult();
    }

    protected Object parseScalar(ScalarEvent se) {
        BlockContext context = (BlockContext)this.contextStack.peek();
        boolean implicit = se.getImplicit().canOmitTagInPlainScalar();
        Class<?> ot = context.getScalarType();
        Tag nodeTag = this.constructTag(se.getTag(), se.getValue(), implicit, ot);
        ScalarNode node = new ScalarNode(nodeTag, true, se.getValue(), se.getScalarStyle(), se.getStartMark(), se.getEndMark());
        Object value = MiniConstructor.INSTANCE.constructStandardJavaInstance(node);
        context.add(value);
        return context.getResult();
    }

    private Event consumeEvent(Event.ID expectedEventId, String message) throws IllegalArgumentException {
        if (!this.parser.checkEvent(expectedEventId)) {
            Event event = this.parser.next();
            throw new IllegalArgumentException(message + " at " + event.getStartMark());
        }
        return this.parser.next();
    }

    private static Tag constructTag(Optional<String> tag, String value, boolean implicit) {
        return tag.filter(t -> !"!".equals(t)).map(Tag::new).orElseGet(() -> RESOLVER.resolve(value, Boolean.valueOf(implicit)));
    }

    private Tag constructTag(Optional<String> tag, String value, boolean implicit, Class<?> ot) {
        if (ot == String.class) {
            return Tag.STR;
        }
        return YamlParser.constructTag(tag, value, implicit);
    }

    private Object parseNodeInFreshContext(String key) throws IllegalStateException {
        Supplier<BlockContext<?>> cc = CONTEXT_CONSTRUCTORS.get(this.parser.peekEvent().getEventId());
        if (cc == null) {
            throw new IllegalStateException("Invalid value in map with key " + key);
        }
        this.contextStack.push(key, cc);
        Object value = this.parseNode();
        this.contextStack.pop();
        return value;
    }

    private Object parseNodeInFreshContext() throws IllegalStateException {
        this.contextStack.push(BlockContext.DefaultObjectContext.newDefaultObjectContext());
        Object value = this.parseNode();
        this.contextStack.pop();
        return value;
    }

    static {
        CONTEXT_CONSTRUCTORS.put(Event.ID.Scalar, BlockContext.DefaultObjectContext::newDefaultObjectContext);
        CONTEXT_CONSTRUCTORS.put(Event.ID.SequenceStart, BlockContext.DefaultListContext::newDefaultListContext);
        CONTEXT_CONSTRUCTORS.put(Event.ID.MappingStart, BlockContext.DefaultMapContext::newDefaultMapContext);
    }

    private static final class MiniConstructor
    extends StandardConstructor {
        public static final MiniConstructor INSTANCE = new MiniConstructor();

        public MiniConstructor() {
            super(SETTINGS);
        }

        public Object constructStandardJavaInstance(ScalarNode node) {
            return this.findConstructorFor((Node)node).map(constructor -> constructor.construct((Node)node)).orElseThrow(() -> new ConstructorException(null, Optional.empty(), "could not determine a constructor for the tag " + node.getTag(), node.getStartMark()));
        }
    }
}

