/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.utility.ConfigurationFileImageNameSubstitutor;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.PrefixingImageNameSubstitutor;

final class DefaultImageNameSubstitutor
extends ImageNameSubstitutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageNameSubstitutor.class);
    private final ConfigurationFileImageNameSubstitutor configurationFileImageNameSubstitutor;
    private final PrefixingImageNameSubstitutor prefixingImageNameSubstitutor;

    public DefaultImageNameSubstitutor() {
        this.configurationFileImageNameSubstitutor = new ConfigurationFileImageNameSubstitutor();
        this.prefixingImageNameSubstitutor = new PrefixingImageNameSubstitutor();
    }

    @VisibleForTesting
    DefaultImageNameSubstitutor(ConfigurationFileImageNameSubstitutor configurationFileImageNameSubstitutor, PrefixingImageNameSubstitutor prefixingImageNameSubstitutor) {
        this.configurationFileImageNameSubstitutor = configurationFileImageNameSubstitutor;
        this.prefixingImageNameSubstitutor = prefixingImageNameSubstitutor;
    }

    @Override
    public DockerImageName apply(DockerImageName original) {
        return this.configurationFileImageNameSubstitutor.andThen(this.prefixingImageNameSubstitutor).apply(original);
    }

    @Override
    protected String getDescription() {
        return "DefaultImageNameSubstitutor (composite of '" + this.configurationFileImageNameSubstitutor.getDescription() + "' and '" + this.prefixingImageNameSubstitutor.getDescription() + "')";
    }
}

