/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class HSSFDateUtil {
    private static final BigDecimal DAY_MILLISECONDS = new BigDecimal(86400000);
    private static final int DAYS_TO_1900 = HSSFDateUtil.daysInPriorYears(1899) + 1;

    private HSSFDateUtil() {
    }

    public static int computeZeroDate(String config, boolean excelBugCompatible) {
        if ("1899".equals(config)) {
            return 2;
        }
        if ("1900".equals(config)) {
            return 0;
        }
        if (excelBugCompatible) {
            return -1461;
        }
        return -1460;
    }

    public static BigDecimal getExcelDate(Date date) {
        String dateSystem = LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ZeroDate", "1900");
        boolean excelBugCompatible = "true".equals(LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ExcelDateBugAware", "false"));
        return HSSFDateUtil.getExcelDate(date, excelBugCompatible, HSSFDateUtil.computeZeroDate(dateSystem, excelBugCompatible));
    }

    public static BigDecimal getExcelDate(Date date, boolean excelBugCompatible, int zeroDate) {
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTime(date);
        long time = calStart.get(11);
        time = time * 60L + (long)calStart.get(12);
        time = time * 60L + (long)calStart.get(13);
        time = time * 1000L + (long)calStart.get(14);
        BigDecimal fraction = new BigDecimal(time).divide(DAY_MILLISECONDS, 40, 4);
        int year = calStart.get(1);
        int daysInYear = calStart.get(6);
        if (excelBugCompatible) {
            if (zeroDate > 59) {
                if (year < 1900 || year == 1900 && daysInYear > 59) {
                    ++daysInYear;
                }
            } else if (year > 1900 || year == 1900 && daysInYear > 59) {
                ++daysInYear;
            }
        }
        int daysStart = HSSFDateUtil.daysInPriorYears(year - 1) - DAYS_TO_1900;
        int daysSinceYear = daysInYear + daysStart;
        return fraction.add(new BigDecimal(daysSinceYear + zeroDate));
    }

    private static int daysInPriorYears(int y) {
        return 365 * y + y / 4 - y / 100 + y / 400;
    }

    public static Date getJavaDate(BigDecimal date) {
        String dateSystem = LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ZeroDate", "1900");
        boolean excelBugCompatible = "true".equals(LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ExcelDateBugAware", "false"));
        return HSSFDateUtil.getJavaDate(date, excelBugCompatible, HSSFDateUtil.computeZeroDate(dateSystem, excelBugCompatible));
    }

    public static Date getJavaDate(BigDecimal date, boolean excelBugCompatible, int zeroDate) {
        int correction = 1;
        BigDecimal wholeDays = NumberUtil.performIntRounding(date);
        int wholeDaysInt = wholeDays.intValue() - zeroDate;
        if (excelBugCompatible && wholeDaysInt > 59) {
            correction = 0;
        }
        BigDecimal fractionNum = date.subtract(wholeDays);
        BigDecimal fraction = fractionNum.multiply(DAY_MILLISECONDS);
        GregorianCalendar calendar = new GregorianCalendar(1900, 0, wholeDaysInt + correction);
        calendar.set(14, fraction.setScale(0, 4).intValue());
        return calendar.getTime();
    }
}

