/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_state_t")
public class XXH32State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN_32;
    public static final int LARGE_LEN;
    public static final int V1;
    public static final int V2;
    public static final int V3;
    public static final int V4;
    public static final int MEM32;
    public static final int MEMSIZE;
    public static final int RESERVED;

    public XXH32State(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH32State.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH32_hash_t")
    public int total_len_32() {
        return XXH32State.ntotal_len_32(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int large_len() {
        return XXH32State.nlarge_len(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int v1() {
        return XXH32State.nv1(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int v2() {
        return XXH32State.nv2(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int v3() {
        return XXH32State.nv3(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int v4() {
        return XXH32State.nv4(this.address());
    }

    @NativeType(value="XXH32_hash_t[4]")
    public IntBuffer mem32() {
        return XXH32State.nmem32(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int mem32(int index) {
        return XXH32State.nmem32(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int memsize() {
        return XXH32State.nmemsize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved() {
        return XXH32State.nreserved(this.address());
    }

    public static XXH32State malloc() {
        return (XXH32State)XXH32State.wrap(XXH32State.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH32State calloc() {
        return (XXH32State)XXH32State.wrap(XXH32State.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH32State create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH32State)XXH32State.wrap(XXH32State.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH32State create(long address) {
        return (XXH32State)XXH32State.wrap(XXH32State.class, (long)address);
    }

    @Nullable
    public static XXH32State createSafe(long address) {
        return address == 0L ? null : (XXH32State)XXH32State.wrap(XXH32State.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH32State.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH32State.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH32State.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH32State.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH32State.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH32State.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH32State.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XXH32State mallocStack() {
        return XXH32State.mallocStack(MemoryStack.stackGet());
    }

    public static XXH32State callocStack() {
        return XXH32State.callocStack(MemoryStack.stackGet());
    }

    public static XXH32State mallocStack(MemoryStack stack) {
        return (XXH32State)XXH32State.wrap(XXH32State.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH32State callocStack(MemoryStack stack) {
        return (XXH32State)XXH32State.wrap(XXH32State.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH32State.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH32State.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH32State.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH32State.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntotal_len_32(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOTAL_LEN_32);
    }

    public static int nlarge_len(long struct) {
        return UNSAFE.getInt(null, struct + (long)LARGE_LEN);
    }

    public static int nv1(long struct) {
        return UNSAFE.getInt(null, struct + (long)V1);
    }

    public static int nv2(long struct) {
        return UNSAFE.getInt(null, struct + (long)V2);
    }

    public static int nv3(long struct) {
        return UNSAFE.getInt(null, struct + (long)V3);
    }

    public static int nv4(long struct) {
        return UNSAFE.getInt(null, struct + (long)V4);
    }

    public static IntBuffer nmem32(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)MEM32), (int)4);
    }

    public static int nmem32(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)MEM32 + Checks.check((int)index, (int)4) * 4L);
    }

    public static int nmemsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMSIZE);
    }

    public static int nreserved(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESERVED);
    }

    static {
        Struct.Layout layout = XXH32State.__struct((Struct.Member[])new Struct.Member[]{XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__array((int)4, (int)4), XXH32State.__member((int)4), XXH32State.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN_32 = layout.offsetof(0);
        LARGE_LEN = layout.offsetof(1);
        V1 = layout.offsetof(2);
        V2 = layout.offsetof(3);
        V3 = layout.offsetof(4);
        V4 = layout.offsetof(5);
        MEM32 = layout.offsetof(6);
        MEMSIZE = layout.offsetof(7);
        RESERVED = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<XXH32State, Buffer>
    implements NativeResource {
        private static final XXH32State ELEMENT_FACTORY = XXH32State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH32State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH32_hash_t")
        public int total_len_32() {
            return XXH32State.ntotal_len_32(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int large_len() {
            return XXH32State.nlarge_len(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int v1() {
            return XXH32State.nv1(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int v2() {
            return XXH32State.nv2(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int v3() {
            return XXH32State.nv3(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int v4() {
            return XXH32State.nv4(this.address());
        }

        @NativeType(value="XXH32_hash_t[4]")
        public IntBuffer mem32() {
            return XXH32State.nmem32(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int mem32(int index) {
            return XXH32State.nmem32(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int memsize() {
            return XXH32State.nmemsize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved() {
            return XXH32State.nreserved(this.address());
        }
    }
}

