/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.carrot2.clustering.ClusteringAlgorithm;
import org.carrot2.language.LanguageComponents;
import org.carrot2.language.LanguageComponentsProvider;
import org.carrot2.language.LoadedLanguages;
import org.carrot2.util.ResourceLookup;

public final class LanguageComponentsLoader {
    private Set<String> languageRestrictions;
    private Function<LanguageComponentsProvider, ResourceLookup> resourceLookupModifier;
    private ClusteringAlgorithm[] algorithmRestriction;

    public LoadedLanguages load() throws IOException {
        return this.load(LanguageComponentsLoader.loadProvidersFromSpi(this.defaultSpiClassloader()));
    }

    public LoadedLanguages load(Map<String, List<LanguageComponentsProvider>> languageProviders) throws IOException {
        this.sanityCheck(languageProviders);
        if (this.languageRestrictions != null) {
            languageProviders.keySet().retainAll(this.languageRestrictions);
        }
        Function<Set, Set> componentFilters = s -> s;
        if (this.algorithmRestriction != null) {
            Set components = Arrays.stream(this.algorithmRestriction).flatMap(algorithm -> Stream.concat(algorithm.optionalLanguageComponents().stream(), algorithm.requiredLanguageComponents().stream())).collect(Collectors.toSet());
            componentFilters = fullSet -> {
                HashSet needed = new HashSet(fullSet);
                needed.retainAll(components);
                return needed;
            };
        }
        LinkedHashMap preloadedSuppliers = new LinkedHashMap();
        for (String language : languageProviders.keySet()) {
            LinkedHashMap componentSuppliers = new LinkedHashMap();
            for (LanguageComponentsProvider provider : languageProviders.get(language)) {
                ResourceLookup rl = this.resourceLookupModifier != null ? this.resourceLookupModifier.apply(provider) : provider.defaultResourceLookup();
                Set requiredTypes = componentFilters.apply(provider.componentTypes());
                if (requiredTypes.isEmpty()) continue;
                componentSuppliers.putAll(provider.load(language, rl, requiredTypes));
            }
            if (componentSuppliers.isEmpty()) continue;
            preloadedSuppliers.put(language, componentSuppliers);
        }
        if (this.algorithmRestriction != null && this.algorithmRestriction.length == 1) {
            ClusteringAlgorithm algorithm2 = this.algorithmRestriction[0];
            preloadedSuppliers.entrySet().removeIf(e -> !algorithm2.supports(new LanguageComponents((String)e.getKey(), (Map)e.getValue())));
        }
        return new LoadedLanguages(preloadedSuppliers);
    }

    public LanguageComponentsLoader limitToLanguages(String ... languages) {
        if (this.languageRestrictions != null) {
            throw new RuntimeException("Method can be set once.");
        }
        this.languageRestrictions = new HashSet<String>(Arrays.asList(languages));
        return this;
    }

    public LanguageComponentsLoader limitToAlgorithms(ClusteringAlgorithm ... algorithms) {
        if (this.algorithmRestriction != null) {
            throw new RuntimeException("Method can be set once.");
        }
        this.algorithmRestriction = algorithms;
        return this;
    }

    public LanguageComponentsLoader withResourceLookup(Function<LanguageComponentsProvider, ResourceLookup> resourceLookupModifier) {
        if (this.resourceLookupModifier != null) {
            throw new RuntimeException("Method can be set once.");
        }
        this.resourceLookupModifier = resourceLookupModifier;
        return this;
    }

    private void sanityCheck(Map<String, List<LanguageComponentsProvider>> languageProviders) {
        languageProviders.forEach((language, providers) -> {
            HashMap byComponent = new HashMap();
            providers.forEach(provider -> {
                for (Class<?> componentType : provider.componentTypes()) {
                    LanguageComponentsProvider previous = byComponent.put(componentType, provider);
                    if (previous == null) continue;
                    throw new RuntimeException(String.format(Locale.ROOT, "Language '%s' has multiple providers of component '%s': %s", language, componentType.getSimpleName(), Stream.of(previous, provider).map(s -> s.getClass().getName()).collect(Collectors.joining(", "))));
                }
            });
        });
    }

    private ClassLoader defaultSpiClassloader() {
        return this.getClass().getClassLoader();
    }

    public static Map<String, List<LanguageComponentsProvider>> loadProvidersFromSpi(ClassLoader ... classloaders) {
        TreeMap<String, List<LanguageComponentsProvider>> providers = new TreeMap<String, List<LanguageComponentsProvider>>();
        BiPredicate<LanguageComponentsProvider, LanguageComponentsProvider> sameProvider = (p1, p2) -> Objects.equals(p1.name(), p2.name()) && Objects.equals(p1.getClass(), p2.getClass()) && Objects.equals(p1.componentTypes(), p2.componentTypes()) && Objects.equals(p1.languages(), p2.languages());
        for (ClassLoader classLoader : classloaders) {
            for (LanguageComponentsProvider candidate : ServiceLoader.load(LanguageComponentsProvider.class, classLoader)) {
                for (String language : candidate.languages()) {
                    List existingProviders = providers.computeIfAbsent(language, key -> new ArrayList());
                    if (!existingProviders.stream().noneMatch(existing -> sameProvider.test((LanguageComponentsProvider)existing, candidate))) continue;
                    existingProviders.add(candidate);
                }
            }
        }
        return providers;
    }
}

