/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExclusiveSliceProperty {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ClusterState clusterState;
    private final boolean onlyActiveNodes;
    private final String property;
    private final DocCollection collection;
    private final String collectionName;
    private final Map<String, List<SliceReplica>> nodesHostingReplicas = new HashMap<String, List<SliceReplica>>();
    private final Map<String, List<SliceReplica>> nodesHostingProp = new HashMap<String, List<SliceReplica>>();
    Set<String> shardsNeedingHosts = new HashSet<String>();
    Map<String, Slice> changedSlices = new HashMap<String, Slice>();
    private int origMaxPropPerNode = 0;
    private int origModulo = 0;
    private int tmpMaxPropPerNode = 0;
    private int tmpModulo = 0;
    Random rand = new Random();
    private int assigned = 0;

    ExclusiveSliceProperty(ClusterState clusterState, ZkNodeProps message) {
        this.clusterState = clusterState;
        Object tmp = message.getStr("property");
        if (!StringUtils.startsWith((CharSequence)tmp, (CharSequence)"property.")) {
            tmp = "property." + (String)tmp;
        }
        this.property = ((String)tmp).toLowerCase(Locale.ROOT);
        this.collectionName = message.getStr("collection");
        if (StringUtils.isBlank((CharSequence)this.collectionName) || StringUtils.isBlank((CharSequence)this.property)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer '" + message.getStr("operation") + "'  requires both the 'collection' and 'property' parameters. No action taken ");
        }
        Boolean shardUnique = Boolean.parseBoolean(message.getStr("shardUnique"));
        if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(this.property)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be a pre-defined property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'  Property: " + this.property + " shardUnique: " + Boolean.toString(shardUnique));
        }
        this.collection = clusterState.getCollection(this.collectionName);
        if (this.collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection ' " + this.collectionName + "' for overseer operation '" + message.getStr("operation") + "'. No action taken.");
        }
        this.onlyActiveNodes = Boolean.parseBoolean(message.getStr("onlyactivenodes", "true"));
    }

    DocCollection getDocCollection() {
        return this.collection;
    }

    private boolean isActive(Replica replica) {
        return replica.getState() == Replica.State.ACTIVE;
    }

    private boolean collectCurrentPropStats() {
        int maxAssigned = 0;
        HashSet<String> allHosts = new HashSet<String>();
        for (Slice slice : this.collection.getSlices()) {
            boolean sliceHasProp = false;
            for (Replica replica : slice.getReplicas()) {
                if (this.onlyActiveNodes && !this.isActive(replica)) {
                    if (!StringUtils.isNotBlank((CharSequence)replica.getStr(this.property))) continue;
                    this.removeProp(slice, replica.getName());
                    continue;
                }
                allHosts.add(replica.getNodeName());
                String nodeName = replica.getNodeName();
                if (StringUtils.isNotBlank((CharSequence)replica.getStr(this.property))) {
                    if (sliceHasProp) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'" + CollectionParams.CollectionAction.BALANCESHARDUNIQUE + "' should only be called for properties that have at most one member in any slice with the property set. No action taken.");
                    }
                    if (!this.nodesHostingProp.containsKey(nodeName)) {
                        this.nodesHostingProp.put(nodeName, new ArrayList());
                    }
                    this.nodesHostingProp.get(nodeName).add(new SliceReplica(slice, replica));
                    ++this.assigned;
                    maxAssigned = Math.max(maxAssigned, this.nodesHostingProp.get(nodeName).size());
                    sliceHasProp = true;
                }
                if (!this.nodesHostingReplicas.containsKey(nodeName)) {
                    this.nodesHostingReplicas.put(nodeName, new ArrayList());
                }
                this.nodesHostingReplicas.get(nodeName).add(new SliceReplica(slice, replica));
            }
        }
        this.origMaxPropPerNode = this.collection.getSlices().size() / allHosts.size();
        this.origModulo = this.collection.getSlices().size() % allHosts.size();
        if (this.origModulo > 0) {
            ++this.origMaxPropPerNode;
        }
        if (this.assigned != this.collection.getSlices().size()) {
            return true;
        }
        int counter = this.origModulo;
        for (List<SliceReplica> list : this.nodesHostingProp.values()) {
            if (list.size() != this.origMaxPropPerNode) continue;
            --counter;
        }
        return counter != 0;
    }

    private void removeSliceAlreadyHostedFromPossibles(String sliceName) {
        for (Map.Entry<String, List<SliceReplica>> entReplica : this.nodesHostingReplicas.entrySet()) {
            ListIterator<SliceReplica> iter = entReplica.getValue().listIterator();
            while (iter.hasNext()) {
                SliceReplica sr = iter.next();
                if (!sr.slice.getName().equals(sliceName)) continue;
                iter.remove();
            }
        }
    }

    private void balanceUnassignedReplicas() {
        this.tmpMaxPropPerNode = this.origMaxPropPerNode;
        this.tmpModulo = this.origModulo;
        while (this.shardsNeedingHosts.size() > 0) {
            String nodeName = "";
            int minSize = Integer.MAX_VALUE;
            SliceReplica srToChange = null;
            for (String slice : this.shardsNeedingHosts) {
                for (Map.Entry<String, List<SliceReplica>> ent : this.nodesHostingReplicas.entrySet()) {
                    if (srToChange == null && ent.getValue().size() > 0) {
                        srToChange = ent.getValue().get(0);
                    }
                    ListIterator<SliceReplica> iter = ent.getValue().listIterator();
                    while (iter.hasNext()) {
                        SliceReplica sr = iter.next();
                        if (!StringUtils.equals((CharSequence)slice, (CharSequence)sr.slice.getName())) continue;
                        if (!this.nodesHostingProp.containsKey(ent.getKey())) {
                            this.nodesHostingProp.put(ent.getKey(), new ArrayList());
                        }
                        if (minSize <= this.nodesHostingReplicas.get(ent.getKey()).size() || this.nodesHostingProp.get(ent.getKey()).size() >= this.tmpMaxPropPerNode) continue;
                        minSize = this.nodesHostingReplicas.get(ent.getKey()).size();
                        srToChange = sr;
                        nodeName = ent.getKey();
                    }
                }
            }
            this.shardsNeedingHosts.remove(srToChange.slice.getName());
            if (!this.nodesHostingProp.containsKey(nodeName)) {
                this.nodesHostingProp.put(nodeName, new ArrayList());
            }
            this.nodesHostingProp.get(nodeName).add(srToChange);
            this.adjustLimits(this.nodesHostingProp.get(nodeName));
            this.removeSliceAlreadyHostedFromPossibles(srToChange.slice.getName());
            this.addProp(srToChange.slice, srToChange.replica.getName());
            for (Replica rep : srToChange.slice.getReplicas()) {
                if (rep.getName().equals(srToChange.replica.getName()) || rep.getProperty(this.property) == null) continue;
                this.removeProp(srToChange.slice, srToChange.replica.getName());
            }
        }
    }

    private void adjustLimits(List<SliceReplica> changeList) {
        if (changeList.size() == this.tmpMaxPropPerNode) {
            if (this.tmpModulo < 0) {
                return;
            }
            --this.tmpModulo;
            if (this.tmpModulo == 0) {
                --this.tmpMaxPropPerNode;
                --this.tmpModulo;
            }
        }
    }

    private void removeOverallocatedReplicas() {
        this.tmpMaxPropPerNode = this.origMaxPropPerNode;
        this.tmpModulo = this.origModulo;
        for (Map.Entry<String, List<SliceReplica>> ent : this.nodesHostingProp.entrySet()) {
            while (ent.getValue().size() > this.tmpMaxPropPerNode) {
                ent.getValue().remove(this.rand.nextInt(ent.getValue().size()));
            }
            this.adjustLimits(ent.getValue());
        }
    }

    private void removeProp(Slice origSlice, String replicaName) {
        if (log.isDebugEnabled()) {
            log.debug("Removing property {} from slice {}, replica {}", new Object[]{this.property, origSlice.getName(), replicaName});
        }
        this.getReplicaFromChanged(origSlice, replicaName).getProperties().remove(this.property);
    }

    private void addProp(Slice origSlice, String replicaName) {
        if (log.isDebugEnabled()) {
            log.debug("Adding property {} to slice {}, replica {}", new Object[]{this.property, origSlice.getName(), replicaName});
        }
        this.getReplicaFromChanged(origSlice, replicaName).getProperties().put(this.property, "true");
    }

    private Replica getReplicaFromChanged(Slice origSlice, String replicaName) {
        Replica replica;
        Slice newSlice = this.changedSlices.get(origSlice.getName());
        if (newSlice != null) {
            replica = newSlice.getReplica(replicaName);
        } else {
            newSlice = new Slice(origSlice.getName(), origSlice.getReplicasCopy(), origSlice.shallowCopy(), origSlice.collection);
            this.changedSlices.put(origSlice.getName(), newSlice);
            replica = newSlice.getReplica(replicaName);
        }
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Should have been able to find replica '" + replicaName + "' in slice '" + origSlice.getName() + "'. No action taken");
        }
        return replica;
    }

    boolean balanceProperty() {
        if (!this.collectCurrentPropStats()) {
            return false;
        }
        this.removeOverallocatedReplicas();
        for (Map.Entry<String, List<SliceReplica>> entProp : this.nodesHostingProp.entrySet()) {
            for (SliceReplica srHosting : entProp.getValue()) {
                this.removeSliceAlreadyHostedFromPossibles(srHosting.slice.getName());
            }
        }
        for (Map.Entry<String, List<SliceReplica>> ent : this.nodesHostingReplicas.entrySet()) {
            ListIterator<SliceReplica> iter = ent.getValue().listIterator();
            while (iter.hasNext()) {
                SliceReplica sr = iter.next();
                this.shardsNeedingHosts.add(sr.slice.getName());
            }
        }
        this.balanceUnassignedReplicas();
        for (Slice newSlice : this.changedSlices.values()) {
            DocCollection docCollection = CollectionMutator.updateSlice(this.collectionName, this.clusterState.getCollection(this.collectionName), newSlice);
            this.clusterState = ClusterStateMutator.newState(this.clusterState, this.collectionName, docCollection);
        }
        return true;
    }

    private static class SliceReplica {
        Slice slice;
        Replica replica;

        SliceReplica(Slice slice, Replica replica) {
            this.slice = slice;
            this.replica = replica;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(System.lineSeparator()).append(System.lineSeparator());
            sb.append("    :").append(System.lineSeparator()).append("slice: ").append(this.slice.toString()).append(System.lineSeparator()).append("      replica: ").append(this.replica.toString()).append(System.lineSeparator());
            return sb.toString();
        }
    }
}

