/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.Objects;
import java.util.function.Function;
import org.apache.solr.cluster.placement.Metric;

public abstract class MetricImpl<T>
implements Metric<T> {
    public static final double GB = 1.073741824E9;
    public final Function<Object, T> IDENTITY_CONVERTER = v -> {
        try {
            return v;
        }
        catch (ClassCastException cce) {
            return null;
        }
    };
    public static final Function<Object, Double> BYTES_TO_GB_CONVERTER = v -> {
        double sizeInBytes;
        if (!(v instanceof Number)) {
            if (v == null) {
                return null;
            }
            try {
                sizeInBytes = Double.parseDouble(String.valueOf(v));
            }
            catch (Exception nfe) {
                return null;
            }
        } else {
            sizeInBytes = ((Number)v).doubleValue();
        }
        return sizeInBytes / 1.073741824E9;
    };
    protected final String name;
    protected final String internalName;
    protected final Function<Object, T> converter;

    public MetricImpl(String name, String internalName) {
        this(name, internalName, null);
    }

    public MetricImpl(String name, String internalName, Function<Object, T> converter) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(internalName);
        this.name = name;
        this.internalName = internalName;
        this.converter = converter == null ? this.IDENTITY_CONVERTER : converter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public T convert(Object value) {
        return this.converter.apply(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricImpl that = (MetricImpl)o;
        return this.name.equals(that.getName()) && this.internalName.equals(that.getInternalName()) && this.converter.equals(that.converter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.internalName, this.converter);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", internalName=" + this.internalName + "}";
    }
}

