/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.ModuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfig {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String nodeName;
    private final Path coreRootDirectory;
    private final Path solrDataHome;
    private final Integer booleanQueryMaxClauseCount;
    private final Path configSetBaseDirectory;
    private final Set<Path> allowPaths;
    private final List<String> allowUrls;
    private final String sharedLibDirectory;
    private final String modules;
    private final PluginInfo shardHandlerFactoryConfig;
    private final UpdateShardHandlerConfig updateShardHandlerConfig;
    private final String configSetServiceClass;
    private final String coreAdminHandlerClass;
    private final Map<String, String> coreAdminHandlerActions;
    private final String collectionsAdminHandlerClass;
    private final String healthCheckHandlerClass;
    private final String infoHandlerClass;
    private final String configSetsHandlerClass;
    private final LogWatcherConfig logWatcherConfig;
    private final CloudConfig cloudConfig;
    private final Integer coreLoadThreads;
    private final int replayUpdatesThreads;
    @Deprecated
    private final int transientCacheSize;
    private final boolean useSchemaCache;
    private final String managementPath;
    private final PluginInfo[] backupRepositoryPlugins;
    private final MetricsConfig metricsConfig;
    private final PluginInfo transientCacheConfig;
    private final PluginInfo tracerConfig;
    private final boolean fromZookeeper;
    private final String defaultZkHost;
    protected final Path solrHome;
    protected final SolrResourceLoader loader;
    protected final Properties solrProperties;

    private NodeConfig(String nodeName, Path coreRootDirectory, Path solrDataHome, Integer booleanQueryMaxClauseCount, Path configSetBaseDirectory, String sharedLibDirectory, PluginInfo shardHandlerFactoryConfig, UpdateShardHandlerConfig updateShardHandlerConfig, String coreAdminHandlerClass, Map<String, String> coreAdminHandlerActions, String collectionsAdminHandlerClass, String healthCheckHandlerClass, String infoHandlerClass, String configSetsHandlerClass, LogWatcherConfig logWatcherConfig, CloudConfig cloudConfig, Integer coreLoadThreads, int replayUpdatesThreads, int transientCacheSize, boolean useSchemaCache, String managementPath, Path solrHome, SolrResourceLoader loader, Properties solrProperties, PluginInfo[] backupRepositoryPlugins, MetricsConfig metricsConfig, PluginInfo transientCacheConfig, PluginInfo tracerConfig, boolean fromZookeeper, String defaultZkHost, Set<Path> allowPaths, List<String> allowUrls, String configSetServiceClass, String modules) {
        this.nodeName = nodeName;
        this.coreRootDirectory = coreRootDirectory;
        this.solrDataHome = solrDataHome;
        this.booleanQueryMaxClauseCount = booleanQueryMaxClauseCount;
        this.configSetBaseDirectory = configSetBaseDirectory;
        this.sharedLibDirectory = sharedLibDirectory;
        this.shardHandlerFactoryConfig = shardHandlerFactoryConfig;
        this.updateShardHandlerConfig = updateShardHandlerConfig;
        this.coreAdminHandlerClass = coreAdminHandlerClass;
        this.coreAdminHandlerActions = coreAdminHandlerActions;
        this.collectionsAdminHandlerClass = collectionsAdminHandlerClass;
        this.healthCheckHandlerClass = healthCheckHandlerClass;
        this.infoHandlerClass = infoHandlerClass;
        this.configSetsHandlerClass = configSetsHandlerClass;
        this.logWatcherConfig = logWatcherConfig;
        this.cloudConfig = cloudConfig;
        this.coreLoadThreads = coreLoadThreads;
        this.replayUpdatesThreads = replayUpdatesThreads;
        this.transientCacheSize = transientCacheSize;
        this.useSchemaCache = useSchemaCache;
        this.managementPath = managementPath;
        this.solrHome = solrHome;
        this.loader = loader;
        this.solrProperties = solrProperties;
        this.backupRepositoryPlugins = backupRepositoryPlugins;
        this.metricsConfig = metricsConfig;
        this.transientCacheConfig = transientCacheConfig;
        this.tracerConfig = tracerConfig;
        this.fromZookeeper = fromZookeeper;
        this.defaultZkHost = defaultZkHost;
        this.allowPaths = allowPaths;
        this.allowUrls = allowUrls;
        this.configSetServiceClass = configSetServiceClass;
        this.modules = modules;
        if (this.cloudConfig != null && this.getCoreLoadThreadCount(false) < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 for coreLoadThreads (configured value = " + this.coreLoadThreads + ")");
        }
        if (null == this.solrHome) {
            throw new NullPointerException("solrHome");
        }
        if (null == this.loader) {
            throw new NullPointerException("loader");
        }
        this.setupSharedLib();
        this.initModules();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig loadNodeConfig(Path solrHome, Properties nodeProperties) {
        String zkHost;
        if (!StringUtils.isEmpty((CharSequence)System.getProperty("solr.solrxml.location"))) {
            log.warn("Solr property solr.solrxml.location is no longer supported. Will automatically load solr.xml from ZooKeeper if it exists");
        }
        if (StringUtils.isEmpty((CharSequence)(zkHost = (nodeProperties = SolrXmlConfig.wrapAndSetZkHostFromSysPropIfNeeded(nodeProperties)).getProperty("zkHost")))) return SolrXmlConfig.fromSolrHome(solrHome, nodeProperties);
        int startUpZkTimeOut = Integer.getInteger("waitForZk", 30);
        startUpZkTimeOut *= 1000;
        try (SolrZkClient zkClient = new SolrZkClient(zkHost, startUpZkTimeOut, startUpZkTimeOut);){
            if (zkClient.exists("/solr.xml", true).booleanValue()) {
                log.info("solr.xml found in ZooKeeper. Loading...");
                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                NodeConfig nodeConfig = SolrXmlConfig.fromInputStream(solrHome, new ByteArrayInputStream(data), nodeProperties, true);
                return nodeConfig;
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error occurred while loading solr.xml from zookeeper", (Throwable)e);
        }
        log.info("Loading solr.xml from SolrHome (not found in ZooKeeper)");
        return SolrXmlConfig.fromSolrHome(solrHome, nodeProperties);
    }

    public String getConfigSetServiceClass() {
        return this.configSetServiceClass;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Path getCoreRootDirectory() {
        return this.coreRootDirectory;
    }

    public Path getSolrDataHome() {
        return this.solrDataHome;
    }

    public Path getSolrInstallDir() {
        String prop = System.getProperty("solr.install.dir");
        if (prop == null || prop.isBlank()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.install.dir property not initialized");
        }
        return Paths.get(prop, new String[0]);
    }

    public Integer getBooleanQueryMaxClauseCount() {
        return this.booleanQueryMaxClauseCount;
    }

    public PluginInfo getShardHandlerFactoryPluginInfo() {
        return this.shardHandlerFactoryConfig;
    }

    public UpdateShardHandlerConfig getUpdateShardHandlerConfig() {
        return this.updateShardHandlerConfig;
    }

    public int getCoreLoadThreadCount(boolean zkAware) {
        return this.coreLoadThreads == null ? (zkAware ? 8 : 3) : this.coreLoadThreads;
    }

    public int getReplayUpdatesThreads() {
        return this.replayUpdatesThreads;
    }

    public String getSharedLibDirectory() {
        return this.sharedLibDirectory;
    }

    public String getCoreAdminHandlerClass() {
        return this.coreAdminHandlerClass;
    }

    public Map<String, String> getCoreAdminHandlerActions() {
        return this.coreAdminHandlerActions;
    }

    public String getCollectionsHandlerClass() {
        return this.collectionsAdminHandlerClass;
    }

    public String getHealthCheckHandlerClass() {
        return this.healthCheckHandlerClass;
    }

    public String getInfoHandlerClass() {
        return this.infoHandlerClass;
    }

    public String getConfigSetsHandlerClass() {
        return this.configSetsHandlerClass;
    }

    public boolean hasSchemaCache() {
        return this.useSchemaCache;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public Path getConfigSetBaseDirectory() {
        return this.configSetBaseDirectory;
    }

    public LogWatcherConfig getLogWatcherConfig() {
        return this.logWatcherConfig;
    }

    public CloudConfig getCloudConfig() {
        return this.cloudConfig;
    }

    public int getTransientCacheSize() {
        return this.transientCacheSize;
    }

    public Properties getSolrProperties() {
        return this.solrProperties;
    }

    public Path getSolrHome() {
        return this.solrHome;
    }

    public SolrResourceLoader getSolrResourceLoader() {
        return this.loader;
    }

    public PluginInfo[] getBackupRepositoryPlugins() {
        return this.backupRepositoryPlugins;
    }

    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    public PluginInfo getTransientCachePluginInfo() {
        return this.transientCacheConfig;
    }

    public PluginInfo getTracerConfiguratorPluginInfo() {
        return this.tracerConfig;
    }

    public boolean isFromZookeeper() {
        return this.fromZookeeper;
    }

    public String getDefaultZkHost() {
        return this.defaultZkHost;
    }

    public Set<Path> getAllowPaths() {
        return this.allowPaths;
    }

    public List<String> getAllowUrls() {
        return this.allowUrls;
    }

    private void setupSharedLib() {
        LinkedHashSet<String> libDirs = new LinkedHashSet<String>();
        libDirs.add("lib");
        libDirs.add(this.getSolrInstallDir().resolve("lib").toAbsolutePath().normalize().toString());
        if (!StringUtils.isBlank((CharSequence)this.getSharedLibDirectory())) {
            List<String> sharedLibs = Arrays.asList(this.getSharedLibDirectory().split("\\s*,\\s*"));
            libDirs.addAll(sharedLibs);
        }
        this.addFoldersToSharedLib(libDirs);
    }

    public String getModules() {
        return this.modules;
    }

    private void addFoldersToSharedLib(Set<String> libDirs) {
        boolean modified = false;
        for (String libDir : libDirs) {
            Path libPath = this.getSolrHome().resolve(libDir);
            if (!Files.exists(libPath, new LinkOption[0])) continue;
            try {
                this.loader.addToClassLoader(SolrResourceLoader.getURLs(libPath));
                modified = true;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't load libs: " + e, (Throwable)e);
            }
        }
        if (modified) {
            this.loader.reloadLuceneSPI();
        }
    }

    private void initModules() {
        Collection<String> moduleNames = ModuleUtils.resolveModulesFromStringOrSyspropOrEnv(this.getModules());
        boolean modified = false;
        for (String m : moduleNames) {
            if (!ModuleUtils.moduleExists(this.getSolrInstallDir(), m)) {
                log.error("No module with name {}, available modules are {}", (Object)m, ModuleUtils.listAvailableModules(this.getSolrInstallDir()));
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No module with name " + m);
            }
            Path moduleLibPath = ModuleUtils.getModuleLibPath(this.getSolrInstallDir(), m);
            if (Files.exists(moduleLibPath, new LinkOption[0])) {
                try {
                    List<URL> urls = SolrResourceLoader.getURLs(moduleLibPath);
                    this.loader.addToClassLoader(urls);
                    if (log.isInfoEnabled()) {
                        log.info("Added module {}. libPath={} with {} libs", new Object[]{m, moduleLibPath, urls.size()});
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Libs loaded from {}: {}", (Object)moduleLibPath, urls);
                    }
                    modified = true;
                    continue;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't load libs for module " + m + ": " + e, (Throwable)e);
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Module lib folder " + moduleLibPath + " not found.");
        }
        if (modified) {
            this.loader.reloadLuceneSPI();
        }
    }

    public static class NodeConfigBuilder {
        private SolrResourceLoader loader;
        private Path coreRootDirectory;
        private Path solrDataHome;
        private Integer booleanQueryMaxClauseCount;
        private Path configSetBaseDirectory;
        private String sharedLibDirectory;
        private String modules;
        private PluginInfo shardHandlerFactoryConfig;
        private UpdateShardHandlerConfig updateShardHandlerConfig = UpdateShardHandlerConfig.DEFAULT;
        private String configSetServiceClass;
        private String coreAdminHandlerClass = "org.apache.solr.handler.admin.CoreAdminHandler";
        private Map<String, String> coreAdminHandlerActions = Collections.emptyMap();
        private String collectionsAdminHandlerClass = "org.apache.solr.handler.admin.CollectionsHandler";
        private String healthCheckHandlerClass = "org.apache.solr.handler.admin.HealthCheckHandler";
        private String infoHandlerClass = "org.apache.solr.handler.admin.InfoHandler";
        private String configSetsHandlerClass = "org.apache.solr.handler.admin.ConfigSetsHandler";
        private LogWatcherConfig logWatcherConfig = new LogWatcherConfig(true, null, null, 50);
        private CloudConfig cloudConfig;
        private int coreLoadThreads = 3;
        private int replayUpdatesThreads = Runtime.getRuntime().availableProcessors();
        @Deprecated
        private int transientCacheSize = Integer.MAX_VALUE;
        private boolean useSchemaCache = false;
        private String managementPath;
        private Properties solrProperties = new Properties();
        private PluginInfo[] backupRepositoryPlugins;
        private MetricsConfig metricsConfig;
        private PluginInfo transientCacheConfig;
        private PluginInfo tracerConfig;
        private boolean fromZookeeper = false;
        private String defaultZkHost;
        private Set<Path> allowPaths = Collections.emptySet();
        private List<String> allowUrls = Collections.emptyList();
        private final Path solrHome;
        private final String nodeName;
        public static final int DEFAULT_CORE_LOAD_THREADS = 3;
        public static final int DEFAULT_CORE_LOAD_THREADS_IN_CLOUD = 8;
        public static final int DEFAULT_TRANSIENT_CACHE_SIZE = Integer.MAX_VALUE;
        private static final String DEFAULT_ADMINHANDLERCLASS = "org.apache.solr.handler.admin.CoreAdminHandler";
        private static final String DEFAULT_INFOHANDLERCLASS = "org.apache.solr.handler.admin.InfoHandler";
        private static final String DEFAULT_COLLECTIONSHANDLERCLASS = "org.apache.solr.handler.admin.CollectionsHandler";
        private static final String DEFAULT_HEALTHCHECKHANDLERCLASS = "org.apache.solr.handler.admin.HealthCheckHandler";
        private static final String DEFAULT_CONFIGSETSHANDLERCLASS = "org.apache.solr.handler.admin.ConfigSetsHandler";
        public static final Set<String> DEFAULT_HIDDEN_SYS_PROPS = new HashSet<String>(Arrays.asList("javax.net.ssl.keyStorePassword", "javax.net.ssl.trustStorePassword", "basicauth", "zkDigestPassword", "zkDigestReadonlyPassword", "aws.secretKey", "aws.secretAccessKey", "http.proxyPassword"));

        public NodeConfigBuilder(String nodeName, Path solrHome) {
            this.nodeName = nodeName;
            this.solrHome = solrHome.toAbsolutePath();
            this.coreRootDirectory = solrHome;
            this.setSolrDataHome(System.getProperty("solr.data.home"));
            this.setConfigSetBaseDirectory("configsets");
            this.metricsConfig = new MetricsConfig.MetricsConfigBuilder().build();
        }

        public NodeConfigBuilder setCoreRootDirectory(String coreRootDirectory) {
            this.coreRootDirectory = this.solrHome.resolve(coreRootDirectory).normalize();
            return this;
        }

        public NodeConfigBuilder setSolrDataHome(String solrDataHomeString) {
            if (solrDataHomeString != null && !solrDataHomeString.isEmpty()) {
                this.solrDataHome = this.solrHome.resolve(solrDataHomeString).normalize();
            }
            return this;
        }

        public NodeConfigBuilder setBooleanQueryMaxClauseCount(Integer booleanQueryMaxClauseCount) {
            this.booleanQueryMaxClauseCount = booleanQueryMaxClauseCount;
            return this;
        }

        public NodeConfigBuilder setConfigSetBaseDirectory(String configSetBaseDirectory) {
            this.configSetBaseDirectory = this.solrHome.resolve(configSetBaseDirectory);
            return this;
        }

        public NodeConfigBuilder setSharedLibDirectory(String sharedLibDirectory) {
            this.sharedLibDirectory = sharedLibDirectory;
            return this;
        }

        public NodeConfigBuilder setShardHandlerFactoryConfig(PluginInfo shardHandlerFactoryConfig) {
            this.shardHandlerFactoryConfig = shardHandlerFactoryConfig;
            return this;
        }

        public NodeConfigBuilder setUpdateShardHandlerConfig(UpdateShardHandlerConfig updateShardHandlerConfig) {
            this.updateShardHandlerConfig = updateShardHandlerConfig;
            return this;
        }

        public NodeConfigBuilder setCoreAdminHandlerClass(String coreAdminHandlerClass) {
            this.coreAdminHandlerClass = coreAdminHandlerClass;
            return this;
        }

        public NodeConfigBuilder setCoreAdminHandlerActions(Map<String, String> coreAdminHandlerActions) {
            this.coreAdminHandlerActions = coreAdminHandlerActions;
            return this;
        }

        public NodeConfigBuilder setCollectionsAdminHandlerClass(String collectionsAdminHandlerClass) {
            this.collectionsAdminHandlerClass = collectionsAdminHandlerClass;
            return this;
        }

        public NodeConfigBuilder setHealthCheckHandlerClass(String healthCheckHandlerClass) {
            this.healthCheckHandlerClass = healthCheckHandlerClass;
            return this;
        }

        public NodeConfigBuilder setInfoHandlerClass(String infoHandlerClass) {
            this.infoHandlerClass = infoHandlerClass;
            return this;
        }

        public NodeConfigBuilder setConfigSetsHandlerClass(String configSetsHandlerClass) {
            this.configSetsHandlerClass = configSetsHandlerClass;
            return this;
        }

        public NodeConfigBuilder setLogWatcherConfig(LogWatcherConfig logWatcherConfig) {
            this.logWatcherConfig = logWatcherConfig;
            return this;
        }

        public NodeConfigBuilder setCloudConfig(CloudConfig cloudConfig) {
            this.cloudConfig = cloudConfig;
            return this;
        }

        public NodeConfigBuilder setCoreLoadThreads(int coreLoadThreads) {
            this.coreLoadThreads = coreLoadThreads;
            return this;
        }

        public NodeConfigBuilder setReplayUpdatesThreads(int replayUpdatesThreads) {
            this.replayUpdatesThreads = replayUpdatesThreads;
            return this;
        }

        @Deprecated
        public NodeConfigBuilder setTransientCacheSize(int transientCacheSize) {
            this.transientCacheSize = transientCacheSize;
            return this;
        }

        public NodeConfigBuilder setUseSchemaCache(boolean useSchemaCache) {
            this.useSchemaCache = useSchemaCache;
            return this;
        }

        public NodeConfigBuilder setManagementPath(String managementPath) {
            this.managementPath = managementPath;
            return this;
        }

        public NodeConfigBuilder setSolrProperties(Properties solrProperties) {
            this.solrProperties = solrProperties;
            return this;
        }

        public NodeConfigBuilder setBackupRepositoryPlugins(PluginInfo[] backupRepositoryPlugins) {
            this.backupRepositoryPlugins = backupRepositoryPlugins;
            return this;
        }

        public NodeConfigBuilder setMetricsConfig(MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public NodeConfigBuilder setSolrCoreCacheFactoryConfig(PluginInfo transientCacheConfig) {
            this.transientCacheConfig = transientCacheConfig;
            return this;
        }

        public NodeConfigBuilder setTracerConfig(PluginInfo tracerConfig) {
            this.tracerConfig = tracerConfig;
            return this;
        }

        public NodeConfigBuilder setFromZookeeper(boolean fromZookeeper) {
            this.fromZookeeper = fromZookeeper;
            return this;
        }

        public NodeConfigBuilder setDefaultZkHost(String defaultZkHost) {
            this.defaultZkHost = defaultZkHost;
            return this;
        }

        public NodeConfigBuilder setAllowPaths(Set<Path> paths) {
            this.allowPaths = paths;
            return this;
        }

        public NodeConfigBuilder setAllowUrls(List<String> urls) {
            this.allowUrls = urls;
            return this;
        }

        public NodeConfigBuilder setConfigSetServiceClass(String configSetServiceClass) {
            this.configSetServiceClass = configSetServiceClass;
            return this;
        }

        public NodeConfigBuilder setModules(String moduleNames) {
            this.modules = moduleNames;
            return this;
        }

        public NodeConfig build() {
            if (this.loader == null) {
                this.loader = new SolrResourceLoader(this.solrHome);
            }
            return new NodeConfig(this.nodeName, this.coreRootDirectory, this.solrDataHome, this.booleanQueryMaxClauseCount, this.configSetBaseDirectory, this.sharedLibDirectory, this.shardHandlerFactoryConfig, this.updateShardHandlerConfig, this.coreAdminHandlerClass, this.coreAdminHandlerActions, this.collectionsAdminHandlerClass, this.healthCheckHandlerClass, this.infoHandlerClass, this.configSetsHandlerClass, this.logWatcherConfig, this.cloudConfig, this.coreLoadThreads, this.replayUpdatesThreads, this.transientCacheSize, this.useSchemaCache, this.managementPath, this.solrHome, this.loader, this.solrProperties, this.backupRepositoryPlugins, this.metricsConfig, this.transientCacheConfig, this.tracerConfig, this.fromZookeeper, this.defaultZkHost, this.allowPaths, this.allowUrls, this.configSetServiceClass, this.modules);
        }

        public NodeConfigBuilder setSolrResourceLoader(SolrResourceLoader resourceLoader) {
            this.loader = resourceLoader;
            return this;
        }
    }
}

