/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.ApiSupport;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.NestedRequestHandler;
import org.apache.solr.metrics.SolrDelegateRegistryMetricsContext;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerBase
implements SolrRequestHandler,
SolrInfoBean,
NestedRequestHandler,
ApiSupport,
PermissionNameProvider {
    protected NamedList<?> initArgs = null;
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    protected boolean httpCaching = true;
    protected boolean aggregateNodeLevelMetricsEnabled = false;
    protected SolrMetricsContext solrMetricsContext;
    protected HandlerMetrics metrics = HandlerMetrics.NO_OP;
    private final long handlerStart = System.currentTimeMillis();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PluginInfo pluginInfo;

    @SuppressForbidden(reason="Need currentTimeMillis, used only for stats output")
    public RequestHandlerBase() {
    }

    @Override
    public void init(NamedList<?> args) {
        this.initArgs = args;
        if (args != null) {
            this.defaults = RequestHandlerBase.getSolrParamsFromNamedList(args, "defaults");
            this.appends = RequestHandlerBase.getSolrParamsFromNamedList(args, "appends");
            this.invariants = RequestHandlerBase.getSolrParamsFromNamedList(args, "invariants");
        }
        if (this.initArgs != null) {
            Object caching = this.initArgs.get("httpCaching");
            this.httpCaching = caching != null ? Boolean.parseBoolean(caching.toString()) : true;
            Boolean aggregateNodeLevelMetricsEnabled = this.initArgs.getBooleanArg("aggregateNodeLevelMetricsEnabled");
            if (aggregateNodeLevelMetricsEnabled != null) {
                this.aggregateNodeLevelMetricsEnabled = aggregateNodeLevelMetricsEnabled;
            }
        }
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = this.aggregateNodeLevelMetricsEnabled ? new SolrDelegateRegistryMetricsContext(parentContext.getMetricManager(), parentContext.getRegistryName(), SolrMetricProducer.getUniqueMetricTag(this, parentContext.getTag()), SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])) : parentContext.getChildContext(this);
        this.metrics = new HandlerMetrics(this.solrMetricsContext, this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.handlerStart, true, "handlerStart", this.getCategory().toString(), scope);
    }

    public static SolrParams getSolrParamsFromNamedList(NamedList<?> args, String key) {
        Object o = args.get(key);
        if (o != null && o instanceof NamedList) {
            return ((NamedList)o).toSolrParams();
        }
        return null;
    }

    public NamedList<?> getInitArgs() {
        return this.initArgs;
    }

    public abstract void handleRequestBody(SolrQueryRequest var1, SolrQueryResponse var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        HandlerMetrics metrics = this.getMetricsForThisRequest(req);
        metrics.requests.inc();
        Timer.Context timer = metrics.requestTimes.time();
        try {
            TestInjection.injectLeaderTragedy(req.getCore());
            if (this.pluginInfo != null && this.pluginInfo.attributes.containsKey("useParams")) {
                req.getContext().put("useParams", this.pluginInfo.attributes.get("useParams"));
            }
            SolrPluginUtils.setDefaults(this, req, this.defaults, this.appends, this.invariants);
            req.getContext().remove("useParams");
            rsp.setHttpCaching(this.httpCaching);
            this.handleRequestBody(req, rsp);
            NamedList<Object> header = rsp.getResponseHeader();
            if (header != null && Boolean.TRUE.equals(header.getBooleanArg("partialResults"))) {
                metrics.numTimeouts.mark();
                rsp.setHttpCaching(false);
            }
        }
        catch (Exception e2) {
            SolrException e2;
            boolean isTragic;
            if (req.getCore() != null && (isTragic = req.getCoreContainer().checkTragicException(req.getCore()))) {
                if (e2 instanceof SolrException) {
                    assert (((SolrException)((Object)e2)).code() == 500);
                } else {
                    e2 = new SolrException(SolrException.ErrorCode.SERVER_ERROR, e2.getMessage(), (Throwable)e2);
                }
            }
            boolean incrementErrors = true;
            boolean isServerError = true;
            if (e2 instanceof SolrException) {
                SolrException se = e2;
                if (se.code() == SolrException.ErrorCode.CONFLICT.code) {
                    incrementErrors = false;
                } else if (se.code() >= 400 && se.code() < 500) {
                    isServerError = false;
                }
            } else if (e2 instanceof SyntaxError) {
                isServerError = false;
                e2 = new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e2);
            }
            rsp.setException((Exception)((Object)e2));
            if (incrementErrors) {
                SolrException.log((Logger)log, (Throwable)e2);
                metrics.numErrors.mark();
                if (isServerError) {
                    metrics.numServerErrors.mark();
                } else {
                    metrics.numClientErrors.mark();
                }
            }
        }
        finally {
            long elapsed = timer.stop();
            metrics.totalTime.inc(elapsed);
        }
    }

    protected HandlerMetrics getMetricsForThisRequest(SolrQueryRequest req) {
        return this.metrics;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return null;
    }

    public static SolrRequestHandler getRequestHandler(String handlerName, PluginBag<SolrRequestHandler> reqHandlers) {
        if (handlerName == null) {
            return null;
        }
        SolrRequestHandler handler = reqHandlers.get(handlerName);
        int idx = 0;
        if (handler == null) {
            while ((idx = handlerName.indexOf(47, idx + 1)) > 0) {
                String firstPart = handlerName.substring(0, idx);
                handler = reqHandlers.get(firstPart);
                if (handler == null || !(handler instanceof NestedRequestHandler)) continue;
                return ((NestedRequestHandler)((Object)handler)).getSubHandler(handlerName.substring(idx));
            }
        }
        return handler;
    }

    public void setPluginInfo(PluginInfo pluginInfo) {
        if (this.pluginInfo == null) {
            this.pluginInfo = pluginInfo;
        }
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public Collection<Api> getApis() {
        return ImmutableList.of((Object)new ApiBag.ReqHandlerToApi(this, ApiBag.constructSpec(this.pluginInfo)));
    }

    public static class HandlerMetrics {
        public static final HandlerMetrics NO_OP = new HandlerMetrics(new SolrMetricsContext(new SolrMetricManager(null, new MetricsConfig.MetricsConfigBuilder().setEnabled(false).build()), "NO_OP", "NO_OP"), new String[0]);
        private final Meter numErrors;
        private final Meter numServerErrors;
        private final Meter numClientErrors;
        private final Meter numTimeouts;
        private final Counter requests;
        private final Timer requestTimes;
        private final Counter totalTime;

        public HandlerMetrics(SolrMetricsContext solrMetricsContext, String ... metricPath) {
            this.numErrors = solrMetricsContext.meter("errors", metricPath);
            this.numServerErrors = solrMetricsContext.meter("serverErrors", metricPath);
            this.numClientErrors = solrMetricsContext.meter("clientErrors", metricPath);
            this.numTimeouts = solrMetricsContext.meter("timeouts", metricPath);
            this.requests = solrMetricsContext.counter("requests", metricPath);
            this.requestTimes = solrMetricsContext.timer("requestTimes", metricPath);
            this.totalTime = solrMetricsContext.counter("totalTime", metricPath);
        }
    }
}

