/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public abstract class AbstractSubTypeFieldType
extends FieldType
implements SchemaAware {
    protected FieldType subType;
    public static final String SUB_FIELD_SUFFIX = "subFieldSuffix";
    public static final String SUB_FIELD_TYPE = "subFieldType";
    protected String suffix;
    protected int dynFieldProps;
    protected String[] suffixes;
    protected String subFieldType = null;
    protected String subSuffix = null;
    protected IndexSchema schema;

    public FieldType getSubType() {
        return this.subType;
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.schema = schema;
        MapSolrParams p = new MapSolrParams(args);
        this.subFieldType = p.get(SUB_FIELD_TYPE);
        this.subSuffix = p.get(SUB_FIELD_SUFFIX);
        if (this.subFieldType != null) {
            args.remove(SUB_FIELD_TYPE);
            this.subType = schema.getFieldTypeByName(this.subFieldType.trim());
            this.suffix = "___" + this.subType.typeName;
        } else if (this.subSuffix != null) {
            args.remove(SUB_FIELD_SUFFIX);
            this.suffix = this.subSuffix;
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The field type: " + this.typeName + " must specify the subFieldType attribute or the subFieldSuffix attribute.");
        }
    }

    static SchemaField registerPolyFieldDynamicPrototype(IndexSchema schema, FieldType subType, FieldType polyField) {
        String name = "*___" + subType.typeName;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("indexed", "true");
        props.put("stored", "false");
        props.put("multiValued", "false");
        if (polyField.hasProperty(32768)) {
            props.put("docValues", "true");
        }
        int p = SchemaField.calcProps(name, subType, props);
        SchemaField proto = SchemaField.create(name, subType, p, null);
        schema.registerDynamicFields(proto);
        return proto;
    }

    @Override
    public void inform(IndexSchema schema) {
        this.schema = schema;
        if (this.subType != null) {
            SchemaField proto = AbstractSubTypeFieldType.registerPolyFieldDynamicPrototype(schema, this.subType, this);
            this.dynFieldProps = proto.getProperties();
        }
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        throw new UnsupportedOperationException();
    }

    protected void createSuffixCache(int size) {
        this.suffixes = new String[size];
        for (int i = 0; i < size; ++i) {
            this.suffixes[i] = "_" + i + this.suffix;
        }
    }

    protected SchemaField subField(SchemaField base, int i, IndexSchema schema) {
        return schema.getField(base.getName() + this.suffixes[i]);
    }
}

