/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rules.AggregateProjectConstantToDummyJoinRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOverOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlTableRef;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlImplementor {
    public static final SqlParserPos POS = SqlParserPos.QUOTED_ZERO;
    static final SqlNumericLiteral ZERO = SqlNumericLiteral.createExactNumeric("0", POS);
    static final SqlNumericLiteral ONE = SqlLiteral.createExactNumeric("1", POS);
    public final SqlDialect dialect;
    protected final Set<String> aliasSet = new LinkedHashSet<String>();
    protected final Map<CorrelationId, Context> correlTableMap = new HashMap<CorrelationId, Context>();
    final RexBuilder rexBuilder = new RexBuilder(new SqlTypeFactoryImpl(RelDataTypeSystemImpl.DEFAULT));

    protected SqlImplementor(SqlDialect dialect) {
        this.dialect = Objects.requireNonNull(dialect, "dialect");
    }

    public final Result visitRoot(RelNode r) {
        RelNode best;
        if (!this.dialect.supportsGroupByLiteral()) {
            HepProgramBuilder hepProgramBuilder = new HepProgramBuilder();
            hepProgramBuilder.addRuleInstance(AggregateProjectConstantToDummyJoinRule.Config.DEFAULT.toRule());
            HepPlanner hepPlanner = new HepPlanner(hepProgramBuilder.build());
            hepPlanner.setRoot(r);
            best = hepPlanner.findBestExp();
        } else {
            best = r;
        }
        try {
            return this.visitInput(SqlImplementor.holder(best), 0);
        }
        catch (Error | RuntimeException e) {
            throw Util.throwAsRuntime("Error while converting RelNode to SqlNode:\n" + RelOptUtil.toString(r), e);
        }
    }

    private static RelNode holder(RelNode r) {
        return new SingleRel(r.getCluster(), r.getTraitSet(), r){};
    }

    @Deprecated
    public final Result visitChild(int i, RelNode e) {
        throw new UnsupportedOperationException();
    }

    public final Result visitInput(RelNode e, int i) {
        return this.visitInput(e, i, (Set<Clause>)ImmutableSet.of());
    }

    public final Result visitInput(RelNode e, int i, Clause ... clauses) {
        return this.visitInput(e, i, (Set<Clause>)ImmutableSet.copyOf((Object[])clauses));
    }

    public final Result visitInput(RelNode e, int i, Set<Clause> clauses) {
        return this.visitInput(e, i, this.isAnon(), false, clauses);
    }

    public abstract Result visitInput(RelNode var1, int var2, boolean var3, boolean var4, Set<Clause> var5);

    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        if (alias == null || !alias.equals(name)) {
            node = this.as(node, name, new String[0]);
        }
        selectList.add(node);
    }

    protected SqlCall as(SqlNode e, String alias, String ... fieldNames) {
        ArrayList<SqlNode> operandList = new ArrayList<SqlNode>();
        operandList.add(e);
        operandList.add(new SqlIdentifier(alias, POS));
        for (String fieldName : fieldNames) {
            operandList.add(new SqlIdentifier(fieldName, POS));
        }
        return SqlStdOperatorTable.AS.createCall(POS, operandList);
    }

    public static boolean isStar(List<RexNode> exps, RelDataType inputRowType, RelDataType projectRowType) {
        assert (exps.size() == projectRowType.getFieldCount());
        int i = 0;
        for (RexNode ref : exps) {
            if (!(ref instanceof RexInputRef)) {
                return false;
            }
            if (((RexInputRef)ref).getIndex() == i++) continue;
            return false;
        }
        return i == inputRowType.getFieldCount() && inputRowType.getFieldNames().equals(projectRowType.getFieldNames());
    }

    public static boolean isStar(RexProgram program) {
        int i = 0;
        for (RexLocalRef ref : program.getProjectList()) {
            if (ref.getIndex() == i++) continue;
            return false;
        }
        return i == program.getInputRowType().getFieldCount();
    }

    public Result setOpToSql(SqlSetOperator operator, RelNode rel) {
        SqlCall node = null;
        for (Ord input : Ord.zip(rel.getInputs())) {
            Result result = this.visitInput(rel, input.i);
            if (node == null) {
                node = result.asSelect();
                continue;
            }
            node = operator.createCall(POS, node, result.asSelect());
        }
        assert (node != null) : "set op must have at least one input, operator = " + operator + ", rel = " + rel;
        Expressions.FluentList clauses = Expressions.list((Object[])new Clause[]{Clause.SET_OP});
        return this.result(node, (Collection<Clause>)clauses, rel, null);
    }

    public static SqlNode convertConditionToSqlNode(RexNode node, Context leftContext, Context rightContext) {
        if (node.isAlwaysTrue()) {
            return SqlLiteral.createBoolean(true, POS);
        }
        if (node.isAlwaysFalse()) {
            return SqlLiteral.createBoolean(false, POS);
        }
        Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
        return joinContext.toSql(null, node);
    }

    private static RexNode stripCastFromString(RexNode node, SqlDialect dialect) {
        switch (node.getKind()) {
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                RexCall call = (RexCall)node;
                RexNode o0 = (RexNode)call.operands.get(0);
                RexNode o1 = (RexNode)call.operands.get(1);
                if (o0.getKind() == SqlKind.CAST && o1.getKind() != SqlKind.CAST) {
                    if (!dialect.supportsImplicitTypeCoercion((RexCall)o0)) {
                        return node;
                    }
                    RexNode o0b = ((RexCall)o0).getOperands().get(0);
                    return call.clone(call.getType(), (List<RexNode>)ImmutableList.of((Object)o0b, (Object)o1));
                }
                if (o1.getKind() != SqlKind.CAST || o0.getKind() == SqlKind.CAST) break;
                if (!dialect.supportsImplicitTypeCoercion((RexCall)o1)) {
                    return node;
                }
                RexNode o1b = ((RexCall)o1).getOperands().get(0);
                return call.clone(call.getType(), (List<RexNode>)ImmutableList.of((Object)o0, (Object)o1b));
            }
        }
        return node;
    }

    public static JoinType joinType(JoinRelType joinType) {
        switch (joinType) {
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case INNER: {
                return JoinType.INNER;
            }
            case FULL: {
                return JoinType.FULL;
            }
        }
        throw new AssertionError((Object)joinType);
    }

    public Result result(SqlNode node, Collection<Clause> clauses, RelNode rel, @Nullable Map<String, RelDataType> aliases) {
        assert (aliases == null || aliases.size() < 2 || aliases instanceof LinkedHashMap || aliases instanceof ImmutableMap) : "must use a Map implementation that preserves order";
        String alias2 = SqlValidatorUtil.getAlias(node, -1);
        String alias3 = alias2 != null ? alias2 : "t";
        String alias4 = SqlValidatorUtil.uniquify(alias3, this.aliasSet, SqlValidatorUtil.EXPR_SUGGESTER);
        RelDataType rowType = SqlImplementor.adjustedRowType(rel, node);
        if (!(aliases == null || aliases.isEmpty() || this.dialect.hasImplicitTableAlias() && aliases.size() <= 1)) {
            return this.result(node, clauses, alias4, rowType, aliases);
        }
        String alias5 = alias2 == null || !alias2.equals(alias4) || !this.dialect.hasImplicitTableAlias() ? alias4 : null;
        return this.result(node, clauses, alias5, rowType, (Map<String, RelDataType>)ImmutableMap.of((Object)alias4, (Object)rowType));
    }

    protected Result result(SqlNode node, Collection<Clause> clauses, @Nullable String neededAlias, @Nullable RelDataType neededType, Map<String, RelDataType> aliases) {
        return new Result(node, clauses, neededAlias, neededType, aliases);
    }

    private static RelDataType adjustedRowType(RelNode rel, SqlNode node) {
        RelDataType rowType = rel.getRowType();
        switch (node.getKind()) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                return SqlImplementor.adjustedRowType(rel, ((SqlCall)node).getOperandList().get(0));
            }
            case SELECT: {
                SqlNodeList selectList = ((SqlSelect)node).getSelectList();
                if (selectList.equals(SqlNodeList.SINGLETON_STAR)) {
                    return rowType;
                }
                RelDataTypeFactory.FieldInfoBuilder builder = rel.getCluster().getTypeFactory().builder();
                Pair.forEach(selectList, rowType.getFieldList(), (selectItem, field) -> builder.add(Util.first(SqlValidatorUtil.getAlias(selectItem, -1), field.getName()), field.getType()));
                return builder.build();
            }
            case AS: {
                List<SqlNode> operandList = ((SqlCall)node).getOperandList();
                if (operandList.size() <= 2) {
                    return rowType;
                }
                RelDataTypeFactory.FieldInfoBuilder builder = rel.getCluster().getTypeFactory().builder();
                Pair.forEach(Util.skip(operandList, 2), rowType.getFieldList(), (operand, field) -> builder.add(operand.toString(), field.getType()));
                return builder.build();
            }
        }
        return rowType;
    }

    public Result result(SqlNode join, Result leftResult, Result rightResult) {
        Map aliases;
        if (join.getKind() == SqlKind.JOIN) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            SqlImplementor.collectAliases((ImmutableMap.Builder<String, RelDataType>)builder, join, Iterables.concat(leftResult.aliases.values(), rightResult.aliases.values()).iterator());
            aliases = builder.build();
        } else {
            aliases = leftResult.aliases;
        }
        return this.result(join, (Collection<Clause>)ImmutableList.of((Object)((Object)Clause.FROM)), null, null, aliases);
    }

    private static void collectAliases(ImmutableMap.Builder<String, RelDataType> builder, SqlNode node, Iterator<RelDataType> aliases) {
        if (node instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)node;
            SqlImplementor.collectAliases(builder, join.getLeft(), aliases);
            SqlImplementor.collectAliases(builder, join.getRight(), aliases);
        } else {
            String alias = SqlValidatorUtil.getAlias(node, -1);
            assert (alias != null);
            builder.put((Object)alias, (Object)aliases.next());
        }
    }

    protected boolean isAnon() {
        return false;
    }

    SqlSelect wrapSelect(SqlNode node) {
        assert (node instanceof SqlJoin || node instanceof SqlIdentifier || node instanceof SqlMatchRecognize || node instanceof SqlTableRef || node instanceof SqlCall && (((SqlCall)node).getOperator() instanceof SqlSetOperator || ((SqlCall)node).getOperator() == SqlStdOperatorTable.AS || ((SqlCall)node).getOperator() == SqlStdOperatorTable.VALUES)) : node;
        if (this.requiresAlias(node)) {
            node = this.as(node, "t", new String[0]);
        }
        return new SqlSelect(POS, SqlNodeList.EMPTY, SqlNodeList.SINGLETON_STAR, node, null, null, null, SqlNodeList.EMPTY, null, null, null, null);
    }

    private boolean requiresAlias(SqlNode node) {
        if (!this.dialect.requiresAliasForFromItems()) {
            return false;
        }
        switch (node.getKind()) {
            case IDENTIFIER: {
                return !this.dialect.hasImplicitTableAlias();
            }
            case AS: 
            case JOIN: 
            case EXPLICIT_TABLE: {
                return false;
            }
        }
        return true;
    }

    private static boolean isAggregate(SqlNode node) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator() instanceof SqlAggFunction;
    }

    private static boolean isWindowedAggregate(SqlNode node) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator() instanceof SqlOverOperator;
    }

    public static SqlNode toSql(@Nullable RexProgram program, RexLiteral literal) {
        switch (literal.getTypeName()) {
            case SYMBOL: {
                Enum symbol = (Enum)((Object)literal.getValue());
                return SqlLiteral.createSymbol(symbol, POS);
            }
            case ROW: {
                List list = (List)Nullness.castNonNull((Object)literal.getValueAs(List.class));
                return SqlStdOperatorTable.ROW.createCall(POS, (List)list.stream().map(e -> SqlImplementor.toSql(program, e)).collect(Util.toImmutableList()));
            }
            case SARG: {
                Sarg arg = literal.getValueAs(Sarg.class);
                throw new AssertionError((Object)("sargs [" + arg + "] should be handled as part of predicates, not as literals"));
            }
        }
        return SqlImplementor.toSql(literal);
    }

    public static SqlNode toSql(RexLiteral literal) {
        SqlTypeName typeName = literal.getTypeName();
        switch (typeName) {
            case SYMBOL: {
                Enum symbol = (Enum)((Object)literal.getValue());
                return SqlLiteral.createSymbol(symbol, POS);
            }
            case ROW: {
                List list = (List)Nullness.castNonNull((Object)literal.getValueAs(List.class));
                return SqlStdOperatorTable.ROW.createCall(POS, (List)list.stream().map(e -> SqlImplementor.toSql(e)).collect(Util.toImmutableList()));
            }
            case SARG: {
                Sarg arg = literal.getValueAs(Sarg.class);
                throw new AssertionError((Object)("sargs [" + arg + "] should be handled as part of predicates, not as literals"));
            }
        }
        SqlTypeFamily family = Objects.requireNonNull(typeName.getFamily(), () -> "literal " + literal + " has null SqlTypeFamily, and is SqlTypeName is " + (Object)((Object)typeName));
        switch (family) {
            case CHARACTER: {
                return SqlLiteral.createCharString((String)Nullness.castNonNull((Object)literal.getValue2()), POS);
            }
            case NUMERIC: 
            case EXACT_NUMERIC: {
                return SqlLiteral.createExactNumeric(((BigDecimal)Nullness.castNonNull((Object)literal.getValueAs(BigDecimal.class))).toPlainString(), POS);
            }
            case APPROXIMATE_NUMERIC: {
                return SqlLiteral.createApproxNumeric(((BigDecimal)Nullness.castNonNull((Object)literal.getValueAs(BigDecimal.class))).toPlainString(), POS);
            }
            case BOOLEAN: {
                return SqlLiteral.createBoolean((Boolean)Nullness.castNonNull((Object)literal.getValueAs(Boolean.class)), POS);
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                boolean negative = (Boolean)Nullness.castNonNull((Object)literal.getValueAs(Boolean.class));
                return SqlLiteral.createInterval(negative ? -1 : 1, (String)Nullness.castNonNull((Object)literal.getValueAs(String.class)), (SqlIntervalQualifier)Nullness.castNonNull((Object)literal.getType().getIntervalQualifier()), POS);
            }
            case DATE: {
                return SqlLiteral.createDate((DateString)Nullness.castNonNull((Object)literal.getValueAs(DateString.class)), POS);
            }
            case TIME: {
                return SqlLiteral.createTime((TimeString)Nullness.castNonNull((Object)literal.getValueAs(TimeString.class)), literal.getType().getPrecision(), POS);
            }
            case TIMESTAMP: {
                return SqlLiteral.createTimestamp((TimestampString)Nullness.castNonNull((Object)literal.getValueAs(TimestampString.class)), literal.getType().getPrecision(), POS);
            }
            case ANY: 
            case NULL: {
                switch (typeName) {
                    case NULL: {
                        return SqlLiteral.createNull(POS);
                    }
                }
            }
        }
        throw new AssertionError((Object)(literal + ": " + (Object)((Object)typeName)));
    }

    private static int computeFieldCount(Map<String, RelDataType> aliases) {
        int x = 0;
        for (RelDataType type : aliases.values()) {
            x += type.getFieldCount();
        }
        return x;
    }

    public Context aliasContext(Map<String, RelDataType> aliases, boolean qualified) {
        return new AliasContext(this.dialect, aliases, qualified);
    }

    public Context joinContext(Context leftContext, Context rightContext) {
        return new JoinContext(this.dialect, leftContext, rightContext);
    }

    public Context matchRecognizeContext(Context context) {
        return new MatchRecognizeContext(this.dialect, ((AliasContext)context).aliases);
    }

    public Context tableFunctionScanContext(List<SqlNode> inputSqlNodes) {
        return new TableFunctionScanContext(this.dialect, inputSqlNodes);
    }

    public static enum Clause {
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        SELECT,
        SET_OP,
        ORDER_BY,
        FETCH,
        OFFSET;

    }

    public class Builder {
        private final RelNode rel;
        final List<Clause> clauses;
        final SqlSelect select;
        public final Context context;
        final boolean anon;
        private final @Nullable Map<String, RelDataType> aliases;

        public Builder(RelNode rel, List<Clause> clauses, SqlSelect select, Context context, @Nullable boolean anon, Map<String, RelDataType> aliases) {
            this.rel = Objects.requireNonNull(rel, "rel");
            this.clauses = ImmutableList.copyOf(clauses);
            this.select = Objects.requireNonNull(select, "select");
            this.context = Objects.requireNonNull(context, "context");
            this.anon = anon;
            this.aliases = aliases;
        }

        public void setSelect(SqlNodeList nodeList) {
            this.select.setSelectList(nodeList);
        }

        public void setWhere(SqlNode node) {
            assert (this.clauses.contains((Object)Clause.WHERE));
            this.select.setWhere(node);
        }

        public void setGroupBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.GROUP_BY));
            this.select.setGroupBy(nodeList);
        }

        public void setHaving(SqlNode node) {
            assert (this.clauses.contains((Object)Clause.HAVING));
            this.select.setHaving(node);
        }

        public void setOrderBy(SqlNodeList nodeList) {
            assert (this.clauses.contains((Object)Clause.ORDER_BY));
            this.select.setOrderBy(nodeList);
        }

        public void setFetch(SqlNode fetch) {
            assert (this.clauses.contains((Object)Clause.FETCH));
            this.select.setFetch(fetch);
        }

        public void setOffset(SqlNode offset) {
            assert (this.clauses.contains((Object)Clause.OFFSET));
            this.select.setOffset(offset);
        }

        public void addOrderItem(List<SqlNode> orderByList, RelFieldCollation field) {
            this.context.addOrderItem(orderByList, field);
        }

        public Result result() {
            return SqlImplementor.this.result(this.select, this.clauses, this.rel, this.aliases).withAnon(this.anon);
        }
    }

    public class Result {
        final SqlNode node;
        final @Nullable String neededAlias;
        private final @Nullable RelDataType neededType;
        private final Map<String, RelDataType> aliases;
        final List<Clause> clauses;
        private final boolean anon;
        private final boolean ignoreClauses;
        private final ImmutableSet<Clause> expectedClauses;
        private final @Nullable RelNode expectedRel;
        private final boolean needNew;

        public Result(SqlNode node, @Nullable Collection<Clause> clauses, @Nullable String neededAlias, RelDataType neededType, Map<String, RelDataType> aliases) {
            this(node, clauses, neededAlias, neededType, aliases, false, false, (Set<Clause>)ImmutableSet.of(), null);
        }

        private Result(SqlNode node, @Nullable Collection<Clause> clauses, @Nullable String neededAlias, RelDataType neededType, Map<String, RelDataType> aliases, boolean anon, boolean ignoreClauses, @Nullable Set<Clause> expectedClauses, RelNode expectedRel) {
            this.node = node;
            this.neededAlias = neededAlias;
            this.neededType = neededType;
            this.aliases = aliases;
            this.clauses = ImmutableList.copyOf(clauses);
            this.anon = anon;
            this.ignoreClauses = ignoreClauses;
            this.expectedClauses = ImmutableSet.copyOf(expectedClauses);
            this.expectedRel = expectedRel;
            Object clauses2 = ignoreClauses ? ImmutableSet.of() : expectedClauses;
            this.needNew = expectedRel != null && this.needNewSubQuery(expectedRel, this.clauses, (Set<Clause>)clauses2);
        }

        public Builder builder(RelNode rel) {
            return this.builder(rel, (Set<Clause>)this.expectedClauses);
        }

        @Deprecated
        public Builder builder(RelNode rel, Clause clause, Clause ... clauses) {
            return this.builder(rel, (Set<Clause>)ImmutableSet.copyOf((Collection)Lists.asList((Object)((Object)clause), (Object[])clauses)));
        }

        private Builder builder(RelNode rel, Set<Clause> clauses) {
            Context newContext;
            SqlSelect select;
            assert (this.expectedClauses.containsAll(clauses));
            assert (rel.equals(this.expectedRel));
            Object clauses2 = this.ignoreClauses ? ImmutableSet.of() : clauses;
            boolean needNew = this.needNewSubQuery(rel, this.clauses, (Set<Clause>)clauses2);
            assert (needNew == this.needNew);
            Expressions.FluentList clauseList = Expressions.list();
            if (needNew) {
                select = this.subSelect();
            } else {
                select = this.asSelect();
                clauseList.addAll(this.clauses);
            }
            clauseList.appendAll(clauses);
            ImmutableMap newAliases = null;
            final SqlNodeList selectList = select.getSelectList();
            if (!selectList.equals(SqlNodeList.SINGLETON_STAR)) {
                final boolean aliasRef = this.expectedClauses.contains((Object)Clause.HAVING) && SqlImplementor.this.dialect.getConformance().isHavingAlias();
                newContext = new Context(SqlImplementor.this.dialect, selectList.size()){

                    @Override
                    public SqlImplementor implementor() {
                        return SqlImplementor.this;
                    }

                    @Override
                    public SqlNode field(int ordinal) {
                        SqlNode selectItem = selectList.get(ordinal);
                        switch (selectItem.getKind()) {
                            case AS: {
                                SqlCall asCall = (SqlCall)selectItem;
                                Object alias = asCall.operand(1);
                                if (aliasRef && !SqlUtil.isGeneratedAlias(((SqlIdentifier)alias).getSimple())) {
                                    return alias;
                                }
                                return asCall.operand(0);
                            }
                        }
                        return selectItem;
                    }

                    @Override
                    public SqlNode orderField(int ordinal) {
                        SqlNode node = super.orderField(ordinal);
                        if (node instanceof SqlIdentifier && ((SqlIdentifier)node).isSimple()) {
                            String name = ((SqlIdentifier)node).getSimple();
                            for (Ord selectItem : Ord.zip((List)selectList)) {
                                String alias;
                                if (selectItem.i == ordinal || !name.equalsIgnoreCase(alias = SqlValidatorUtil.getAlias((SqlNode)selectItem.e, -1))) continue;
                                return SqlLiteral.createExactNumeric(Integer.toString(ordinal + 1), SqlParserPos.ZERO);
                            }
                        }
                        return node;
                    }
                };
            } else {
                boolean qualified;
                boolean bl = qualified = !SqlImplementor.this.dialect.hasImplicitTableAlias() || this.aliases.size() > 1;
                if (needNew && this.neededAlias != null && (this.aliases.size() != 1 || !this.aliases.containsKey(this.neededAlias))) {
                    newAliases = ImmutableMap.of((Object)this.neededAlias, (Object)rel.getInput(0).getRowType());
                    newContext = SqlImplementor.this.aliasContext((Map<String, RelDataType>)newAliases, qualified);
                } else {
                    newContext = SqlImplementor.this.aliasContext(this.aliases, qualified);
                }
            }
            return new Builder(rel, (List<Clause>)clauseList, select, newContext, SqlImplementor.this.isAnon(), (Map<String, RelDataType>)(needNew && !this.aliases.containsKey(this.neededAlias) ? newAliases : this.aliases));
        }

        private boolean needNewSubQuery(@UnknownInitialization Result this, RelNode rel, List<Clause> clauses, Set<Clause> expectedClauses) {
            if (clauses.isEmpty()) {
                return false;
            }
            Clause maxClause = Collections.max(clauses);
            ImmutableSet nonWrapSet = ImmutableSet.of((Object)((Object)Clause.SELECT));
            for (Clause clause : expectedClauses) {
                if (maxClause.ordinal() <= clause.ordinal() && (maxClause != clause || nonWrapSet.contains((Object)clause))) continue;
                return true;
            }
            if (rel instanceof Project && clauses.contains((Object)Clause.HAVING) && SqlImplementor.this.dialect.getConformance().isHavingAlias()) {
                return true;
            }
            if (rel instanceof Project && ((Project)rel).containsOver() && maxClause == Clause.SELECT) {
                return true;
            }
            if (rel instanceof Aggregate) {
                Aggregate agg = (Aggregate)rel;
                boolean hasNestedAgg = this.hasNested(agg, x$0 -> SqlImplementor.isAggregate(x$0));
                boolean hasNestedWindowedAgg = this.hasNested(agg, x$0 -> SqlImplementor.isWindowedAggregate(x$0));
                if (!SqlImplementor.this.dialect.supportsNestedAggregations() && (hasNestedAgg || hasNestedWindowedAgg)) {
                    return true;
                }
                if (clauses.contains((Object)Clause.GROUP_BY)) {
                    return !hasNestedAgg || Aggregate.isNotGrandTotal(agg);
                }
            }
            return false;
        }

        private boolean hasNested(@UnknownInitialization Result this, Aggregate aggregate, Predicate<SqlNode> operandPredicate) {
            SqlNodeList selectList;
            if (this.node instanceof SqlSelect && !(selectList = ((SqlSelect)this.node).getSelectList()).equals(SqlNodeList.SINGLETON_STAR)) {
                HashSet<Integer> aggregatesArgs = new HashSet<Integer>();
                for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                    aggregatesArgs.addAll(aggregateCall.getArgList());
                }
                Iterator<AggregateCall> iterator = aggregatesArgs.iterator();
                while (iterator.hasNext()) {
                    int aggregatesArg = (Integer)((Object)iterator.next());
                    if (!(selectList.get(aggregatesArg) instanceof SqlBasicCall)) continue;
                    SqlBasicCall call = (SqlBasicCall)selectList.get(aggregatesArg);
                    for (SqlNode operand : call.getOperandList()) {
                        if (operand == null || !operandPredicate.test(operand)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Deprecated
        public Clause maxClause() {
            return Collections.max(this.clauses);
        }

        public SqlNode asFrom() {
            if (this.neededAlias != null) {
                if (this.node.getKind() == SqlKind.AS) {
                    SqlCall sqlCall = (SqlCall)this.node;
                    SqlNode[] operands = sqlCall.getOperandList().toArray(new SqlNode[0]);
                    operands[1] = new SqlIdentifier(this.neededAlias, POS);
                    return SqlStdOperatorTable.AS.createCall(POS, operands);
                }
                return SqlStdOperatorTable.AS.createCall(POS, this.node, new SqlIdentifier(this.neededAlias, POS));
            }
            return this.node;
        }

        public SqlSelect subSelect() {
            return SqlImplementor.this.wrapSelect(this.asFrom());
        }

        public SqlSelect asSelect() {
            if (this.node instanceof SqlSelect) {
                return (SqlSelect)this.node;
            }
            if (!SqlImplementor.this.dialect.hasImplicitTableAlias()) {
                return SqlImplementor.this.wrapSelect(this.asFrom());
            }
            return SqlImplementor.this.wrapSelect(this.node);
        }

        public void stripTrivialAliases(SqlNode node) {
            switch (node.getKind()) {
                case SELECT: {
                    SqlSelect select = (SqlSelect)node;
                    SqlNodeList nodeList = select.getSelectList();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.size(); ++i) {
                        SqlCall call;
                        SqlIdentifier identifier;
                        SqlNode n = nodeList.get(i);
                        if (n.getKind() != SqlKind.AS || !SqlUtil.isGeneratedAlias((identifier = (SqlIdentifier)(call = (SqlCall)n).operand(1)).getSimple())) continue;
                        nodeList.set(i, (SqlNode)call.operand(0));
                    }
                    break;
                }
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case INSERT: 
                case UPDATE: 
                case DELETE: 
                case MERGE: {
                    SqlCall call = (SqlCall)node;
                    for (SqlNode operand : call.getOperandList()) {
                        if (operand == null) continue;
                        this.stripTrivialAliases(operand);
                    }
                    break;
                }
            }
        }

        private SqlNode maybeStrip(SqlNode node) {
            if (this.anon) {
                this.stripTrivialAliases(node);
            }
            return node;
        }

        public SqlNode asStatement() {
            switch (this.node.getKind()) {
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case INSERT: 
                case UPDATE: 
                case DELETE: 
                case MERGE: {
                    return this.maybeStrip(this.node);
                }
            }
            return this.maybeStrip(this.asSelect());
        }

        public SqlNode asQueryOrValues() {
            switch (this.node.getKind()) {
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case VALUES: {
                    return this.maybeStrip(this.node);
                }
            }
            return this.maybeStrip(this.asSelect());
        }

        public Context qualifiedContext() {
            return SqlImplementor.this.aliasContext(this.aliases, true);
        }

        public Result resetAlias() {
            if (this.neededAlias == null) {
                return this;
            }
            return new Result(this.node, (Collection<Clause>)this.clauses, this.neededAlias, this.neededType, (Map<String, RelDataType>)ImmutableMap.of((Object)this.neededAlias, (Object)Nullness.castNonNull((Object)this.neededType)), this.anon, this.ignoreClauses, (Set<Clause>)this.expectedClauses, this.expectedRel);
        }

        public Result resetAlias(String alias, RelDataType type) {
            return new Result(this.node, (Collection<Clause>)this.clauses, alias, this.neededType, (Map<String, RelDataType>)ImmutableMap.of((Object)alias, (Object)type), this.anon, this.ignoreClauses, (Set<Clause>)this.expectedClauses, this.expectedRel);
        }

        Result withAnon(boolean anon) {
            return anon == this.anon ? this : new Result(this.node, (Collection<Clause>)this.clauses, this.neededAlias, this.neededType, this.aliases, anon, this.ignoreClauses, (Set<Clause>)this.expectedClauses, this.expectedRel);
        }

        Result withExpectedClauses(boolean ignoreClauses, Set<? extends Clause> expectedClauses, RelNode expectedRel) {
            return ignoreClauses == this.ignoreClauses && expectedClauses.equals(this.expectedClauses) && expectedRel == this.expectedRel ? this : new Result(this.node, this.clauses, this.neededAlias, this.neededType, this.aliases, this.anon, ignoreClauses, (Set<Clause>)ImmutableSet.copyOf(expectedClauses), expectedRel);
        }
    }

    class TableFunctionScanContext
    extends BaseContext {
        private final List<SqlNode> inputSqlNodes;

        TableFunctionScanContext(SqlDialect dialect, List<SqlNode> inputSqlNodes) {
            super(dialect, inputSqlNodes.size());
            this.inputSqlNodes = inputSqlNodes;
        }

        @Override
        public SqlNode field(int ordinal) {
            return this.inputSqlNodes.get(ordinal);
        }
    }

    class JoinContext
    extends BaseContext {
        private final Context leftContext;
        private final Context rightContext;

        private JoinContext(SqlDialect dialect, Context leftContext, Context rightContext) {
            super(dialect, leftContext.fieldCount + rightContext.fieldCount);
            this.leftContext = leftContext;
            this.rightContext = rightContext;
        }

        @Override
        public SqlNode field(int ordinal) {
            if (ordinal < this.leftContext.fieldCount) {
                return this.leftContext.field(ordinal);
            }
            return this.rightContext.field(ordinal - this.leftContext.fieldCount);
        }

        @Override
        protected RexCall reverseCall(RexCall call) {
            switch (call.getKind()) {
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case IS_DISTINCT_FROM: {
                    assert (call.operands.size() == 2);
                    RexNode op0 = (RexNode)call.operands.get(0);
                    RexNode op1 = (RexNode)call.operands.get(1);
                    if (!(op0 instanceof RexInputRef) || !(op1 instanceof RexInputRef) || ((RexInputRef)op1).getIndex() >= this.leftContext.fieldCount || ((RexInputRef)op0).getIndex() < this.leftContext.fieldCount) break;
                    SqlOperator op2 = Objects.requireNonNull(call.getOperator().reverse());
                    return (RexCall)SqlImplementor.this.rexBuilder.makeCall(op2, op1, op0);
                }
            }
            return call;
        }
    }

    public class AliasContext
    extends BaseContext {
        private final boolean qualified;
        private final Map<String, RelDataType> aliases;

        protected AliasContext(SqlDialect dialect, Map<String, RelDataType> aliases, boolean qualified) {
            super(dialect, SqlImplementor.computeFieldCount(aliases));
            this.aliases = aliases;
            this.qualified = qualified;
        }

        @Override
        public SqlNode field(int ordinal) {
            for (Map.Entry<String, RelDataType> alias : this.aliases.entrySet()) {
                List<RelDataTypeField> fields = alias.getValue().getFieldList();
                if (ordinal < fields.size()) {
                    RelDataTypeField field = fields.get(ordinal);
                    return new SqlIdentifier((List<String>)(!this.qualified ? ImmutableList.of((Object)field.getName()) : ImmutableList.of((Object)alias.getKey(), (Object)field.getName())), POS);
                }
                ordinal -= fields.size();
            }
            throw new AssertionError((Object)("field ordinal " + ordinal + " out of range " + this.aliases));
        }
    }

    public class MatchRecognizeContext
    extends AliasContext {
        protected MatchRecognizeContext(SqlDialect dialect, Map<String, RelDataType> aliases) {
            super(dialect, aliases, false);
        }

        @Override
        public SqlNode toSql(@Nullable RexProgram program, RexNode rex) {
            RexLiteral literal;
            if (rex.getKind() == SqlKind.LITERAL && (literal = (RexLiteral)rex).getTypeName().getFamily() == SqlTypeFamily.CHARACTER) {
                return new SqlIdentifier((String)Nullness.castNonNull((Object)RexLiteral.stringValue(literal)), POS);
            }
            return super.toSql(program, rex);
        }
    }

    protected abstract class BaseContext
    extends Context {
        BaseContext(SqlDialect dialect, int fieldCount) {
            super(dialect, fieldCount);
        }

        @Override
        protected Context getAliasContext(RexCorrelVariable variable) {
            return Objects.requireNonNull(SqlImplementor.this.correlTableMap.get(variable.id), () -> "variable " + variable.id + " is not found");
        }

        @Override
        public SqlImplementor implementor() {
            return SqlImplementor.this;
        }
    }

    public static class SimpleContext
    extends Context {
        private final IntFunction<SqlNode> field;

        public SimpleContext(SqlDialect dialect, IntFunction<SqlNode> field) {
            super(dialect, 0, false);
            this.field = field;
        }

        @Override
        public SqlImplementor implementor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SqlNode field(int ordinal) {
            return this.field.apply(ordinal);
        }
    }

    public static abstract class Context {
        final SqlDialect dialect;
        final int fieldCount;
        private final boolean ignoreCast;

        protected Context(SqlDialect dialect, int fieldCount) {
            this(dialect, fieldCount, false);
        }

        protected Context(SqlDialect dialect, int fieldCount, boolean ignoreCast) {
            this.dialect = dialect;
            this.fieldCount = fieldCount;
            this.ignoreCast = ignoreCast;
        }

        public abstract SqlNode field(int var1);

        public SqlNode orderField(int ordinal) {
            SqlNode node = this.field(ordinal);
            if (node instanceof SqlNumericLiteral && this.dialect.getConformance().isSortByOrdinal()) {
                String strValue = ((SqlNumericLiteral)node).toValue();
                return SqlLiteral.createCharString(strValue, node.getParserPosition());
            }
            return node;
        }

        public SqlNode toSql(@Nullable RexProgram program, RexNode rex) {
            switch (rex.getKind()) {
                case LOCAL_REF: {
                    int index = ((RexLocalRef)rex).getIndex();
                    return this.toSql(program, Objects.requireNonNull(program, "program").getExprList().get(index));
                }
                case INPUT_REF: {
                    return this.field(((RexInputRef)rex).getIndex());
                }
                case FIELD_ACCESS: {
                    RexFieldAccess access;
                    SqlIdentifier sqlIdentifier;
                    ArrayDeque<RexFieldAccess> accesses = new ArrayDeque<RexFieldAccess>();
                    RexNode referencedExpr = rex;
                    while (referencedExpr.getKind() == SqlKind.FIELD_ACCESS) {
                        accesses.offerLast((RexFieldAccess)referencedExpr);
                        referencedExpr = ((RexFieldAccess)referencedExpr).getReferenceExpr();
                    }
                    switch (referencedExpr.getKind()) {
                        case CORREL_VARIABLE: {
                            RexCorrelVariable variable = (RexCorrelVariable)referencedExpr;
                            Context correlAliasContext = this.getAliasContext(variable);
                            RexFieldAccess lastAccess = (RexFieldAccess)accesses.pollLast();
                            assert (lastAccess != null);
                            sqlIdentifier = (SqlIdentifier)correlAliasContext.field(lastAccess.getField().getIndex());
                            break;
                        }
                        case ROW: {
                            SqlNode expr = this.toSql(program, referencedExpr);
                            sqlIdentifier = new SqlIdentifier(expr.toString(), POS);
                            break;
                        }
                        default: {
                            sqlIdentifier = (SqlIdentifier)this.toSql(program, referencedExpr);
                        }
                    }
                    int nameIndex = sqlIdentifier.names.size();
                    while ((access = (RexFieldAccess)accesses.pollLast()) != null) {
                        sqlIdentifier = sqlIdentifier.add(nameIndex++, access.getField().getName(), POS);
                    }
                    return sqlIdentifier;
                }
                case PATTERN_INPUT_REF: {
                    RexPatternFieldRef ref = (RexPatternFieldRef)rex;
                    String pv = ref.getAlpha();
                    SqlNode refNode = this.field(ref.getIndex());
                    SqlIdentifier id = (SqlIdentifier)refNode;
                    if (id.names.size() > 1) {
                        return id.setName(0, pv);
                    }
                    return new SqlIdentifier((List<String>)ImmutableList.of((Object)pv, (Object)id.names.get(0)), POS);
                }
                case LITERAL: {
                    return SqlImplementor.toSql(program, (RexLiteral)rex);
                }
                case CASE: {
                    SqlNode valueNode;
                    RexCall caseCall = (RexCall)rex;
                    List<SqlNode> caseNodeList = this.toSql(program, caseCall.getOperands());
                    Expressions.FluentList whenList = Expressions.list();
                    Expressions.FluentList thenList = Expressions.list();
                    if (caseNodeList.size() % 2 == 0) {
                        valueNode = caseNodeList.get(0);
                        for (int i = 1; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    } else {
                        valueNode = null;
                        for (int i = 0; i < caseNodeList.size() - 1; i += 2) {
                            whenList.add(caseNodeList.get(i));
                            thenList.add(caseNodeList.get(i + 1));
                        }
                    }
                    SqlNode elseNode = caseNodeList.get(caseNodeList.size() - 1);
                    return new SqlCase(POS, valueNode, new SqlNodeList((Collection<? extends SqlNode>)whenList, POS), new SqlNodeList((Collection<? extends SqlNode>)thenList, POS), elseNode);
                }
                case DYNAMIC_PARAM: {
                    RexDynamicParam caseParam = (RexDynamicParam)rex;
                    return new SqlDynamicParam(caseParam.getIndex(), POS);
                }
                case IN: {
                    SqlNode op0;
                    RexSubQuery subQuery = (RexSubQuery)rex;
                    SqlNode sqlSubQuery = this.implementor().visitRoot(subQuery.rel).asQueryOrValues();
                    ImmutableList operands = subQuery.operands;
                    if (operands.size() == 1) {
                        op0 = this.toSql(program, (RexNode)operands.get(0));
                    } else {
                        List<SqlNode> cols = this.toSql(program, (List<RexNode>)operands);
                        op0 = new SqlNodeList(cols, POS);
                    }
                    return subQuery.getOperator().createCall(POS, op0, sqlSubQuery);
                }
                case SEARCH: {
                    RexCall search = (RexCall)rex;
                    if (((RexNode)search.operands.get(1)).getKind() == SqlKind.LITERAL) {
                        RexLiteral literal = (RexLiteral)search.operands.get(1);
                        Sarg sarg = (Sarg)Nullness.castNonNull((Object)literal.getValueAs(Sarg.class));
                        return this.toSql(program, (RexNode)search.operands.get(0), literal.getType(), sarg);
                    }
                    return this.toSql(program, RexUtil.expandSearch(this.implementor().rexBuilder, program, search));
                }
                case EXISTS: 
                case UNIQUE: 
                case SCALAR_QUERY: {
                    RexSubQuery subQuery = (RexSubQuery)rex;
                    SqlNode sqlSubQuery = this.implementor().visitRoot(subQuery.rel).asQueryOrValues();
                    return subQuery.getOperator().createCall(POS, sqlSubQuery);
                }
                case NOT: {
                    RexNode operand = (RexNode)((RexCall)rex).operands.get(0);
                    SqlNode node = this.toSql(program, operand);
                    SqlOperator inverseOperator = Context.getInverseOperator(operand);
                    if (inverseOperator != null) {
                        switch (operand.getKind()) {
                            case IN: {
                                assert (operand instanceof RexSubQuery) : "scalar IN is no longer allowed in RexCall: " + rex;
                                break;
                            }
                        }
                        return inverseOperator.createCall(POS, ((SqlCall)node).getOperandList());
                    }
                    return SqlStdOperatorTable.NOT.createCall(POS, node);
                }
            }
            if (rex instanceof RexOver) {
                return this.toSql(program, (RexOver)rex);
            }
            return this.callToSql(program, (RexCall)rex, false);
        }

        private SqlNode callToSql(@Nullable RexProgram program, RexCall call0, boolean not) {
            RexCall call1 = this.reverseCall(call0);
            RexCall call = (RexCall)SqlImplementor.stripCastFromString(call1, this.dialect);
            SqlOperator op = call.getOperator();
            switch (op.getKind()) {
                case SUM0: {
                    op = SqlStdOperatorTable.SUM;
                    break;
                }
                case NOT: {
                    RexNode operand = (RexNode)call.operands.get(0);
                    if (Context.getInverseOperator(operand) == null) break;
                    return this.callToSql(program, (RexCall)operand, !not);
                }
            }
            if (not) {
                op = Objects.requireNonNull(Context.getInverseOperator(call), () -> "unable to negate " + (Object)((Object)call.getKind()));
            }
            List<SqlNode> nodeList = this.toSql(program, call.getOperands());
            switch (call.getKind()) {
                case CAST: {
                    RelDataType dataType = call.getType();
                    if (dataType.getSqlTypeName() == SqlTypeName.CURSOR) {
                        RexNode operand0 = (RexNode)call.operands.get(0);
                        assert (operand0 instanceof RexInputRef);
                        int ordinal = ((RexInputRef)operand0).getIndex();
                        SqlNode fieldOperand = this.field(ordinal);
                        return SqlStdOperatorTable.CURSOR.createCall(SqlParserPos.ZERO, fieldOperand);
                    }
                    if (this.ignoreCast || call.getType().getSqlTypeName() == SqlTypeName.UNKNOWN) {
                        assert (nodeList.size() == 1);
                        return nodeList.get(0);
                    }
                    nodeList.add((SqlNode)Nullness.castNonNull((Object)this.dialect.getCastSpec(call.getType())));
                    break;
                }
            }
            return SqlUtil.createCall(op, POS, nodeList);
        }

        protected RexCall reverseCall(RexCall call) {
            return call;
        }

        private static @Nullable SqlOperator getInverseOperator(RexNode node) {
            if (node instanceof RexCall) {
                return ((RexCall)node).getOperator().not();
            }
            return null;
        }

        private <C extends Comparable<C>> SqlNode toSql(@Nullable RexProgram program, RexNode operand, RelDataType type, Sarg<C> sarg) {
            ArrayList<SqlNode> orList = new ArrayList<SqlNode>();
            SqlNode operandSql = this.toSql(program, operand);
            if (sarg.nullAs == RexUnknownAs.TRUE) {
                orList.add(SqlStdOperatorTable.IS_NULL.createCall(POS, operandSql));
            }
            if (sarg.isPoints()) {
                orList.add(this.toIn(operandSql, SqlStdOperatorTable.EQUALS, SqlStdOperatorTable.IN, program, type, sarg.rangeSet));
            } else if (sarg.isComplementedPoints()) {
                orList.add(this.toIn(operandSql, SqlStdOperatorTable.NOT_EQUALS, SqlStdOperatorTable.NOT_IN, program, type, sarg.rangeSet.complement()));
            } else {
                RangeToSql<Comparable> consumer = new RangeToSql<Comparable>(operandSql, orList, v -> this.toSql(program, this.implementor().rexBuilder.makeLiteral(v, type)));
                RangeSets.forEach(sarg.rangeSet, consumer);
            }
            return SqlUtil.createCall(SqlStdOperatorTable.OR, POS, orList);
        }

        private <C extends Comparable<C>> SqlNode toIn(SqlNode operandSql, SqlBinaryOperator eqOp, SqlBinaryOperator inOp, @Nullable RexProgram program, RelDataType type, RangeSet<C> rangeSet) {
            SqlNodeList list = rangeSet.asRanges().stream().map(range -> this.toSql(program, this.implementor().rexBuilder.makeLiteral(range.lowerEndpoint(), type, true, true))).collect(SqlNode.toList());
            switch (list.size()) {
                case 1: {
                    return eqOp.createCall(POS, operandSql, list.get(0));
                }
            }
            return inOp.createCall(POS, operandSql, list);
        }

        public SqlNode toSql(RexWindowBound rexWindowBound) {
            SqlCharStringLiteral offsetLiteral;
            SqlCharStringLiteral sqlCharStringLiteral = offsetLiteral = rexWindowBound.getOffset() == null ? null : SqlLiteral.createCharString(rexWindowBound.getOffset().toString(), SqlParserPos.ZERO);
            if (rexWindowBound.isPreceding()) {
                return offsetLiteral == null ? SqlWindow.createUnboundedPreceding(POS) : SqlWindow.createPreceding(offsetLiteral, POS);
            }
            if (rexWindowBound.isFollowing()) {
                return offsetLiteral == null ? SqlWindow.createUnboundedFollowing(POS) : SqlWindow.createFollowing(offsetLiteral, POS);
            }
            assert (rexWindowBound.isCurrentRow());
            return SqlWindow.createCurrentRow(POS);
        }

        public List<SqlNode> toSql(Window.Group group, final ImmutableList<RexLiteral> constants, final int inputFieldCount) {
            ArrayList<SqlNode> rexOvers = new ArrayList<SqlNode>();
            ArrayList<SqlNode> partitionKeys = new ArrayList<SqlNode>();
            ArrayList<SqlNode> orderByKeys = new ArrayList<SqlNode>();
            Iterator<Object> iterator = group.keys.iterator();
            while (iterator.hasNext()) {
                int partition = iterator.next();
                partitionKeys.add(this.field(partition));
            }
            for (RelFieldCollation collation : group.orderKeys.getFieldCollations()) {
                this.addOrderItem(orderByKeys, collation);
            }
            SqlLiteral isRows = SqlLiteral.createBoolean(group.isRows, POS);
            SqlNode lowerBound = null;
            SqlNode upperBound = null;
            SqlLiteral allowPartial = null;
            for (Window.RexWinAggCall winAggCall : group.aggCalls) {
                SqlAggFunction aggFunction = (SqlAggFunction)winAggCall.getOperator();
                SqlWindow sqlWindow = SqlWindow.create(null, null, new SqlNodeList(partitionKeys, POS), new SqlNodeList(orderByKeys, POS), isRows, lowerBound, upperBound, allowPartial, POS);
                if (aggFunction.allowsFraming()) {
                    lowerBound = this.createSqlWindowBound(group.lowerBound);
                    upperBound = this.createSqlWindowBound(group.upperBound);
                    sqlWindow.setLowerBound(lowerBound);
                    sqlWindow.setUpperBound(upperBound);
                }
                RexShuttle replaceConstants = new RexShuttle(){

                    @Override
                    public RexNode visitInputRef(RexInputRef inputRef) {
                        int index = inputRef.getIndex();
                        RexNode ref = index > inputFieldCount - 1 ? (RexNode)constants.get(index - inputFieldCount) : inputRef;
                        return ref;
                    }
                };
                RexCall aggCall = (RexCall)winAggCall.accept(replaceConstants);
                List<SqlNode> operands = this.toSql(null, (List<RexNode>)aggCall.operands);
                rexOvers.add(Context.createOverCall(aggFunction, operands, sqlWindow, winAggCall.distinct));
            }
            return rexOvers;
        }

        protected Context getAliasContext(RexCorrelVariable variable) {
            throw new UnsupportedOperationException();
        }

        private SqlCall toSql(@Nullable RexProgram program, RexOver rexOver) {
            RexWindow rexWindow = rexOver.getWindow();
            SqlNodeList partitionList = new SqlNodeList(this.toSql(program, (List<RexNode>)rexWindow.partitionKeys), POS);
            Expressions.FluentList orderNodes = Expressions.list();
            if (rexWindow.orderKeys != null) {
                for (RexFieldCollation rfc : rexWindow.orderKeys) {
                    this.addOrderItem((List<SqlNode>)orderNodes, program, rfc);
                }
            }
            SqlNodeList orderList = new SqlNodeList((Collection<? extends SqlNode>)orderNodes, POS);
            SqlLiteral isRows = SqlLiteral.createBoolean(rexWindow.isRows(), POS);
            SqlLiteral allowPartial = null;
            SqlAggFunction sqlAggregateFunction = rexOver.getAggOperator();
            SqlNode lowerBound = null;
            SqlNode upperBound = null;
            if (sqlAggregateFunction.allowsFraming()) {
                lowerBound = this.createSqlWindowBound(rexWindow.getLowerBound());
                upperBound = this.createSqlWindowBound(rexWindow.getUpperBound());
            }
            SqlWindow sqlWindow = SqlWindow.create(null, null, partitionList, orderList, isRows, lowerBound, upperBound, allowPartial, POS);
            List<SqlNode> nodeList = this.toSql(program, rexOver.getOperands());
            return Context.createOverCall(sqlAggregateFunction, nodeList, sqlWindow, rexOver.isDistinct());
        }

        private static SqlCall createOverCall(SqlAggFunction op, List<SqlNode> operands, SqlWindow window, boolean isDistinct) {
            if (op instanceof SqlSumEmptyIsZeroAggFunction) {
                SqlCall node = Context.createOverCall(SqlStdOperatorTable.SUM, operands, window, isDistinct);
                return SqlStdOperatorTable.COALESCE.createCall(POS, node, ZERO);
            }
            SqlCall aggFunctionCall = isDistinct ? op.createCall(SqlSelectKeyword.DISTINCT.symbol(POS), POS, operands) : op.createCall(POS, operands);
            return SqlStdOperatorTable.OVER.createCall(POS, aggFunctionCall, window);
        }

        private SqlNode toSql(@Nullable RexProgram program, RexFieldCollation rfc) {
            SqlNode node = this.toSql(program, (RexNode)rfc.left);
            switch (rfc.getDirection()) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    node = SqlStdOperatorTable.DESC.createCall(POS, node);
                    break;
                }
            }
            if (rfc.getNullDirection() != this.dialect.defaultNullDirection(rfc.getDirection())) {
                switch (rfc.getNullDirection()) {
                    case FIRST: {
                        node = SqlStdOperatorTable.NULLS_FIRST.createCall(POS, node);
                        break;
                    }
                    case LAST: {
                        node = SqlStdOperatorTable.NULLS_LAST.createCall(POS, node);
                        break;
                    }
                }
            }
            return node;
        }

        private SqlNode createSqlWindowBound(RexWindowBound rexWindowBound) {
            if (rexWindowBound.isCurrentRow()) {
                return SqlWindow.createCurrentRow(POS);
            }
            if (rexWindowBound.isPreceding()) {
                if (rexWindowBound.isUnbounded()) {
                    return SqlWindow.createUnboundedPreceding(POS);
                }
                SqlNode literal = this.toSql(null, rexWindowBound.getOffset());
                return SqlWindow.createPreceding(literal, POS);
            }
            if (rexWindowBound.isFollowing()) {
                if (rexWindowBound.isUnbounded()) {
                    return SqlWindow.createUnboundedFollowing(POS);
                }
                SqlNode literal = this.toSql(null, rexWindowBound.getOffset());
                return SqlWindow.createFollowing(literal, POS);
            }
            throw new AssertionError((Object)("Unsupported Window bound: " + rexWindowBound));
        }

        private List<SqlNode> toSql(@Nullable RexProgram program, List<RexNode> operandList) {
            ArrayList<SqlNode> list = new ArrayList<SqlNode>();
            for (RexNode rex : operandList) {
                list.add(this.toSql(program, rex));
            }
            return list;
        }

        public List<SqlNode> fieldList() {
            return new AbstractList<SqlNode>(){

                @Override
                public SqlNode get(int index) {
                    return this.field(index);
                }

                @Override
                public int size() {
                    return fieldCount;
                }
            };
        }

        void addOrderItem(List<SqlNode> orderByList, RelFieldCollation field) {
            if (field.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED) {
                boolean first = field.nullDirection == RelFieldCollation.NullDirection.FIRST;
                SqlNode nullDirectionNode = this.dialect.emulateNullDirection(this.field(field.getFieldIndex()), first, field.direction.isDescending());
                if (nullDirectionNode != null) {
                    orderByList.add(nullDirectionNode);
                    field = new RelFieldCollation(field.getFieldIndex(), field.getDirection(), RelFieldCollation.NullDirection.UNSPECIFIED);
                }
            }
            orderByList.add(this.toSql(field));
        }

        private void addOrderItem(List<SqlNode> orderByList, @Nullable RexProgram program, RexFieldCollation field) {
            SqlNode node = this.toSql(program, (RexNode)field.left);
            SqlNode nullDirectionNode = null;
            if (field.getNullDirection() != RelFieldCollation.NullDirection.UNSPECIFIED) {
                boolean first = field.getNullDirection() == RelFieldCollation.NullDirection.FIRST;
                nullDirectionNode = this.dialect.emulateNullDirection(node, first, field.getDirection().isDescending());
            }
            if (nullDirectionNode != null) {
                orderByList.add(nullDirectionNode);
                switch (field.getDirection()) {
                    case DESCENDING: 
                    case STRICTLY_DESCENDING: {
                        node = SqlStdOperatorTable.DESC.createCall(POS, node);
                        break;
                    }
                }
                orderByList.add(node);
            } else {
                orderByList.add(this.toSql(program, field));
            }
        }

        public SqlNode toSql(AggregateCall aggCall) {
            return this.toSql(aggCall.getAggregation(), aggCall.isDistinct(), Util.transform(aggCall.getArgList(), this::field), aggCall.filterArg, aggCall.collation, aggCall.isApproximate());
        }

        private SqlCall toSql(SqlOperator op, boolean distinct, List<SqlNode> operandList, int filterArg, RelCollation collation, boolean approximate) {
            SqlCall call2;
            SqlLiteral qualifier;
            SqlLiteral sqlLiteral = qualifier = distinct ? SqlSelectKeyword.DISTINCT.symbol(POS) : null;
            if (op instanceof SqlSumEmptyIsZeroAggFunction) {
                SqlCall node = this.toSql(SqlStdOperatorTable.SUM, distinct, (List<SqlNode>)operandList, filterArg, collation, approximate);
                return SqlStdOperatorTable.COALESCE.createCall(POS, node, ZERO);
            }
            if (filterArg >= 0 && !this.dialect.supportsAggregateFunctionFilter()) {
                SqlNodeList whenList = SqlNodeList.of(this.field(filterArg));
                SqlNodeList thenList = SqlNodeList.of(operandList.isEmpty() ? ONE : (SqlNode)operandList.get(0));
                SqlLiteral elseList = SqlLiteral.createNull(POS);
                SqlCall caseCall = SqlStdOperatorTable.CASE.createCall(null, POS, null, whenList, thenList, elseList);
                ArrayList<SqlNode> newOperandList = new ArrayList<SqlNode>();
                newOperandList.add(caseCall);
                if (operandList.size() > 1) {
                    newOperandList.addAll(Util.skip(operandList));
                }
                return this.toSql(op, distinct, newOperandList, -1, collation, approximate);
            }
            if (op instanceof SqlCountAggFunction && operandList.isEmpty()) {
                operandList = ImmutableList.of((Object)SqlIdentifier.STAR);
            }
            SqlCall call = op.createCall(qualifier, POS, (Iterable<? extends SqlNode>)operandList);
            if (distinct && approximate && this.dialect.supportsApproxCountDistinct()) {
                call2 = SqlStdOperatorTable.APPROX_COUNT_DISTINCT.createCall(POS, (List<? extends SqlNode>)operandList);
            } else if (filterArg < 0) {
                call2 = call;
            } else {
                assert (this.dialect.supportsAggregateFunctionFilter());
                call2 = SqlStdOperatorTable.FILTER.createCall(POS, call, this.field(filterArg));
            }
            return this.withOrder(call2, collation);
        }

        private SqlCall withOrder(SqlCall call, RelCollation collation) {
            if (collation.getFieldCollations().isEmpty()) {
                return call;
            }
            ArrayList<SqlNode> orderByList = new ArrayList<SqlNode>();
            for (RelFieldCollation field : collation.getFieldCollations()) {
                this.addOrderItem(orderByList, field);
            }
            return SqlStdOperatorTable.WITHIN_GROUP.createCall(POS, call, new SqlNodeList(orderByList, POS));
        }

        public SqlNode toSql(RelFieldCollation collation) {
            SqlNode node = this.orderField(collation.getFieldIndex());
            switch (collation.getDirection()) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    node = SqlStdOperatorTable.DESC.createCall(POS, node);
                    break;
                }
            }
            if (collation.nullDirection != this.dialect.defaultNullDirection(collation.direction)) {
                switch (collation.nullDirection) {
                    case FIRST: {
                        node = SqlStdOperatorTable.NULLS_FIRST.createCall(POS, node);
                        break;
                    }
                    case LAST: {
                        node = SqlStdOperatorTable.NULLS_LAST.createCall(POS, node);
                        break;
                    }
                }
            }
            return node;
        }

        public abstract SqlImplementor implementor();

        private static class RangeToSql<C extends Comparable<C>>
        implements RangeSets.Consumer<C> {
            private final List<SqlNode> list;
            private final Function<C, SqlNode> literalFactory;
            private final SqlNode arg;

            RangeToSql(SqlNode arg, List<SqlNode> list, Function<C, SqlNode> literalFactory) {
                this.arg = arg;
                this.list = list;
                this.literalFactory = literalFactory;
            }

            private void addAnd(SqlNode ... nodes) {
                this.list.add(SqlUtil.createCall(SqlStdOperatorTable.AND, POS, (List<SqlNode>)ImmutableList.copyOf((Object[])nodes)));
            }

            private SqlNode op(SqlOperator op, C value) {
                return op.createCall(POS, this.arg, this.literalFactory.apply(value));
            }

            @Override
            public void all() {
                this.list.add(SqlLiteral.createBoolean(true, POS));
            }

            @Override
            public void atLeast(C lower) {
                this.list.add(this.op(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower));
            }

            @Override
            public void atMost(C upper) {
                this.list.add(this.op(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
            }

            @Override
            public void greaterThan(C lower) {
                this.list.add(this.op(SqlStdOperatorTable.GREATER_THAN, lower));
            }

            @Override
            public void lessThan(C upper) {
                this.list.add(this.op(SqlStdOperatorTable.LESS_THAN, upper));
            }

            @Override
            public void singleton(C value) {
                this.list.add(this.op(SqlStdOperatorTable.EQUALS, value));
            }

            @Override
            public void closed(C lower, C upper) {
                this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower), this.op(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
            }

            @Override
            public void closedOpen(C lower, C upper) {
                this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower), this.op(SqlStdOperatorTable.LESS_THAN, upper));
            }

            @Override
            public void openClosed(C lower, C upper) {
                this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN, lower), this.op(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
            }

            @Override
            public void open(C lower, C upper) {
                this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN, lower), this.op(SqlStdOperatorTable.LESS_THAN, upper));
            }
        }
    }
}

