/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.internal;

import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.OptionalUtils;
import software.amazon.awssdk.utils.SystemSetting;

@SdkInternalApi
public final class SystemSettingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemSettingUtils.class);

    private SystemSettingUtils() {
    }

    public static Optional<String> resolveSetting(SystemSetting setting) {
        return OptionalUtils.firstPresent(SystemSettingUtils.resolveProperty(setting), () -> SystemSettingUtils.resolveEnvironmentVariable(setting), () -> SystemSettingUtils.resolveDefault(setting)).map(String::trim);
    }

    public static Optional<String> resolveNonDefaultSetting(SystemSetting setting) {
        return OptionalUtils.firstPresent(SystemSettingUtils.resolveProperty(setting), new Supplier[]{() -> SystemSettingUtils.resolveEnvironmentVariable(setting)}).map(String::trim);
    }

    private static Optional<String> resolveProperty(SystemSetting setting) {
        return Optional.ofNullable(setting.property()).map(System::getProperty);
    }

    private static Optional<String> resolveEnvironmentVariable(SystemSetting setting) {
        try {
            return Optional.ofNullable(setting.environmentVariable()).map(System::getenv);
        }
        catch (SecurityException e) {
            LOG.debug("Unable to load the environment variable '{}' because the security manager did not allow the SDK to read this system property. This setting will be assumed to be null", (Object)setting.environmentVariable(), (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<String> resolveDefault(SystemSetting setting) {
        return Optional.ofNullable(setting.defaultValue());
    }

    public static Boolean safeStringToBoolean(SystemSetting setting, String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalStateException("Environment variable '" + setting.environmentVariable() + "' or system property '" + setting.property() + "' was defined as '" + value + "', but should be 'false' or 'true'");
    }
}

