/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompletedPart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompletedPart> {
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(CompletedPart.getter(CompletedPart::eTag)).setter(CompletedPart.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartNumber").getter(CompletedPart.getter(CompletedPart::partNumber)).setter(CompletedPart.setter(Builder::partNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartNumber").unmarshallLocationName("PartNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E_TAG_FIELD, PART_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eTag;
    private final Integer partNumber;

    private CompletedPart(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.partNumber = builder.partNumber;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final Integer partNumber() {
        return this.partNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedPart)) {
            return false;
        }
        CompletedPart other = (CompletedPart)obj;
        return Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.partNumber(), other.partNumber());
    }

    public final String toString() {
        return ToString.builder((String)"CompletedPart").add("ETag", (Object)this.eTag()).add("PartNumber", (Object)this.partNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "PartNumber": {
                return Optional.ofNullable(clazz.cast(this.partNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompletedPart, T> g) {
        return obj -> g.apply((CompletedPart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eTag;
        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedPart model) {
            this.eTag(model.eTag);
            this.partNumber(model.partNumber);
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        @Transient
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        @Transient
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public CompletedPart build() {
            return new CompletedPart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompletedPart> {
        public Builder eTag(String var1);

        public Builder partNumber(Integer var1);
    }
}

