/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.SimulatedMontgomeryCurve;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

public abstract class RFC7748Curve
extends SimulatedMontgomeryCurve {
    private Logger LOGGER = LogManager.getLogger();

    protected RFC7748Curve(BigInteger a, BigInteger b, BigInteger modulus, BigInteger basePointX, BigInteger basePointY, BigInteger basePointOrder) {
        super(a, b, modulus, basePointX, basePointY, basePointOrder);
    }

    public abstract BigInteger decodeScalar(BigInteger var1);

    public abstract BigInteger decodeCoordinate(BigInteger var1);

    public abstract byte[] encodeCoordinate(BigInteger var1);

    public byte[] computePublicKey(BigInteger privateKey) {
        privateKey = this.reduceLongKey(privateKey);
        BigInteger decodedKey = this.decodeScalar(privateKey);
        Point publicPoint = this.mult(decodedKey, this.getBasePoint());
        return this.encodeCoordinate(publicPoint.getX().getData());
    }

    public byte[] computeSharedSecret(BigInteger privateKey, byte[] publicKey) {
        Point sharedPoint;
        privateKey = this.reduceLongKey(privateKey);
        BigInteger decodedCoord = this.decodeCoordinate(new BigInteger(1, publicKey));
        BigInteger decodedKey = this.decodeScalar(privateKey);
        Point publicPoint = this.createAPointOnCurve(decodedCoord);
        if (publicPoint == null) {
            this.LOGGER.warn("Could not create a point on curve. Using non-point");
            publicPoint = this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        if ((sharedPoint = this.mult(decodedKey, publicPoint)).getX() == null) {
            this.LOGGER.warn("Cannot encode point in infinity. Using X coordinate of base point as shared secret");
            return this.encodeCoordinate(this.getBasePoint().getX().getData());
        }
        return this.encodeCoordinate(sharedPoint.getX().getData());
    }

    public byte[] computeSharedSecret(BigInteger privateKey, Point publicKey) {
        byte[] pkBytes = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)publicKey.getX().getData(), (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length);
        return this.computeSharedSecret(privateKey, pkBytes);
    }

    public byte[] computeSharedSecretDecodedPoint(BigInteger privateKey, Point publicKey) {
        byte[] reEncoded = this.encodeCoordinate(publicKey.getX().getData());
        return this.computeSharedSecret(privateKey, reEncoded);
    }

    public BigInteger reduceLongKey(BigInteger key) {
        byte[] keyBytes = key.toByteArray();
        if (keyBytes.length > ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length) {
            keyBytes = Arrays.copyOfRange((byte[])keyBytes, (int)0, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length);
            return new BigInteger(1, keyBytes);
        }
        return key;
    }
}

