/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.reports.common.TripsConfig;
import org.traccar.session.cache.CacheManager;
import org.traccar.session.state.MotionProcessor;
import org.traccar.session.state.MotionState;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
@ChannelHandler.Sharable
public class MotionEventHandler
extends BaseEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotionEventHandler.class);
    private final CacheManager cacheManager;
    private final Storage storage;
    private final TripsConfig tripsConfig;

    @Inject
    public MotionEventHandler(CacheManager cacheManager, Storage storage, TripsConfig tripsConfig) {
        this.cacheManager = cacheManager;
        this.storage = storage;
        this.tripsConfig = tripsConfig;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        long deviceId = position.getDeviceId();
        Device device = this.cacheManager.getObject(Device.class, deviceId);
        if (device == null) {
            return null;
        }
        if (!PositionUtil.isLatest(this.cacheManager, position) || !this.tripsConfig.getProcessInvalidPositions() && !position.getValid()) {
            return null;
        }
        MotionState state = MotionState.fromDevice(device);
        MotionProcessor.updateState(state, position, position.getBoolean("motion"), this.tripsConfig);
        if (state.isChanged()) {
            state.toDevice(device);
            try {
                this.storage.updateObject(device, new Request((Columns)new Columns.Include("motionStreak", "motionState", "motionTime", "motionDistance"), new Condition.Equals("id", device.getId())));
            }
            catch (StorageException e) {
                LOGGER.warn("Update device motion error", (Throwable)e);
            }
        }
        return state.getEvent() != null ? Collections.singletonMap(state.getEvent(), position) : null;
    }
}

