/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.poi.ss.util.WorkbookUtil;
import org.jxls.common.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Position;
import org.traccar.reports.common.ReportUtils;
import org.traccar.reports.model.DeviceReportSection;
import org.traccar.reports.model.TripReportItem;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class TripsReportProvider {
    private final Config config;
    private final ReportUtils reportUtils;
    private final Storage storage;

    @Inject
    public TripsReportProvider(Config config, ReportUtils reportUtils, Storage storage) {
        this.config = config;
        this.reportUtils = reportUtils;
        this.storage = storage;
    }

    private Collection<TripReportItem> detectTrips(Device device, Date from, Date to) throws StorageException {
        boolean ignoreOdometer = this.config.getBoolean(Keys.REPORT_IGNORE_ODOMETER);
        List<Position> positions = PositionUtil.getPositions(this.storage, device.getId(), from, to);
        return this.reportUtils.detectTripsAndStops(device, positions, ignoreOdometer, TripReportItem.class);
    }

    public Collection<TripReportItem> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to) throws StorageException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<TripReportItem> result = new ArrayList<TripReportItem>();
        for (Device device : this.reportUtils.getAccessibleDevices(userId, deviceIds, groupIds)) {
            result.addAll(this.detectTrips(device, from, to));
        }
        return result;
    }

    public void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to) throws StorageException, IOException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<DeviceReportSection> devicesTrips = new ArrayList<DeviceReportSection>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (Device device : this.reportUtils.getAccessibleDevices(userId, deviceIds, groupIds)) {
            Group group;
            Collection<TripReportItem> trips = this.detectTrips(device, from, to);
            DeviceReportSection deviceTrips = new DeviceReportSection();
            deviceTrips.setDeviceName(device.getName());
            sheetNames.add(WorkbookUtil.createSafeSheetName((String)deviceTrips.getDeviceName()));
            if (device.getGroupId() > 0L && (group = this.storage.getObject(Group.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getGroupId())))) != null) {
                deviceTrips.setGroupName(group.getName());
            }
            deviceTrips.setObjects(trips);
            devicesTrips.add(deviceTrips);
        }
        File file = Paths.get(this.config.getString(Keys.TEMPLATES_ROOT), "export", "trips.xlsx").toFile();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Context context = this.reportUtils.initializeContext(userId);
            context.putVar("devices", devicesTrips);
            context.putVar("sheetNames", sheetNames);
            context.putVar("from", (Object)from);
            context.putVar("to", (Object)to);
            this.reportUtils.processTemplateWithSheets(inputStream, outputStream, context);
        }
    }
}

