/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class HandleTpl {
    private ConstTpl space;
    private ConstTpl size;
    private ConstTpl ptrspace;
    private ConstTpl ptroffset;
    private ConstTpl ptrsize;
    private ConstTpl temp_space;
    private ConstTpl temp_offset;

    public ConstTpl getSpace() {
        return this.space;
    }

    public ConstTpl getPtrSpace() {
        return this.ptrspace;
    }

    public ConstTpl getPtrOffset() {
        return this.ptroffset;
    }

    public ConstTpl getPtrSize() {
        return this.ptrsize;
    }

    public ConstTpl getSize() {
        return this.size;
    }

    public ConstTpl getTempSpace() {
        return this.temp_space;
    }

    public ConstTpl getTempOffset() {
        return this.temp_offset;
    }

    public void setSize(ConstTpl sz) {
        this.size = new ConstTpl(sz);
    }

    public void setPtrSize(ConstTpl sz) {
        this.ptrsize = new ConstTpl(sz);
    }

    public void setPtrOffset(long val) {
        this.ptroffset = new ConstTpl(ConstTpl.const_type.real, val);
    }

    public void setTempOffset(long val) {
        this.temp_offset = new ConstTpl(ConstTpl.const_type.real, val);
    }

    public HandleTpl() {
        this.space = new ConstTpl();
        this.size = new ConstTpl();
        this.ptrspace = new ConstTpl();
        this.ptroffset = new ConstTpl();
        this.ptrsize = new ConstTpl();
        this.temp_space = new ConstTpl();
        this.temp_offset = new ConstTpl();
    }

    public HandleTpl(VarnodeTpl vn) {
        this.space = new ConstTpl(vn.getSpace());
        this.size = new ConstTpl(vn.getSize());
        this.ptrspace = new ConstTpl(ConstTpl.const_type.real, 0L);
        this.ptroffset = new ConstTpl(vn.getOffset());
        this.ptrsize = new ConstTpl();
        this.temp_space = new ConstTpl();
        this.temp_offset = new ConstTpl();
    }

    public HandleTpl(ConstTpl spc, ConstTpl sz, VarnodeTpl vn, AddrSpace t_space, long t_offset) {
        this.space = new ConstTpl(spc);
        this.size = new ConstTpl(sz);
        this.ptrspace = new ConstTpl(vn.getSpace());
        this.ptroffset = new ConstTpl(vn.getOffset());
        this.ptrsize = new ConstTpl(vn.getSize());
        this.temp_space = new ConstTpl(t_space);
        this.temp_offset = new ConstTpl(ConstTpl.const_type.real, t_offset);
    }

    public void fix(FixedHandle hand, ParserWalker walker) {
        if (this.ptrspace.getType() == ConstTpl.const_type.real) {
            this.space.fillinSpace(hand, walker);
            hand.size = (int)this.size.fix(walker);
            this.ptroffset.fillinOffset(hand, walker);
        } else {
            hand.space = this.space.fixSpace(walker);
            hand.size = (int)this.size.fix(walker);
            hand.offset_offset = this.ptroffset.fix(walker);
            hand.offset_space = this.ptrspace.fixSpace(walker);
            if (hand.offset_space.getType() == spacetype.IPTR_CONSTANT) {
                hand.offset_space = null;
                hand.offset_offset <<= hand.space.getScale();
                hand.offset_offset &= hand.space.getMask();
            } else {
                hand.offset_size = (int)this.ptrsize.fix(walker);
                hand.temp_space = this.temp_space.fixSpace(walker);
                hand.temp_offset = this.temp_offset.fix(walker);
            }
        }
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        this.space.changeHandleIndex(handmap);
        this.size.changeHandleIndex(handmap);
        this.ptrspace.changeHandleIndex(handmap);
        this.ptroffset.changeHandleIndex(handmap);
        this.ptrsize.changeHandleIndex(handmap);
        this.temp_space.changeHandleIndex(handmap);
        this.temp_offset.changeHandleIndex(handmap);
    }

    public void saveXml(PrintStream s) {
        s.append("<handle_tpl>");
        this.space.saveXml(s);
        this.size.saveXml(s);
        this.ptrspace.saveXml(s);
        this.ptroffset.saveXml(s);
        this.ptrsize.saveXml(s);
        this.temp_space.saveXml(s);
        this.temp_offset.saveXml(s);
        s.append("</handle_tpl>\n");
    }

    public void restoreXml(Element el, Translate trans) {
        List list = el.getChildren();
        this.space.restoreXml((Element)list.get(0), trans);
        this.size.restoreXml((Element)list.get(1), trans);
        this.ptrspace.restoreXml((Element)list.get(2), trans);
        this.ptroffset.restoreXml((Element)list.get(3), trans);
        this.ptrsize.restoreXml((Element)list.get(4), trans);
        this.temp_space.restoreXml((Element)list.get(5), trans);
        this.temp_offset.restoreXml((Element)list.get(6), trans);
    }

    public void dispose() {
    }
}

