/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;

public class DefaultDataType
extends DataTypeImpl {
    private static final long serialVersionUID = 1L;
    public static DefaultDataType dataType = new DefaultDataType();

    private DefaultDataType() {
        super(CategoryPath.ROOT, "undefined", null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "??";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Undefined Byte";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        try {
            int b = buf.getByte(0) & 0xFF;
            String rep = Integer.toHexString(b).toUpperCase() + "h";
            if (rep.length() == 2) {
                rep = "0" + rep;
            }
            if (b > 31 && b < 128) {
                rep = rep + "    " + (char)b;
            }
            return rep;
        }
        catch (MemoryAccessException e) {
            return "??";
        }
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(8, buf.getByte(0));
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        return this;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return this;
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        return dt == this;
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public void addParent(DataType dt) {
    }

    @Override
    public void removeParent(DataType dt) {
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }
}

