/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DialogComponentProvider;
import docking.DockingDialog;
import docking.ErrorReporter;
import docking.widgets.ScrollableTextArea;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ErrLogDialog
extends DialogComponentProvider {
    private static final int TEXT_ROWS = 30;
    private static final int TEXT_COLUMNS = 80;
    private static final int ERROR_BUFFER_SIZE = 1024;
    private static final String SEND = "Log Error...";
    private static final String DETAIL = "Details >>>";
    private static final String CLOSE = "<<< Close";
    private static final String EOL = "\n";
    private static final String SEPARATOR_LINE = "---------------------------------------------------";
    private static boolean isShowingDetails = false;
    private ErrorDetailsPanel detailsPanel;
    private JButton detailsButton;
    private JButton sendButton;
    private JPanel mainPanel;
    private static ErrorReporter errorReporter;

    public static ErrLogDialog createExceptionDialog(String title, String message, String details) {
        return new ErrLogDialog(title, message, details, true);
    }

    public static ErrLogDialog createLogMessageDialog(String title, String message, String details) {
        return new ErrLogDialog(title, message, details, false);
    }

    private ErrLogDialog(String title, String message, String details, boolean isException) {
        super(title != null ? title : "Error", true, false, true, false);
        this.setRememberSize(false);
        this.setRememberLocation(false);
        this.buildMainPanel(message, this.addUsefulReportingInfo(details), isException);
    }

    private String addUsefulReportingInfo(String details) {
        StringBuilder sb = new StringBuilder(details);
        sb.append(EOL);
        sb.append(SEPARATOR_LINE);
        sb.append(EOL);
        sb.append("Build Date: ");
        sb.append(Application.getBuildDate());
        sb.append(EOL);
        sb.append(Application.getName());
        sb.append(" Version: ");
        sb.append(Application.getApplicationVersion());
        sb.append(EOL);
        sb.append("Java Home: ");
        sb.append(System.getProperty("java.home"));
        sb.append(EOL);
        sb.append("JVM Version: ");
        sb.append(System.getProperty("java.vendor"));
        sb.append(" ");
        sb.append(System.getProperty("java.version"));
        sb.append(EOL);
        sb.append("OS: ");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append(" ");
        sb.append(System.getProperty("os.arch"));
        sb.append(EOL);
        sb.append("Workstation: ");
        sb.append(this.getHostname());
        sb.append(EOL);
        return sb.toString();
    }

    private Object getHostname() {
        String hostname = "<unknown>";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public static void setErrorReporter(ErrorReporter errorReporter) {
        ErrLogDialog.errorReporter = errorReporter;
    }

    public static ErrorReporter getErrorReporter() {
        return errorReporter;
    }

    private void buildMainPanel(String message, String details, boolean isException) {
        JPanel introPanel = new JPanel(new BorderLayout(10, 10));
        introPanel.add((Component)new GIconLabel(UIManager.getIcon("OptionPane.errorIcon"), 4), "West");
        introPanel.add((Component)new GHtmlLabel(HTMLUtilities.toHTML((String)message)), "Center");
        this.mainPanel = new JPanel(new BorderLayout(10, 20));
        this.mainPanel.add((Component)introPanel, "North");
        this.sendButton = new JButton(SEND);
        this.sendButton.addActionListener(e -> this.sendDetails());
        this.detailsPanel = new ErrorDetailsPanel();
        this.detailsButton = new JButton(isShowingDetails ? CLOSE : DETAIL);
        this.detailsButton.addActionListener(e -> {
            String label = this.detailsButton.getText();
            this.showDetails(label.equals(DETAIL));
        });
        if (isException) {
            this.detailsPanel.setExceptionMessage(details);
        } else {
            this.detailsPanel.setLogMessage(details);
        }
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (errorReporter != null) {
            buttonPanel.add(this.sendButton);
        }
        buttonPanel.add(this.detailsButton);
        introPanel.add((Component)buttonPanel, "East");
        this.mainPanel.add((Component)this.detailsPanel, "Center");
        this.addWorkPanel(this.mainPanel);
        this.addOKButton();
        this.detailsPanel.setVisible(isShowingDetails);
    }

    @Override
    protected void cancelCallback() {
        this.close();
    }

    @Override
    protected void okCallback() {
        this.cancelCallback();
    }

    private void sendDetails() {
        String details = this.detailsPanel.getDetails();
        String title = this.getTitle();
        this.close();
        errorReporter.report(this.rootPanel, title, details);
    }

    private void showDetails(boolean visible) {
        isShowingDetails = visible;
        String label = visible ? CLOSE : DETAIL;
        this.detailsButton.setText(label);
        this.detailsPanel.setVisible(visible);
        this.repack();
    }

    @Override
    protected void repack() {
        this.getDialog().setVisible(false);
        this.detailsPanel.invalidate();
        this.rootPanel.validate();
        super.repack();
        DockingDialog dialog = this.getDialog();
        Container parent = dialog.getParent();
        Point centerPoint = WindowUtilities.centerOnComponent((Component)parent, (Component)dialog);
        dialog.setLocation(centerPoint);
        this.getDialog().setVisible(true);
    }

    @Override
    protected void dialogShown() {
        WindowUtilities.ensureOnScreen((Component)this.getDialog());
    }

    private class ErrorDetailsPanel
    extends JPanel {
        private ScrollableTextArea textDetails;
        private StringBuffer errorDetailsBuffer;
        private Dimension closedSize;
        private Dimension openedSize;

        private ErrorDetailsPanel() {
            super(new BorderLayout(0, 0));
            this.errorDetailsBuffer = new StringBuffer(1024);
            this.textDetails = new ScrollableTextArea(30, 80);
            this.textDetails.setEditable(false);
            this.add((Component)this.textDetails, "Center");
            this.validate();
            this.textDetails.scrollToBottom();
            Rectangle bounds = this.getBounds();
            this.closedSize = new Dimension(bounds.width, 0);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    if (!ErrorDetailsPanel.this.isShowing()) {
                        return;
                    }
                    Rectangle localBounds = ErrorDetailsPanel.this.getBounds();
                    if (ErrLogDialog.this.detailsButton.getText().equals(ErrLogDialog.DETAIL)) {
                        ErrorDetailsPanel.this.closedSize.width = localBounds.width;
                    } else {
                        ErrorDetailsPanel.this.openedSize = new Dimension(localBounds.width, localBounds.height);
                    }
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            if (ErrLogDialog.this.detailsButton.getText().equals(ErrLogDialog.DETAIL)) {
                return this.closedSize;
            }
            if (this.openedSize == null) {
                return super.getPreferredSize();
            }
            return this.openedSize;
        }

        private void setLogMessage(String msg) {
            this.errorDetailsBuffer = new StringBuffer(msg);
            this.textDetails.setText(msg);
            this.textDetails.scrollToBottom();
        }

        private void setExceptionMessage(String msg) {
            this.errorDetailsBuffer = new StringBuffer(msg);
            this.textDetails.setText(msg);
            this.textDetails.scrollToTop();
        }

        private final String getDetails() {
            return this.errorDetailsBuffer.toString();
        }
    }
}

