/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.catacombae.dmgextractor.encodings.encrypted.ReadableCEncryptedEncodingStream;
import org.catacombae.dmgextractor.ui.PasswordDialog;
import org.catacombae.hfsexplorer.DebugConsoleWindow;
import org.catacombae.hfsexplorer.ExtractProgressDialog;
import org.catacombae.hfsexplorer.ExtractProgressMonitor;
import org.catacombae.hfsexplorer.FileInfoWindow;
import org.catacombae.hfsexplorer.FileNameTools;
import org.catacombae.hfsexplorer.FileSystemBrowser;
import org.catacombae.hfsexplorer.FileSystemRecognizer;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.HFSExplorer;
import org.catacombae.hfsexplorer.IOUtil;
import org.catacombae.hfsexplorer.Java6Specific;
import org.catacombae.hfsexplorer.Java6Util;
import org.catacombae.hfsexplorer.MacSpecific;
import org.catacombae.hfsexplorer.ObjectContainer;
import org.catacombae.hfsexplorer.PartitionSystemRecognizer;
import org.catacombae.hfsexplorer.SelectWindowsDeviceDialog;
import org.catacombae.hfsexplorer.SimpleDictionaryParser;
import org.catacombae.hfsexplorer.SimpleFileFilter;
import org.catacombae.hfsexplorer.SimpleGUIProgressMonitor;
import org.catacombae.hfsexplorer.SimplerFileFilter;
import org.catacombae.hfsexplorer.SpeedUnitUtils;
import org.catacombae.hfsexplorer.UDIFRecognizer;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.VolumeInfoWindow;
import org.catacombae.hfsexplorer.fs.AppleSingleBuilder;
import org.catacombae.hfsexplorer.fs.ProgressMonitor;
import org.catacombae.hfsexplorer.gui.ErrorSummaryPanel;
import org.catacombae.hfsexplorer.gui.FileOperationsPanel;
import org.catacombae.hfsexplorer.gui.MemoryStatisticsPanel;
import org.catacombae.hfsexplorer.helpbrowser.HelpBrowserPanel;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.hfsexplorer.types.hfs.ExtDescriptor;
import org.catacombae.hfsexplorer.types.hfs.HFSPlusWrapperMDB;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusVolumeHeader;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ReadableStreamDataLocator;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.FSFork;
import org.catacombae.jparted.lib.fs.FSForkType;
import org.catacombae.jparted.lib.fs.FSLink;
import org.catacombae.jparted.lib.fs.FileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.FileSystemMajorType;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFileSystemHandler;
import org.catacombae.jparted.lib.ps.PartitionType;
import org.catacombae.udif.UDIFRandomAccessStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemBrowserWindow
extends JFrame {
    private static final String TITLE_STRING = "HFSExplorer 0.21";
    private static final ImageIcon[] WINDOW_ICONS = new ImageIcon[]{new ImageIcon(ClassLoader.getSystemResource("res/finderdrive_folderback_16.png")), new ImageIcon(ClassLoader.getSystemResource("res/finderdrive_folderback_32.png")), new ImageIcon(ClassLoader.getSystemResource("res/finderdrive_folderback_48.png"))};
    private static final String[] VERSION_INFO_DICTIONARY = new String[]{"http://www.typhontools.cjb.net/hfsx/version.sdic.txt", "http://hem.bredband.net/unsound/hfsx/version.sdic.txt"};
    private static final String DEBUG_CONSOLE_ARG = "-dbgconsole";
    private FileSystemBrowser<FSEntry> fsb;
    private JCheckBoxMenuItem toggleCachingItem;
    private final LinkedList<File> tempFiles = new LinkedList();
    private final JFileChooser fileChooser = new JFileChooser();
    private final DebugConsoleWindow dcw;
    private HFSCommonFileSystemHandler fsHandler = null;
    private DataLocator fsDataLocator;

    public FileSystemBrowserWindow() {
        this((DebugConsoleWindow)null);
    }

    public FileSystemBrowserWindow(DebugConsoleWindow dcw) {
        super(TITLE_STRING);
        this.dcw = dcw;
        if (Java6Util.isJava6OrHigher()) {
            Java6Specific.setIconImages(WINDOW_ICONS, this);
        } else {
            this.setIconImage(WINDOW_ICONS[0].getImage());
        }
        this.fsb = new FileSystemBrowser<FSEntry>(new FileSystemProvider());
        this.setUpMenus();
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            MacSpecific.registerMacApplicationHandler(new MacSpecific.MacApplicationHandler(){

                public boolean acceptQuit() {
                    FileSystemBrowserWindow.this.exitApplication();
                    return false;
                }

                public void showAboutDialog() {
                    FileSystemBrowserWindow.this.actionShowAboutDialog();
                }
            });
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                FileSystemBrowserWindow.this.exitApplication();
            }
        });
        this.setDefaultCloseOperation(0);
        this.add((Component)this.fsb.getViewComponent(), "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void setUpMenus() {
        JMenuItem loadFSFromDeviceItem = null;
        if (WindowsLowLevelIO.isSystemSupported()) {
            loadFSFromDeviceItem = new JMenuItem("Load file system from device...");
            loadFSFromDeviceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    SelectWindowsDeviceDialog deviceDialog = new SelectWindowsDeviceDialog((Frame)FileSystemBrowserWindow.this, true, "Load file system from device");
                    deviceDialog.setVisible(true);
                    ReadableRandomAccessStream io = deviceDialog.getPartitionStream();
                    String pathName = deviceDialog.getPathName();
                    if (io != null) {
                        try {
                            FileSystemBrowserWindow.this.loadFS(io, pathName);
                        }
                        catch (Exception e) {
                            System.err.print("INFO: Non-critical exception when trying to load file system from \"" + pathName + "\": ");
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Could not find any file systems on device!", "Error", 0);
                        }
                    }
                }
            });
            loadFSFromDeviceItem.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        JMenuItem openUDIFItem = new JMenuItem("Load file system from file...");
        openUDIFItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileSystemBrowserWindow.this.fileChooser.setMultiSelectionEnabled(false);
                FileSystemBrowserWindow.this.fileChooser.setFileSelectionMode(0);
                SimpleFileFilter dmgFilter = new SimpleFileFilter();
                dmgFilter.addExtension("dmg");
                dmgFilter.setDescription("Mac OS X disk images (*.dmg)");
                FileSystemBrowserWindow.this.fileChooser.addChoosableFileFilter(dmgFilter);
                SimpleFileFilter cdrFilter = new SimpleFileFilter();
                cdrFilter.addExtension("iso");
                cdrFilter.addExtension("cdr");
                cdrFilter.setDescription("CD/DVD image (*.iso,*.cdr)");
                FileSystemBrowserWindow.this.fileChooser.addChoosableFileFilter(cdrFilter);
                SimpleFileFilter imgFilter = new SimpleFileFilter();
                imgFilter.addExtension("img");
                imgFilter.setDescription("Raw disk image (*.img)");
                FileSystemBrowserWindow.this.fileChooser.addChoosableFileFilter(imgFilter);
                FileSystemBrowserWindow.this.fileChooser.setFileFilter(FileSystemBrowserWindow.this.fileChooser.getAcceptAllFileFilter());
                int res = FileSystemBrowserWindow.this.fileChooser.showOpenDialog(FileSystemBrowserWindow.this);
                if (res == 0) {
                    try {
                        File selectedFile = FileSystemBrowserWindow.this.fileChooser.getSelectedFile();
                        String pathName = selectedFile.getCanonicalPath();
                        FileSystemBrowserWindow.this.loadFSWithUDIFAutodetect(pathName);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Count not resolve pathname!", "Error", 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Could not read contents of partition!", "Error", 0);
                    }
                }
                FileSystemBrowserWindow.this.fileChooser.resetChoosableFileFilters();
            }
        });
        openUDIFItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem loadFromPathItem = new JMenuItem("Load file system from path...");
        loadFromPathItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String path = JOptionPane.showInputDialog(FileSystemBrowserWindow.this, "Pathname to load:", "Load file system from path", 3);
                if (path != null) {
                    try {
                        FileSystemBrowserWindow.this.loadFSWithUDIFAutodetect(path);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Could not read contents of partition!", "Error", 0);
                    }
                }
            }
        });
        loadFromPathItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem debugConsoleItem = null;
        if (this.dcw != null) {
            debugConsoleItem = new JMenuItem("Debug console");
            debugConsoleItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    FileSystemBrowserWindow.this.dcw.setVisible(true);
                }
            });
        }
        JMenuItem exitProgramItem = null;
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            exitProgramItem = new JMenuItem("Exit");
            exitProgramItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    FileSystemBrowserWindow.this.exitApplication();
                }
            });
            exitProgramItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        JMenuItem fsInfoItem = new JMenuItem("File system info");
        fsInfoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (FileSystemBrowserWindow.this.ensureFileSystemLoaded()) {
                    VolumeInfoWindow infoWindow = new VolumeInfoWindow(FileSystemBrowserWindow.this.fsHandler.getFSView());
                    infoWindow.setVisible(true);
                    CommonHFSVolumeHeader cvh = FileSystemBrowserWindow.this.fsHandler.getFSView().getVolumeHeader();
                    if (cvh instanceof CommonHFSVolumeHeader.HFSPlusImplementation) {
                        HFSPlusVolumeHeader vh = ((CommonHFSVolumeHeader.HFSPlusImplementation)cvh).getUnderlying();
                    }
                }
            }
        });
        fsInfoItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.toggleCachingItem = new JCheckBoxMenuItem("Use file system caching");
        this.toggleCachingItem.setState(true);
        this.toggleCachingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (FileSystemBrowserWindow.this.fsHandler != null) {
                    if (FileSystemBrowserWindow.this.toggleCachingItem.getState()) {
                        System.out.print("Enabling caching...");
                        FileSystemBrowserWindow.this.fsHandler.getFSView().enableFileSystemCaching();
                        System.out.println("done!");
                    } else {
                        System.out.print("Disabling caching...");
                        FileSystemBrowserWindow.this.fsHandler.getFSView().disableFileSystemCaching();
                        System.out.println("done!");
                    }
                }
            }
        });
        JMenuItem memoryStatisticsItem = new JMenuItem("Memory statistics");
        memoryStatisticsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MemoryStatisticsPanel.createMemoryStatisticsWindow().setVisible(true);
            }
        });
        JMenuItem createDiskImageItem = new JMenuItem("Create disk image...");
        createDiskImageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (FileSystemBrowserWindow.this.ensureFileSystemLoaded()) {
                    FileSystemBrowserWindow.this.actionExtractToDiskImage();
                }
            }
        });
        JMenuItem startHelpBrowserItem = new JMenuItem("Help browser");
        startHelpBrowserItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File f = new File("doc/html/index.html");
                if (f.exists()) {
                    try {
                        HelpBrowserPanel.showHelpBrowserWindow("HFSExplorer help browser", f.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                        Logger.getLogger(FileSystemBrowserWindow.class.getName()).log(Level.WARNING, null, ex);
                    }
                }
            }
        });
        JMenuItem checkUpdatesItem = new JMenuItem("Check for updates...");
        checkUpdatesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InputStream infoDictStream = null;
                for (String s : VERSION_INFO_DICTIONARY) {
                    try {
                        System.out.println("Retrieving version info from " + s + "...");
                        infoDictStream = new URL(s).openStream();
                        SimpleDictionaryParser sdp = new SimpleDictionaryParser(infoDictStream);
                        String dictVersion = sdp.getValue("Version");
                        long dictBuildNumber = Long.parseLong(sdp.getValue("Build"));
                        System.out.println("  Version: " + dictVersion);
                        System.out.println("  Build number: " + dictBuildNumber);
                        boolean dictVersionIsHigher = false;
                        boolean bl = dictVersionIsHigher = dictBuildNumber > 1081L;
                        if (dictVersionIsHigher) {
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "There are updates available!\nLatest version is: " + dictVersion + " (build number #" + dictBuildNumber + ")", "Information", 1);
                        } else {
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "There are no updates available.", "Information", 1);
                        }
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Could not contact version URL.", "Error", 0);
            }
        });
        JMenuItem aboutItem = null;
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            aboutItem = new JMenuItem("About...");
            aboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    FileSystemBrowserWindow.this.actionShowAboutDialog();
                }
            });
        }
        JMenu fileMenu = new JMenu("File");
        JMenu infoMenu = new JMenu("Tools");
        JMenu helpMenu = new JMenu("Help");
        if (loadFSFromDeviceItem != null) {
            fileMenu.add(loadFSFromDeviceItem);
        }
        fileMenu.add(openUDIFItem);
        fileMenu.add(loadFromPathItem);
        if (debugConsoleItem != null) {
            fileMenu.add(debugConsoleItem);
        }
        if (exitProgramItem != null) {
            fileMenu.add(exitProgramItem);
        }
        infoMenu.add(fsInfoItem);
        infoMenu.add(this.toggleCachingItem);
        infoMenu.add(createDiskImageItem);
        infoMenu.add(memoryStatisticsItem);
        helpMenu.add(startHelpBrowserItem);
        helpMenu.add(checkUpdatesItem);
        if (aboutItem != null) {
            helpMenu.add(aboutItem);
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(infoMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    private boolean ensureFileSystemLoaded() {
        if (this.fsHandler != null) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "No file system loaded.", "Error", 0);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitApplication() {
        try {
            if (this.tempFiles.size() > 0) {
                long totalFileSize = 0L;
                for (File tempFile : this.tempFiles) {
                    totalFileSize += tempFile.length();
                }
                int res = JOptionPane.showConfirmDialog(this, "You have " + this.tempFiles.size() + " temporary files with a total size of " + totalFileSize + " bytes in:\n    \"" + System.getProperty("java.io.tmpdir") + "\"\nDo you want to delete them now?", "Cleanup on program exit", 1, 3);
                if (res == 0) {
                    block8: for (File tempFile : this.tempFiles) {
                        if (!tempFile.exists()) continue;
                        boolean delRes = tempFile.delete();
                        while (!delRes) {
                            int res2 = JOptionPane.showConfirmDialog(this, "Could not delete file:\n    \"" + tempFile.getAbsolutePath() + "\"\nTry again?", "Could not delete file", 1, 0);
                            if (res2 != 0) {
                                if (res2 == 1) continue block8;
                                return;
                            }
                            delRes = tempFile.delete();
                        }
                    }
                } else if (res != 1) {
                    return;
                }
            }
            this.setVisible(false);
            if (this.fsHandler != null) {
                this.fsHandler.close();
            }
        }
        catch (Throwable t) {
            GUIUtil.displayExceptionDialog((Throwable)t, (int)20, (Component)this, (String)"Exception when exiting application");
        }
        finally {
            System.exit(0);
        }
    }

    public void loadFSWithUDIFAutodetect(String filename) {
        this.loadFSWithUDIFAutodetect(filename, 0L);
    }

    public void loadFSWithUDIFAutodetect(String filename, long pos) {
        try {
            String displayName;
            WindowsLowLevelIO fsFile;
            block21: {
                block20: {
                    fsFile = WindowsLowLevelIO.isSystemSupported() ? new WindowsLowLevelIO(filename) : new ReadableFileStream(filename);
                    try {
                        System.err.println("Trying to detect CEncryptedEncoding structure...");
                        if (ReadableCEncryptedEncodingStream.isCEncryptedEncoding((ReadableRandomAccessStream)fsFile)) {
                            System.err.println("CEncryptedEncoding structure found! Creating filter stream...");
                            while (true) {
                                char[] res;
                                if ((res = PasswordDialog.showDialog(null, (String)"Reading encrypted disk image...", (String)"You need to enter a password to unlock this disk image:")) == null) {
                                    return;
                                }
                                try {
                                    ReadableCEncryptedEncodingStream stream = new ReadableCEncryptedEncodingStream((ReadableRandomAccessStream)fsFile, res);
                                    fsFile = stream;
                                    break block20;
                                }
                                catch (Exception e) {
                                    JOptionPane.showMessageDialog(null, "Incorrect password.", "Reading encrypted disk image...", 0);
                                    continue;
                                }
                                break;
                            }
                        }
                        System.err.println("CEncryptedEncoding structure not found. Proceeding...");
                    }
                    catch (Exception e) {
                        System.err.println("[INFO] Non-critical exception while trying to detect CEncryptedEncoding structure:");
                        e.printStackTrace();
                    }
                }
                try {
                    System.err.println("Trying to detect UDIF structure...");
                    if (UDIFRecognizer.isUDIF(fsFile)) {
                        System.err.println("UDIF structure found! Creating filter stream...");
                        UDIFRandomAccessStream stream = null;
                        try {
                            stream = new UDIFRandomAccessStream((ReadableRandomAccessStream)fsFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (e.getMessage().startsWith("java.lang.RuntimeException: No handler for block type")) {
                                JOptionPane.showMessageDialog(this, "UDIF file contains unsupported block types!\n(The file was probably created with BZIP2 or ADC compression, which is unsupported currently)", "Error", 0);
                            } else {
                                JOptionPane.showMessageDialog(this, "UDIF file unsupported or damaged!", "Error", 0);
                            }
                            return;
                        }
                        if (stream != null) {
                            fsFile = stream;
                        }
                        break block21;
                    }
                    System.err.println("UDIF structure not found. Proceeding...");
                }
                catch (Exception e) {
                    System.err.println("[INFO] Non-critical exception while trying to detect UDIF structure:");
                    e.printStackTrace();
                }
            }
            if (pos != 0L) {
                fsFile = new ReadableConcatenatedStream((ReadableRandomAccessStream)fsFile, pos, fsFile.length() - pos);
            }
            try {
                displayName = new File(filename).getCanonicalFile().getName();
            }
            catch (Exception e) {
                displayName = filename;
            }
            this.loadFS(fsFile, displayName);
        }
        catch (Exception e) {
            System.err.println("Could not open file! Exception thrown:");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not open file:\n    \"" + filename + "\"", "Error", 0);
        }
    }

    public void loadFS(String filename) {
        WindowsLowLevelIO fsFile = WindowsLowLevelIO.isSystemSupported() ? new WindowsLowLevelIO(filename) : new ReadableFileStream(filename);
        this.loadFS(fsFile, new File(filename).getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadFS(ReadableRandomAccessStream fsFile, String displayName) {
        long fsLength;
        long fsOffset;
        int blockSize = 512;
        PartitionSystemRecognizer psRec = new PartitionSystemRecognizer(fsFile);
        PartitionSystem partSys = psRec.getPartitionSystem();
        if (partSys != null) {
            Object[] partitions = partSys.getUsedPartitionEntries();
            if (partitions.length == 0) {
                fsOffset = 0L;
                try {
                    fsLength = fsFile.length();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fsLength = -1L;
                }
            } else {
                Partition selectedPartition;
                Object selectedValue;
                block23: {
                    int firstPreferredPartition = 0;
                    for (int i = 0; i < partitions.length; ++i) {
                        Partition partition = partitions[i];
                        PartitionType pt = partition.getType();
                        if (pt != PartitionType.APPLE_HFS_CONTAINER && pt != PartitionType.APPLE_HFSX) continue;
                        firstPreferredPartition = i;
                        break;
                    }
                    while ((selectedValue = JOptionPane.showInputDialog(this, "Select which partition to read", "Choose " + partSys.getLongName() + " partition", 3, null, partitions, partitions[firstPreferredPartition])) != null && selectedValue instanceof Partition) {
                        selectedPartition = (Partition)selectedValue;
                        PartitionType partitionType = selectedPartition.getType();
                        if (partitionType != PartitionType.APPLE_HFS_CONTAINER && partitionType != PartitionType.APPLE_HFSX) {
                            JOptionPane.showMessageDialog(this, "Can't find handler for partition type \"" + (Object)((Object)selectedPartition.getType()) + "\"", "Unknown partition type", 0);
                            continue;
                        }
                        break block23;
                    }
                    return;
                }
                if (!(selectedValue instanceof Partition)) throw new RuntimeException("Impossible error!");
                selectedPartition = (Partition)selectedValue;
                fsOffset = selectedPartition.getStartOffset();
                fsLength = selectedPartition.getLength();
            }
        } else {
            fsOffset = 0L;
            try {
                fsLength = fsFile.length();
            }
            catch (Exception e) {
                e.printStackTrace();
                fsLength = -1L;
            }
        }
        FileSystemRecognizer fsr = new FileSystemRecognizer(fsFile, fsOffset);
        FileSystemRecognizer.FileSystemType fsType = fsr.detectFileSystem();
        if (fsType == FileSystemRecognizer.FileSystemType.HFS_WRAPPED_HFS_PLUS) {
            byte[] mdbData = new byte[170];
            fsFile.seek(fsOffset + 1024L);
            fsFile.read(mdbData);
            HFSPlusWrapperMDB mdb = new HFSPlusWrapperMDB(mdbData, 0);
            ExtDescriptor extDescriptor = mdb.getDrEmbedExtent();
            int hfsBlockSize = mdb.getDrAlBlkSiz();
            fsr = new FileSystemRecognizer(fsFile, fsOffset += (long)(mdb.getDrAlBlSt() * 512 + extDescriptor.getXdrStABN() * hfsBlockSize));
            fsType = fsr.detectFileSystem();
        }
        if (fsType == FileSystemRecognizer.FileSystemType.HFS_PLUS || fsType == FileSystemRecognizer.FileSystemType.HFSX || fsType == FileSystemRecognizer.FileSystemType.HFS) {
            void var15_26;
            FileSystemMajorType fsMajorType;
            this.fsb.setRoot(null);
            if (this.fsHandler != null) {
                this.fsHandler.close();
                this.fsHandler = null;
            }
            switch (fsType) {
                case HFS: {
                    fsMajorType = FileSystemMajorType.APPLE_HFS;
                    break;
                }
                case HFS_PLUS: {
                    fsMajorType = FileSystemMajorType.APPLE_HFS_PLUS;
                    break;
                }
                case HFSX: {
                    fsMajorType = FileSystemMajorType.APPLE_HFSX;
                    break;
                }
                default: {
                    fsMajorType = null;
                }
            }
            FileSystemHandlerFactory factory = fsMajorType.createDefaultHandlerFactory();
            if (factory.isSupported(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED)) {
                factory.getCreateAttributes().setBooleanAttribute(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED, (Boolean)this.toggleCachingItem.getState());
            }
            if (fsLength > 0L) {
                ReadableConcatenatedStream readableConcatenatedStream = new ReadableConcatenatedStream(fsFile, fsOffset, fsLength);
            } else {
                ReadableRandomAccessStream readableRandomAccessStream = fsFile;
            }
            this.fsDataLocator = new ReadableStreamDataLocator((ReadableRandomAccessStream)var15_26);
            this.fsHandler = (HFSCommonFileSystemHandler)factory.createHandler(this.fsDataLocator);
            FSFolder rootRecord = this.fsHandler.getRoot();
            this.populateFilesystemGUI(rootRecord);
            this.setTitle("HFSExplorer 0.21 - [" + displayName + "]");
            return;
        } else {
            JOptionPane.showMessageDialog(this, "Invalid HFS type.\nProgram supports:\n    " + (Object)((Object)FileSystemRecognizer.FileSystemType.HFS_PLUS) + "\n" + "    " + (Object)((Object)FileSystemRecognizer.FileSystemType.HFSX) + "\n" + "    " + (Object)((Object)FileSystemRecognizer.FileSystemType.HFS_WRAPPED_HFS_PLUS) + "\n" + "    " + (Object)((Object)FileSystemRecognizer.FileSystemType.HFS) + "\n" + "\nDetected type is (" + (Object)((Object)fsType) + ").", "Unsupported file system type", 0);
        }
    }

    private long extractForkToStream(FSFork theFork, OutputStream os, ProgressMonitor pm) throws IOException {
        long originalLength;
        long bytesToRead;
        int bytesRead;
        ReadableRandomAccessStream forkFilter = theFork.getReadableRandomAccessStream();
        byte[] buffer = new byte[4096];
        for (bytesToRead = originalLength = theFork.getLength(); bytesToRead > 0L && !pm.cancelSignaled() && (bytesRead = forkFilter.read(buffer, 0, bytesToRead < (long)buffer.length ? (int)bytesToRead : buffer.length)) >= 0; bytesToRead -= (long)bytesRead) {
            pm.addDataProgress(bytesRead);
            os.write(buffer, 0, bytesRead);
        }
        return originalLength - bytesToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long extractResourceForkToAppleDoubleStream(FSFork resourceFork, OutputStream os, ProgressMonitor pm) throws IOException {
        ReadableRandomAccessStream in = null;
        try {
            AppleSingleBuilder builder = new AppleSingleBuilder(AppleSingleBuilder.FileType.APPLEDOUBLE, AppleSingleBuilder.AppleSingleVersion.VERSION_2_0, AppleSingleBuilder.FileSystem.MACOS_X);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            in = resourceFork.getReadableRandomAccessStream();
            long extractedBytes = IOUtil.streamCopy((Readable)in, (OutputStream)baos, 131072);
            if (extractedBytes != resourceFork.getLength()) {
                System.err.println("WARNING: Did not extract intended number of bytes to resource fork! Intended: " + resourceFork.getLength() + " Extracted: " + extractedBytes);
            }
            builder.addResourceFork(baos.toByteArray());
            os.write(builder.getResult());
            pm.addDataProgress(extractedBytes);
            long l = extractedBytes;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void populateFilesystemGUI(FSFolder rootFolder) {
        FileSystemBrowser.Record<FSFolder> rootRecord = new FileSystemBrowser.Record<FSFolder>(FileSystemBrowser.RecordType.FOLDER, rootFolder.getName(), 0L, rootFolder.getAttributes().getModifyDate(), rootFolder);
        this.fsb.setRoot(rootRecord);
    }

    private void actionDoubleClickFile(final String[] parentPath, final FSFile rec) {
        String[] finalCommand;
        final JDialog fopFrame = new JDialog(this, rec.getName(), true);
        fopFrame.setDefaultCloseOperation(2);
        ActionListener alOpen = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            finalCommand = "cmd.exe /c start \"HFSExplorer invoker\" \"" + rec.getName() + "\"";
            alOpen = new ActionListener((String)finalCommand){
                final /* synthetic */ String val$finalCommand;
                {
                    this.val$finalCommand = string;
                }

                public void actionPerformed(ActionEvent ae) {
                    File tempDir = new File(System.getProperty("java.io.tmpdir"));
                    LinkedList<String> errorMessages = new LinkedList<String>();
                    FileSystemBrowserWindow.this.extract(parentPath, rec, tempDir, new SimpleGUIProgressMonitor(fopFrame), errorMessages, true);
                    if (errorMessages.size() == 0) {
                        FileSystemBrowserWindow.this.tempFiles.add(new File(tempDir, rec.getName()));
                        try {
                            Process p = Runtime.getRuntime().exec(this.val$finalCommand, null, tempDir);
                            fopFrame.dispose();
                        }
                        catch (Exception e) {
                            String stackTrace = e.toString() + "\n";
                            for (StackTraceElement ste : e.getStackTrace()) {
                                stackTrace = stackTrace + "    " + ste.toString() + "\n";
                            }
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Open failed. Exception caught:\n" + stackTrace, "Error", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Error while extracting file to temp dir.", "Error", 0);
                    }
                }
            };
        } else if (Java6Util.isJava6OrHigher() && Java6Specific.canOpen()) {
            alOpen = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    File tempDir = new File(System.getProperty("java.io.tmpdir"));
                    LinkedList<String> errorMessages = new LinkedList<String>();
                    FileSystemBrowserWindow.this.extract(parentPath, rec, tempDir, new SimpleGUIProgressMonitor(fopFrame), errorMessages, true);
                    if (errorMessages.size() == 0) {
                        File extractedFile = new File(tempDir, rec.getName());
                        FileSystemBrowserWindow.this.tempFiles.add(new File(tempDir, rec.getName()));
                        try {
                            Java6Specific.openFile(extractedFile);
                            fopFrame.dispose();
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Could not find a handler to open the file with.\nThe file remains in\n    \"" + tempDir + "\"\n" + "until you exit the program.", "Error", 0);
                        }
                        catch (Exception e) {
                            String stackTrace = e.toString() + "\n";
                            for (StackTraceElement ste : e.getStackTrace()) {
                                stackTrace = stackTrace + "    " + ste.toString() + "\n";
                            }
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Open failed. Exception caught:\n" + stackTrace, "Error", 0);
                        }
                    }
                }
            };
        } else if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            finalCommand = new String[]{"open", rec.getName()};
            alOpen = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    File tempDir = new File(System.getProperty("java.io.tmpdir"));
                    LinkedList<String> errorMessages = new LinkedList<String>();
                    FileSystemBrowserWindow.this.extract(parentPath, rec, tempDir, new SimpleGUIProgressMonitor(fopFrame), errorMessages, true);
                    if (errorMessages.size() == 0) {
                        FileSystemBrowserWindow.this.tempFiles.add(new File(tempDir, rec.getName()));
                        try {
                            Process p = Runtime.getRuntime().exec(finalCommand, null, tempDir);
                            fopFrame.dispose();
                        }
                        catch (Exception e) {
                            String stackTrace = e.toString() + "\n";
                            for (StackTraceElement ste : e.getStackTrace()) {
                                stackTrace = stackTrace + "    " + ste.toString() + "\n";
                            }
                            JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Open failed. Exception caught:\n" + stackTrace, "Error", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "Error while extracting file to temp dir.", "Error", 0);
                    }
                }
            };
        }
        ActionListener alSave = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileSystemBrowserWindow.this.actionExtractToDir(parentPath, rec);
                fopFrame.dispose();
            }
        };
        FileOperationsPanel fop = new FileOperationsPanel(fopFrame, rec.getName(), rec.getMainFork().getLength(), alOpen, alSave);
        fopFrame.add((Component)fop, "Center");
        fopFrame.pack();
        fopFrame.setLocationRelativeTo(null);
        fopFrame.setVisible(true);
    }

    private void actionExtractToDiskImage() {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(0);
        jfc.setMultiSelectionEnabled(false);
        SimplerFileFilter ffDmg = new SimplerFileFilter(".dmg", "Mac OS X read/write disk image (.dmg)");
        jfc.setFileFilter(ffDmg);
        if (jfc.showSaveDialog(this) == 0) {
            int res;
            File saveFile;
            File selectedFile = jfc.getSelectedFile();
            FileFilter selectedFileFilter = jfc.getFileFilter();
            if (selectedFileFilter instanceof SimplerFileFilter) {
                SimplerFileFilter sff = (SimplerFileFilter)selectedFileFilter;
                saveFile = !selectedFile.getName().endsWith(sff.getExtension()) ? new File(selectedFile.getParentFile(), selectedFile.getName() + sff.getExtension()) : selectedFile;
            } else {
                saveFile = selectedFile;
            }
            if (saveFile.exists() && (res = JOptionPane.showConfirmDialog(this, "The file:\n  " + saveFile.getPath() + "\nAlready exists. Do you want to overwrite?", "Confirm overwrite", 0, 3)) != 0) {
                return;
            }
            final javax.swing.ProgressMonitor pm = new javax.swing.ProgressMonitor(this, "Extracting file system data to disk image...", "Starting extraction...", 0, Integer.MAX_VALUE);
            pm.setMillisToDecideToPopup(0);
            pm.setMillisToPopup(0);
            pm.setProgress(0);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ReadableRandomAccessStream fsStream = FileSystemBrowserWindow.this.fsDataLocator.createReadOnlyFile();
                    FileOutputStream fileOut = null;
                    try {
                        int bytesRead;
                        fileOut = new FileOutputStream(saveFile);
                        DecimalFormat df = new DecimalFormat("0.00");
                        CommonHFSVolumeHeader vh = FileSystemBrowserWindow.this.fsHandler.getFSView().getVolumeHeader();
                        long bytesToExtract = vh.getFileSystemEnd();
                        String bytesToExtractString = SpeedUnitUtils.bytesToBinaryUnit((long)bytesToExtract, (DecimalFormat)df);
                        long lastUpdateTimestamp = 0L;
                        byte[] buffer = new byte[65536];
                        for (long bytesExtracted = 0L; bytesExtracted < bytesToExtract && !pm.isCanceled(); bytesExtracted += (long)bytesRead) {
                            long bytesLeftToRead = bytesToExtract - bytesExtracted;
                            int curBytesToRead = (int)(bytesLeftToRead < (long)buffer.length ? bytesLeftToRead : (long)buffer.length);
                            bytesRead = fsStream.read(buffer, 0, curBytesToRead);
                            if (bytesRead > 0) {
                                fileOut.write(buffer, 0, bytesRead);
                                long currentTimestamp = System.currentTimeMillis();
                                long millisSinceLastUpdate = currentTimestamp - lastUpdateTimestamp;
                                if (millisSinceLastUpdate < 40L) continue;
                                pm.setProgress((int)((double)bytesExtracted / (double)bytesToExtract * 2.147483647E9));
                                pm.setNote("Extracted " + SpeedUnitUtils.bytesToBinaryUnit((long)bytesExtracted, (DecimalFormat)df) + " / " + bytesToExtractString + " ...");
                                lastUpdateTimestamp = currentTimestamp;
                                continue;
                            }
                            throw new RuntimeException("Unexpectedly reached end of file! fp=" + fsStream.getFilePointer() + " length=" + fsStream.length() + " bytesExtracted=" + bytesExtracted + " bytesToExtract=" + bytesToExtract);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        GUIUtil.displayExceptionDialog((Throwable)e, (int)15, (Component)FileSystemBrowserWindow.this, (String)"Exception while extracting data!");
                    }
                    finally {
                        pm.close();
                        try {
                            fsStream.close();
                            if (fileOut != null) {
                                fileOut.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            GUIUtil.displayExceptionDialog((Throwable)e, (Component)FileSystemBrowserWindow.this);
                        }
                    }
                }
            };
            new Thread(r).start();
        }
    }

    private void actionExtractToDir(String[] parentPath, FSEntry entry) {
        this.actionExtractToDir(parentPath, Arrays.asList(entry));
    }

    private void actionExtractToDir(String[] parentPath, List<FSEntry> selection) {
        this.actionExtractToDir(parentPath, selection, true, false);
    }

    private void actionExtractToDir(final String[] parentPath, final List<FSEntry> selection, final boolean dataFork, final boolean resourceFork) {
        block6: {
            if (!dataFork && !resourceFork) {
                throw new IllegalArgumentException("Can't choose to extract nothing!");
            }
            try {
                if (selection.size() > 0) {
                    this.fileChooser.setMultiSelectionEnabled(false);
                    this.fileChooser.setFileSelectionMode(1);
                    this.fileChooser.setSelectedFiles(new File[0]);
                    if (this.fileChooser.showDialog(this, "Extract here") == 0) {
                        final File outDir = this.fileChooser.getSelectedFile();
                        final ExtractProgressDialog progress = new ExtractProgressDialog(this);
                        Runnable r = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    boolean followSymlinks;
                                    int res;
                                    LinkedList<FSForkType> forkTypes = new LinkedList<FSForkType>();
                                    if (dataFork) {
                                        forkTypes.add(FSForkType.DATA);
                                    }
                                    if (resourceFork) {
                                        forkTypes.add(FSForkType.MACOS_RESOURCE);
                                    }
                                    LinkedList<String> dirStack = new LinkedList<String>();
                                    if (parentPath != null) {
                                        for (String pathComponent : parentPath) {
                                            dirStack.addLast(pathComponent);
                                        }
                                    }
                                    if ((res = JOptionPane.showConfirmDialog(progress, "Do you want to follow symbolic links while extracting?\nFollowing symbolic links means that the extracted tree willmore closely match the percieved file system tree, but it\nincreases the size of the extracted data, the time that it takes to extract it, and puts a lot of identical files at\ndifferent locations in your target folder.", "Follow symbolic links?", 1, 3)) == 0) {
                                        followSymlinks = true;
                                    } else if (res == 1) {
                                        followSymlinks = false;
                                    } else {
                                        return;
                                    }
                                    long dataSize = FileSystemBrowserWindow.this.calculateForkSizeRecursive(parentPath, selection, progress, forkTypes, followSymlinks);
                                    if (progress.cancelSignaled()) {
                                        progress.confirmCancel();
                                    } else {
                                        progress.setDataSize(dataSize);
                                        LinkedList<String> errorMessages = new LinkedList<String>();
                                        FileSystemBrowserWindow.this.extract(parentPath, (List<FSEntry>)selection, outDir, (ExtractProgressMonitor)progress, errorMessages, followSymlinks, forkTypes);
                                        if (progress.cancelSignaled()) {
                                            errorMessages.addLast("User aborted extraction.");
                                        }
                                        if (!progress.cancelSignaled()) {
                                            if (errorMessages.size() == 0) {
                                                JOptionPane.showMessageDialog(progress, "Extraction finished.", "Information", 1);
                                            } else {
                                                ErrorSummaryPanel.createErrorSummaryDialog(progress, errorMessages).setVisible(true);
                                            }
                                        } else {
                                            JOptionPane.showMessageDialog(progress, "Extraction was aborted.\nPlease remove the extracted files manually.", "Aborted extraction", 2);
                                            progress.confirmCancel();
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    GUIUtil.displayExceptionDialog((Throwable)t, (Component)progress);
                                }
                                finally {
                                    progress.dispose();
                                }
                            }
                        };
                        new Thread(r).start();
                        progress.setVisible(true);
                    }
                    break block6;
                }
                if (selection.size() == 0) {
                    JOptionPane.showMessageDialog(this, "No file or folder selected.", "Information", 1);
                    break block6;
                }
                throw new RuntimeException("wtf?");
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                GUIUtil.displayExceptionDialog((Throwable)re, (Component)this);
            }
        }
    }

    private long calculateForkSizeRecursive(String[] parentPath, List<FSEntry> selection, ExtractProgressMonitor progress, LinkedList<FSForkType> forkTypes, boolean followSymlinks) {
        if (forkTypes.size() == 0) {
            for (FSForkType forkType : this.fsHandler.getSupportedForkTypes()) {
                forkTypes.add(forkType);
            }
        }
        CalculateTreeSizeVisitor sizeVisitor = new CalculateTreeSizeVisitor(progress, forkTypes);
        this.traverseTree(parentPath, selection, sizeVisitor, followSymlinks);
        return sizeVisitor.getSize();
    }

    private void traverseTree(String[] parentPath, List<FSEntry> entries, TreeVisitor visitor, boolean followSymbolicLinks) {
        LinkedList<String[]> absPathsStack = new LinkedList<String[]>();
        LinkedList<String> pathStack = new LinkedList<String>();
        if (parentPath != null) {
            absPathsStack.addLast(parentPath);
            for (String pathComponent : parentPath) {
                pathStack.addLast(pathComponent);
            }
        }
        FSEntry[] children = entries.toArray(new FSEntry[entries.size()]);
        this.traverseTreeRecursive(children, pathStack, absPathsStack, visitor, followSymbolicLinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseTreeRecursive(FSEntry[] selection, LinkedList<String> pathStack, LinkedList<String[]> absPathsStack, TreeVisitor visitor, boolean followSymbolicLinks) {
        if (visitor.cancelTraversal()) {
            return;
        }
        String[] pathStackArray = pathStack.toArray(new String[pathStack.size()]);
        String pathStackString = Util.concatenateStrings(pathStack, (String)"/");
        for (FSEntry curEntry : selection) {
            String msg;
            if (visitor.cancelTraversal()) break;
            String curEntryString = (pathStackString.length() > 0 ? pathStackString + "/" : "") + curEntry.getName();
            Object[] linkTargetPath = null;
            if (followSymbolicLinks && curEntry instanceof FSLink) {
                FSLink curLink = (FSLink)curEntry;
                Object[] targetPath = this.fsHandler.getTargetPath(curLink, pathStackArray);
                if (targetPath != null) {
                    if (Util.contains(absPathsStack, (Object[])targetPath)) {
                        msg = "Circular symlink detected: \"" + curEntryString + "\" -> \"" + curLink.getLinkTargetString() + "\"";
                        System.err.println();
                        System.err.println("traverseTreeRecursive: " + msg);
                        System.err.println();
                        visitor.traversalError(msg);
                        continue;
                    }
                    FSEntry linkTarget = this.fsHandler.getEntry((String[])targetPath);
                    if (linkTarget != null) {
                        curEntry = linkTarget;
                        linkTargetPath = targetPath;
                    } else {
                        String msg2 = "Could not get link target entry \"" + curLink.getLinkTargetString() + "\"";
                        System.err.println("WARNING: " + msg2);
                        visitor.traversalError(msg2);
                    }
                } else {
                    msg = "Could not resolve link \"" + curEntryString + "\" -> \"" + curLink.getLinkTargetString() + "\"";
                    System.err.println("WARNING: " + msg);
                    visitor.traversalError(msg);
                }
            }
            Object[] absolutePath = linkTargetPath != null ? linkTargetPath : (absPathsStack.size() > 0 ? Util.concatenate((String[])absPathsStack.getLast(), (String[])new String[]{curEntry.getName()}) : new String[]{});
            if (curEntry instanceof FSFile) {
                visitor.file((FSFile)curEntry);
                continue;
            }
            if (curEntry instanceof FSFolder) {
                FSFolder curFolder = (FSFolder)curEntry;
                if (absPathsStack.size() > 0) {
                    pathStack.addLast(curFolder.getName());
                }
                absPathsStack.addLast((String[])absolutePath);
                try {
                    if (!visitor.startDirectory(pathStackArray, curFolder)) continue;
                    this.traverseTreeRecursive(curFolder.listEntries(), pathStack, absPathsStack, visitor, followSymbolicLinks);
                    visitor.endDirectory(pathStackArray, curFolder);
                    continue;
                }
                finally {
                    absPathsStack.removeLast();
                    if (absPathsStack.size() > 0) {
                        pathStack.removeLast();
                    }
                }
            }
            if (curEntry instanceof FSLink) {
                FSLink curLink = (FSLink)curEntry;
                if (followSymbolicLinks) {
                    msg = "Unresolved link \"" + curEntryString + "\" -> \"" + curLink.getLinkTargetString() + "\"";
                    System.err.println(msg);
                }
                visitor.link((FSLink)curEntry);
                continue;
            }
            throw new RuntimeException("Unexpected FSEntry subclass: " + curEntry.getClass());
        }
    }

    private void actionShowAboutDialog() {
        String message = "";
        message = message + "HFSExplorer 0.21 Build #1081\n";
        message = message + "Copyright \u00a9 Erik Larsson 2006-2008\n";
        for (String notice : HFSExplorer.NOTICES) {
            message = message + notice + "\n";
        }
        message = message + "\nOperating system: " + System.getProperty("os.name") + " " + System.getProperty("os.version");
        message = message + "\nArchitecture: " + System.getProperty("os.arch");
        message = message + "\nJava Runtime Environment: " + System.getProperty("java.version");
        message = message + "\nVirtual machine: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
        JOptionPane.showMessageDialog(this, message, "About", 1);
    }

    private void actionGetInfo(String[] parentPath, List<FSEntry> entries) {
        if (entries.size() != 1) {
            JOptionPane.showMessageDialog(this, "Get info for multiple selections not yet possible.\nPlease select one item at a time.", "Error", 0);
            return;
        }
        FSEntry entry = entries.get(0);
        if (entry instanceof FSFile || entry instanceof FSLink || entry instanceof FSFolder) {
            FileInfoWindow fiw = new FileInfoWindow(entry, parentPath);
            fiw.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "[actionGetInfo()] Record data has unexpected type (" + entry.getClass() + ").\nReport bug to developer.", "Error", 0);
        }
    }

    protected void extract(String[] parentPath, FSEntry rec, File outDir, ExtractProgressMonitor progressDialog, LinkedList<String> errorMessages, boolean followSymbolicLinks) {
        this.extract(parentPath, Arrays.asList(rec), outDir, progressDialog, errorMessages, followSymbolicLinks, FSForkType.DATA);
    }

    protected void extract(String[] parentPath, List<FSEntry> recs, File outDir, ExtractProgressMonitor progressDialog, LinkedList<String> errorMessages, boolean followSymbolicLinks, List<FSForkType> forkTypes) {
        this.extract(parentPath, recs, outDir, progressDialog, errorMessages, followSymbolicLinks, forkTypes.toArray(new FSForkType[forkTypes.size()]));
    }

    protected void extract(String[] parentPath, List<FSEntry> recs, File outDir, ExtractProgressMonitor progressDialog, LinkedList<String> errorMessages, boolean followSymbolicLinks, FSForkType ... forkTypes) {
        if (!outDir.exists()) {
            Object[] options = new String[]{"Create directory", "Cancel"};
            int reply = JOptionPane.showOptionDialog(this, "Warning! Target directory:\n    \"" + outDir.getAbsolutePath() + "\"\n" + "does not exist. Do you want to create this directory?", "Warning", 1, 2, null, options, options[0]);
            if (reply != 0) {
                errorMessages.addLast("Skipping all files in " + outDir.getAbsolutePath() + " as user chose not to create directory.");
                progressDialog.signalCancel();
                return;
            }
            if (!outDir.mkdirs()) {
                JOptionPane.showMessageDialog(this, "Could not create directory:\n    \"" + outDir.getAbsolutePath() + "\"\n", "Error", 0);
                errorMessages.addLast("Could not create directory \"" + outDir.getAbsolutePath() + "\".");
                progressDialog.signalCancel();
                return;
            }
        }
        ExtractVisitor ev = new ExtractVisitor(progressDialog, errorMessages, outDir, forkTypes);
        this.traverseTree(parentPath, recs, ev, followSymbolicLinks);
    }

    /*
     * WARNING - void declaration
     */
    private void extractFile(FSFile rec, File outDir, ExtractProgressMonitor progressDialog, LinkedList<String> errorMessages, ExtractProgressMonitor.ExtractProperties extractProperties, ObjectContainer<Boolean> skipDirectory, FSForkType forkType) {
        String originalFileName;
        if (forkType == FSForkType.DATA) {
            originalFileName = rec.getName();
        } else if (forkType == FSForkType.MACOS_RESOURCE) {
            originalFileName = "._" + rec.getName();
        } else {
            throw new RuntimeException("Unexpected fork type: " + (Object)((Object)forkType));
        }
        ExtractProgressMonitor.CreateFileFailedAction defaultCreateFileFailedAction = extractProperties.getCreateFileFailedAction();
        ExtractProgressMonitor.FileExistsAction defaultFileExistsAction = extractProperties.getFileExistsAction();
        String fileName = originalFileName;
        while (fileName != null) {
            String curFileName = fileName;
            fileName = null;
            FSFork theFork = rec.getForkByType(forkType);
            if (theFork == null) {
                throw new RuntimeException("Could not find a fork of type: " + (Object)((Object)forkType));
            }
            if (forkType == FSForkType.MACOS_RESOURCE && theFork.getLength() == 0L) {
                return;
            }
            progressDialog.updateCurrentFile(curFileName, theFork.getLength());
            File outFile = new File(outDir, curFileName);
            if (defaultFileExistsAction != ExtractProgressMonitor.FileExistsAction.OVERWRITE && outFile.exists()) {
                ExtractProgressMonitor.FileExistsAction a;
                if (defaultFileExistsAction == ExtractProgressMonitor.FileExistsAction.PROMPT_USER) {
                    a = progressDialog.fileExists(outFile);
                } else {
                    a = defaultFileExistsAction;
                    defaultFileExistsAction = ExtractProgressMonitor.FileExistsAction.PROMPT_USER;
                }
                if (a != ExtractProgressMonitor.FileExistsAction.OVERWRITE) {
                    if (a == ExtractProgressMonitor.FileExistsAction.OVERWRITE_ALL) {
                        extractProperties.setFileExistsAction(ExtractProgressMonitor.FileExistsAction.OVERWRITE);
                        defaultFileExistsAction = ExtractProgressMonitor.FileExistsAction.OVERWRITE;
                    } else {
                        if (a == ExtractProgressMonitor.FileExistsAction.SKIP_FILE) {
                            errorMessages.addLast("Skipped extracting file \"" + outFile.getAbsolutePath() + "\" due to user interaction.");
                            break;
                        }
                        if (a == ExtractProgressMonitor.FileExistsAction.SKIP_DIRECTORY) {
                            errorMessages.addLast("Skipping entire directory \"" + outDir.getAbsolutePath() + "\" due to user interaction.");
                            skipDirectory.o = true;
                            break;
                        }
                        if (a == ExtractProgressMonitor.FileExistsAction.RENAME) {
                            fileName = progressDialog.displayRenamePrompt(curFileName, outDir);
                            if (fileName != null) continue;
                            fileName = curFileName;
                            continue;
                        }
                        if (a == ExtractProgressMonitor.FileExistsAction.AUTO_RENAME) {
                            fileName = FileNameTools.autoRenameIllegalFilename(curFileName, outDir, false);
                            if (fileName != null) continue;
                            fileName = curFileName;
                            continue;
                        }
                        if (a == ExtractProgressMonitor.FileExistsAction.CANCEL) {
                            progressDialog.signalCancel();
                            break;
                        }
                        throw new RuntimeException("Internal error! Did not expect a: " + (Object)((Object)a));
                    }
                }
            }
            try {
                try {
                    outFile.getCanonicalPath();
                }
                catch (Exception e) {
                    throw new FileNotFoundException();
                }
                if (!outFile.getParentFile().equals(outDir) || !outFile.getName().equals(curFileName)) {
                    throw new FileNotFoundException();
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                if (forkType == FSForkType.MACOS_RESOURCE) {
                    this.extractResourceForkToAppleDoubleStream(theFork, fos, progressDialog);
                } else {
                    this.extractForkToStream(theFork, fos, progressDialog);
                }
                fos.close();
                if (curFileName == originalFileName || curFileName.equals(originalFileName)) break;
                errorMessages.addLast("File \"" + originalFileName + "\" was renamed to \"" + curFileName + "\" in parent folder \"" + outDir.getAbsolutePath() + "\".");
                break;
            }
            catch (FileNotFoundException fnfe) {
                void var17_21;
                System.out.println("Could not create file \"" + outFile + "\". The following exception was thrown:");
                fnfe.printStackTrace();
                char[] filenameChars = curFileName.toCharArray();
                System.out.println("Filename in hex (" + filenameChars.length + " UTF-16BE units):");
                System.out.print("  0x");
                for (char c : filenameChars) {
                    System.out.print(" " + Util.toHexStringBE((char)c));
                }
                System.out.println();
                if (defaultCreateFileFailedAction == ExtractProgressMonitor.CreateFileFailedAction.PROMPT_USER) {
                    ExtractProgressMonitor.CreateFileFailedAction createFileFailedAction = progressDialog.createFileFailed(curFileName, outDir);
                } else {
                    ExtractProgressMonitor.CreateFileFailedAction createFileFailedAction = defaultCreateFileFailedAction;
                    defaultCreateFileFailedAction = ExtractProgressMonitor.CreateFileFailedAction.PROMPT_USER;
                }
                if (var17_21 == ExtractProgressMonitor.CreateFileFailedAction.SKIP_FILE) {
                    errorMessages.addLast("Skipped extracting file \"" + outFile.getAbsolutePath() + "\" due to user interaction.");
                    break;
                }
                if (var17_21 == ExtractProgressMonitor.CreateFileFailedAction.SKIP_DIRECTORY) {
                    errorMessages.addLast("Skipping entire directory \"" + outDir.getAbsolutePath() + "\" due to user interaction.");
                    skipDirectory.o = true;
                    break;
                }
                if (var17_21 == ExtractProgressMonitor.CreateFileFailedAction.RENAME) {
                    fileName = progressDialog.displayRenamePrompt(curFileName, outDir);
                    if (fileName != null) continue;
                    fileName = curFileName;
                    continue;
                }
                if (var17_21 == ExtractProgressMonitor.CreateFileFailedAction.AUTO_RENAME) {
                    fileName = FileNameTools.autoRenameIllegalFilename(curFileName, outDir, false);
                    if (fileName != null) continue;
                    fileName = curFileName;
                    continue;
                }
                if (var17_21 == ExtractProgressMonitor.CreateFileFailedAction.CANCEL) {
                    progressDialog.signalCancel();
                    break;
                }
                throw new RuntimeException("Internal error! Did not expect a: " + var17_21);
            }
            catch (IOException ioe) {
                System.err.println("Received I/O exception when trying to write to file \"" + outFile + "\":");
                ioe.printStackTrace();
                String msg = ioe.getMessage();
                int n = JOptionPane.showConfirmDialog(this, "Could not write to file \"" + curFileName + "\" under folder:\n  " + outDir.getAbsolutePath() + (msg != null ? "\nSystem message: \"" + msg + "\"" : "") + "\nDo you want to continue?", "I/O Error", 0, 0);
                errorMessages.addLast("Could not write to file \"" + curFileName + "\"");
                if (n != 1) break;
                progressDialog.signalCancel();
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
                String message = "An exception occurred while extracting \"" + curFileName + "\"!";
                message = message + "\n  " + e.toString();
                for (StackTraceElement ste : e.getStackTrace()) {
                    message = message + "\n    " + ste.toString();
                }
                message = message + "\n\nThe file has probably not been extracted.";
                int n = JOptionPane.showConfirmDialog(this, message + "\nDo you want to continue with the extraction?", "Error", 0, 0);
                errorMessages.addLast("An unhandled exception occurred when exctracting file \"" + curFileName + "\". See debug console for more info.");
                if (n != 1) break;
                progressDialog.signalCancel();
                break;
            }
        }
    }

    public static void main(String[] args) {
        FileSystemBrowserWindow fsbWindow;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        int parsedArgs = 0;
        if (args.length > 0 && args[0].equals(DEBUG_CONSOLE_ARG)) {
            DebugConsoleWindow dcw = new DebugConsoleWindow(System.err);
            System.setOut(new PrintStream(dcw.getDebugStream()));
            System.setErr(new PrintStream(dcw.getDebugStream()));
            fsbWindow = new FileSystemBrowserWindow(dcw);
            ++parsedArgs;
        } else {
            fsbWindow = new FileSystemBrowserWindow();
        }
        fsbWindow.setVisible(true);
        if (args.length > parsedArgs) {
            String filename = args[parsedArgs];
            try {
                String pathNameTmp;
                try {
                    pathNameTmp = new File(filename).getCanonicalPath();
                }
                catch (Exception e) {
                    pathNameTmp = filename;
                }
                final String pathName = pathNameTmp;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        fsbWindow.loadFSWithUDIFAutodetect(pathName);
                    }
                });
            }
            catch (Exception ioe) {
                if (ioe.getMessage().equals("Could not open file.")) {
                    JOptionPane.showMessageDialog(fsbWindow, "Failed to open file:\n\"" + filename + "\"", "Error", 0);
                }
                ioe.printStackTrace();
                String msg = "Exception while loading file:\n    \"" + filename + "\"\n" + ioe.toString();
                for (StackTraceElement ste : ioe.getStackTrace()) {
                    msg = msg + "\n" + ste.toString();
                }
                JOptionPane.showMessageDialog(fsbWindow, msg, "Exception while loading file", 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FSEntryRecord
    extends FileSystemBrowser.Record<FSEntry> {
        public FSEntryRecord(FSEntry entry, String[] parentDirPath) {
            super(FSEntryRecord.entryTypeToRecordType(entry, parentDirPath), entry.getName(), FSEntryRecord.getEntrySize(entry, parentDirPath), entry.getAttributes().getModifyDate(), entry);
        }

        public static FileSystemBrowser.RecordType entryTypeToRecordType(FSEntry entry, String[] parentDirPath) {
            if (entry instanceof FSFile) {
                return FileSystemBrowser.RecordType.FILE;
            }
            if (entry instanceof FSFolder) {
                return FileSystemBrowser.RecordType.FOLDER;
            }
            if (entry instanceof FSLink) {
                FSLink fsl = (FSLink)entry;
                FSEntry linkTarget = fsl.getLinkTarget(parentDirPath);
                if (linkTarget == null) {
                    return FileSystemBrowser.RecordType.BROKEN_LINK;
                }
                if (linkTarget instanceof FSFile) {
                    return FileSystemBrowser.RecordType.FILE_LINK;
                }
                if (linkTarget instanceof FSFolder) {
                    return FileSystemBrowser.RecordType.FOLDER_LINK;
                }
                throw new IllegalArgumentException("Unsupported FSEntry link target: " + entry.getClass());
            }
            throw new IllegalArgumentException("Unsupported FSEntry type: " + entry.getClass());
        }

        public static long getEntrySize(FSEntry entry, String[] parentDirPath) {
            if (entry instanceof FSFile) {
                return ((FSFile)entry).getMainFork().getLength();
            }
            if (entry instanceof FSFolder) {
                return 0L;
            }
            if (entry instanceof FSLink) {
                FSLink fsl = (FSLink)entry;
                FSEntry linkTarget = fsl.getLinkTarget(parentDirPath);
                if (linkTarget == null) {
                    return 0L;
                }
                if (linkTarget instanceof FSFile) {
                    return ((FSFile)linkTarget).getMainFork().getLength();
                }
                if (linkTarget instanceof FSFolder) {
                    return 0L;
                }
                throw new IllegalArgumentException("Unsupported FSEntry link target: " + entry.getClass());
            }
            throw new IllegalArgumentException("Unsupported FSEntry type: " + entry.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileSystemProvider
    implements FileSystemBrowser.FileSystemProvider<FSEntry> {
        private FileSystemProvider() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionDoubleClickFile(List<FileSystemBrowser.Record<FSEntry>> recordPath) {
            FileSystemBrowser.Record<FSEntry> record;
            FSEntry entry;
            if (recordPath.size() < 1) {
                throw new IllegalArgumentException("Empty path to file!");
            }
            String[] parentPath = new String[recordPath.size() - 1];
            int i = 0;
            for (FileSystemBrowser.Record<FSEntry> curEntry : recordPath) {
                if (i >= parentPath.length) break;
                parentPath[i++] = curEntry.getUserObject().getName();
            }
            if ((entry = (record = recordPath.get(recordPath.size() - 1)).getUserObject()) instanceof FSFile) {
                FileSystemBrowserWindow.this.actionDoubleClickFile(parentPath, (FSFile)entry);
                return;
            } else {
                if (!(entry instanceof FSLink)) throw new RuntimeException("Unexpected FSEntry type: " + entry.getClass());
                FSLink link = (FSLink)entry;
                FSEntry linkTarget = link.getLinkTarget(parentPath);
                if (linkTarget == null) {
                    JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "The link you clicked is broken.", "Error", 0);
                    return;
                } else {
                    if (!(linkTarget instanceof FSFile)) throw new RuntimeException("Unexpected FSEntry link target: " + entry.getClass());
                    FileSystemBrowserWindow.this.actionDoubleClickFile(parentPath, (FSFile)linkTarget);
                }
            }
        }

        @Override
        public void actionExtractToDir(List<FileSystemBrowser.Record<FSEntry>> parentPathList, List<FileSystemBrowser.Record<FSEntry>> recordList) {
            String[] parentPath = this.getFSPath(parentPathList);
            ArrayList<FSEntry> fsEntryList = new ArrayList<FSEntry>(recordList.size());
            for (FileSystemBrowser.Record<FSEntry> rec : recordList) {
                fsEntryList.add(rec.getUserObject());
            }
            FileSystemBrowserWindow.this.actionExtractToDir(parentPath, fsEntryList, true, false);
        }

        @Override
        public void actionGetInfo(List<FileSystemBrowser.Record<FSEntry>> parentPathList, List<FileSystemBrowser.Record<FSEntry>> recordList) {
            ArrayList<FSEntry> entryList = new ArrayList<FSEntry>(recordList.size());
            for (FileSystemBrowser.Record<FSEntry> rec : recordList) {
                entryList.add(rec.getUserObject());
            }
            FileSystemBrowserWindow.this.actionGetInfo(this.getFSPath(parentPathList), entryList);
        }

        @Override
        public JPopupMenu getRightClickRecordPopupMenu(List<FileSystemBrowser.Record<FSEntry>> parentPathList, List<FileSystemBrowser.Record<FSEntry>> recordList) {
            final String[] parentPath = this.getFSPath(parentPathList);
            final ArrayList<FSEntry> userObjectList = new ArrayList<FSEntry>(recordList.size());
            for (FileSystemBrowser.Record<FSEntry> rec : recordList) {
                userObjectList.add(rec.getUserObject());
            }
            JPopupMenu jpm = new JPopupMenu();
            JMenuItem infoItem = new JMenuItem("Information");
            infoItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileSystemBrowserWindow.this.actionGetInfo(parentPath, userObjectList);
                }
            });
            jpm.add(infoItem);
            JMenuItem dataExtractItem = new JMenuItem("Extract data");
            dataExtractItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileSystemBrowserWindow.this.actionExtractToDir(parentPath, userObjectList, true, false);
                }
            });
            jpm.add(dataExtractItem);
            JMenuItem resExtractItem = new JMenuItem("Extract resource fork(s)");
            resExtractItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileSystemBrowserWindow.this.actionExtractToDir(parentPath, userObjectList, false, true);
                }
            });
            jpm.add(resExtractItem);
            JMenuItem bothExtractItem = new JMenuItem("Extract data and resource fork(s)");
            bothExtractItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileSystemBrowserWindow.this.actionExtractToDir(parentPath, userObjectList, true, true);
                }
            });
            jpm.add(bothExtractItem);
            return jpm;
        }

        @Override
        public boolean isFileSystemLoaded() {
            return FileSystemBrowserWindow.this.fsHandler != null;
        }

        @Override
        public List<FileSystemBrowser.Record<FSEntry>> getFolderContents(List<FileSystemBrowser.Record<FSEntry>> folderRecordPath) {
            FSEntry lastEntry = folderRecordPath.get(folderRecordPath.size() - 1).getUserObject();
            if (lastEntry instanceof FSLink) {
                String[] parentPath = this.getFSPath(folderRecordPath, folderRecordPath.size() - 1);
                FSEntry linkTarget = ((FSLink)lastEntry).getLinkTarget(parentPath);
                if (linkTarget == null) {
                    JOptionPane.showMessageDialog(FileSystemBrowserWindow.this, "The link you clicked is broken.", "Error", 0);
                    throw new RuntimeException("Broken link");
                }
                if (linkTarget instanceof FSFolder) {
                    lastEntry = linkTarget;
                } else {
                    throw new RuntimeException("Tried to get folder contents for link target type " + lastEntry.getClass());
                }
            }
            if (lastEntry instanceof FSFolder) {
                String[] folderPath = this.getFSPath(folderRecordPath);
                FSEntry[] entryArray = ((FSFolder)lastEntry).listEntries();
                ArrayList<FileSystemBrowser.Record<FSEntry>> entryList = new ArrayList<FileSystemBrowser.Record<FSEntry>>(entryArray.length);
                for (FSEntry entry : entryArray) {
                    FSEntryRecord rec = new FSEntryRecord(entry, folderPath);
                    entryList.add(rec);
                }
                return entryList;
            }
            throw new RuntimeException("Tried to get folder contents for type " + lastEntry.getClass());
        }

        @Override
        public String getAddressPath(List<String> pathComponents) {
            StringBuilder sb = new StringBuilder("/");
            for (String name : pathComponents) {
                sb.append(FileSystemBrowserWindow.this.fsHandler.generatePosixPathnameComponent(name));
                sb.append("/");
            }
            return sb.toString();
        }

        @Override
        public String[] parseAddressPath(String targetAddress) {
            if (!targetAddress.startsWith("/")) {
                return null;
            }
            String remainder = targetAddress.substring(1);
            if (remainder.length() == 0) {
                return new String[0];
            }
            String[] res = remainder.split("/");
            for (int i = 0; i < res.length; ++i) {
                res[i] = FileSystemBrowserWindow.this.fsHandler.parsePosixPathnameComponent(res[i]);
            }
            return res;
        }

        private String[] getFSPath(List<FileSystemBrowser.Record<FSEntry>> fsbPathList) {
            if (fsbPathList == null) {
                return null;
            }
            return this.getFSPath(fsbPathList, fsbPathList.size());
        }

        private String[] getFSPath(List<FileSystemBrowser.Record<FSEntry>> fsbPathList, int len) {
            if (len < 1) {
                throw new IllegalArgumentException("A FileSystemBrowser parent path list must have at least one component (the root folder).");
            }
            if (fsbPathList == null) {
                return null;
            }
            String[] res = new String[len - 1];
            Iterator<FileSystemBrowser.Record<FSEntry>> it = fsbPathList.iterator();
            it.next();
            for (int i = 0; i < res.length; ++i) {
                res[i] = it.next().getUserObject().getName();
            }
            while (it.hasNext()) {
                it.next();
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtractVisitor
    extends NullTreeVisitor {
        private final ExtractProgressMonitor pm;
        private final LinkedList<String> errorMessages;
        private final File outRootDir;
        private final ObjectContainer<Boolean> skipDirectory;
        private final ExtractProgressMonitor.ExtractProperties extractProperties;
        private final FSForkType[] forkTypes;
        private final LinkedList<File> outDirStack;

        public ExtractVisitor(ExtractProgressMonitor pm, LinkedList<String> errorMessages, File outDir, List<FSForkType> forkTypes) {
            this(pm, errorMessages, outDir, forkTypes.toArray(new FSForkType[forkTypes.size()]));
        }

        public ExtractVisitor(ExtractProgressMonitor pm, LinkedList<String> errorMessages, File outDir, FSForkType ... forkTypes) {
            this.skipDirectory = new ObjectContainer<Boolean>(false);
            this.outDirStack = new LinkedList();
            this.pm = pm;
            this.errorMessages = errorMessages;
            this.outRootDir = outDir;
            this.forkTypes = forkTypes;
            this.extractProperties = this.pm.getExtractProperties();
            if (this.pm == null) {
                throw new IllegalArgumentException("pm == null");
            }
            if (this.errorMessages == null) {
                throw new IllegalArgumentException("errorMessages == null");
            }
            if (this.outRootDir == null) {
                throw new IllegalArgumentException("outDir == null");
            }
            if (this.forkTypes == null) {
                throw new IllegalArgumentException("forkTypes == null");
            }
            if (forkTypes.length == 0) {
                throw new IllegalArgumentException("No fork types to extract.");
            }
            this.outDirStack.addLast(outDir);
        }

        @Override
        public boolean startDirectory(String[] parentPath, FSFolder folder) {
            String originalDirName;
            File outDir = this.outDirStack.getLast();
            ExtractProgressMonitor.CreateDirectoryFailedAction originalCreateDirectoryFailedAction = this.extractProperties.getCreateDirectoryFailedAction();
            ExtractProgressMonitor.DirectoryExistsAction originalDirectoryExistsAction = this.extractProperties.getDirectoryExistsAction();
            ExtractProgressMonitor.CreateDirectoryFailedAction defaultCreateDirectoryFailedAction = originalCreateDirectoryFailedAction;
            ExtractProgressMonitor.DirectoryExistsAction defaultDirectoryExistsAction = originalDirectoryExistsAction;
            String dirName = originalDirName = folder.getName();
            block13: while (dirName != null) {
                Enum a;
                String curDirName = dirName;
                dirName = null;
                this.pm.updateCurrentDir(curDirName);
                File thisDir = new File(outDir, curDirName);
                if (defaultDirectoryExistsAction != ExtractProgressMonitor.DirectoryExistsAction.CONTINUE && thisDir.exists()) {
                    a = defaultDirectoryExistsAction == ExtractProgressMonitor.DirectoryExistsAction.PROMPT_USER ? this.pm.directoryExists(thisDir) : defaultDirectoryExistsAction;
                    boolean resetLoop = false;
                    switch (22.$SwitchMap$org$catacombae$hfsexplorer$ExtractProgressMonitor$DirectoryExistsAction[a.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            dirName = this.pm.displayRenamePrompt(curDirName, outDir);
                            if (dirName == null) {
                                dirName = curDirName;
                            }
                            resetLoop = true;
                            break;
                        }
                        case 3: {
                            dirName = FileNameTools.autoRenameIllegalFilename(curDirName, outDir, true);
                            if (dirName == null) {
                                dirName = curDirName;
                            }
                            resetLoop = true;
                            break;
                        }
                        case 4: {
                            resetLoop = true;
                            break;
                        }
                        case 5: {
                            resetLoop = true;
                            this.pm.signalCancel();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Internal error! Did not expect a: " + a);
                        }
                    }
                    if (resetLoop) continue;
                }
                if (thisDir.mkdir() || thisDir.exists()) {
                    if (curDirName != originalDirName && !curDirName.equals(originalDirName)) {
                        this.errorMessages.addLast("Directory \"" + originalDirName + "\" was renamed to \"" + curDirName + "\" in parent folder \"" + outDir.getAbsolutePath() + "\".");
                    }
                    this.outDirStack.addLast(thisDir);
                    return true;
                }
                if (defaultCreateDirectoryFailedAction == ExtractProgressMonitor.CreateDirectoryFailedAction.PROMPT_USER) {
                    a = this.pm.createDirectoryFailed(curDirName, outDir);
                } else {
                    a = defaultCreateDirectoryFailedAction;
                    defaultCreateDirectoryFailedAction = ExtractProgressMonitor.CreateDirectoryFailedAction.PROMPT_USER;
                }
                switch (22.$SwitchMap$org$catacombae$hfsexplorer$ExtractProgressMonitor$CreateDirectoryFailedAction[a.ordinal()]) {
                    case 1: {
                        this.errorMessages.addLast("Could not create directory \"" + thisDir.getAbsolutePath() + "\". All files under this directory will be skipped.");
                        continue block13;
                    }
                    case 2: {
                        dirName = this.pm.displayRenamePrompt(curDirName, outDir);
                        if (dirName != null) continue block13;
                        dirName = curDirName;
                        continue block13;
                    }
                    case 3: {
                        dirName = FileNameTools.autoRenameIllegalFilename(curDirName, outDir, true);
                        if (dirName != null) continue block13;
                        dirName = curDirName;
                        continue block13;
                    }
                    case 4: {
                        this.pm.signalCancel();
                        continue block13;
                    }
                }
                throw new RuntimeException("Internal error! Did not expect a: " + a);
            }
            return false;
        }

        @Override
        public void endDirectory(String[] parentPath, FSFolder folder) {
            this.outDirStack.removeLast();
            this.skipDirectory.o = false;
        }

        @Override
        public void file(FSFile fsf) {
            if (((Boolean)this.skipDirectory.o).booleanValue()) {
                return;
            }
            File outDir = this.outDirStack.getLast();
            for (FSForkType forkType : this.forkTypes) {
                FileSystemBrowserWindow.this.extractFile(fsf, outDir, this.pm, this.errorMessages, this.extractProperties, this.skipDirectory, forkType);
            }
        }

        @Override
        public void link(FSLink fsl) {
        }

        @Override
        public void traversalError(String message) {
            this.errorMessages.addLast(message);
        }

        @Override
        public boolean cancelTraversal() {
            return this.pm.cancelSignaled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CalculateTreeSizeVisitor
    extends NullTreeVisitor {
        private final ExtractProgressMonitor pm;
        private final StringBuilder sb;
        private final FSForkType[] forkTypes;
        private long size;

        public CalculateTreeSizeVisitor(ExtractProgressMonitor pm, List<FSForkType> forkTypes) {
            this(pm, forkTypes.toArray(new FSForkType[forkTypes.size()]));
        }

        public CalculateTreeSizeVisitor(ExtractProgressMonitor pm, FSForkType ... forkTypes) {
            this.sb = new StringBuilder();
            this.size = 0L;
            this.pm = pm;
            this.forkTypes = forkTypes;
            if (this.pm == null) {
                throw new IllegalArgumentException("pm == null");
            }
            if (this.forkTypes == null) {
                throw new IllegalArgumentException("forkTypes == null");
            }
            if (forkTypes.length == 0) {
                throw new IllegalArgumentException("No fork types to extract.");
            }
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public boolean startDirectory(String[] parentPath, FSFolder folder) {
            this.sb.setLength(0);
            for (String s : parentPath) {
                this.sb.append(s).append("/");
            }
            this.sb.append(folder.getName());
            this.pm.updateCalculateDir(this.sb.toString());
            return true;
        }

        @Override
        public void file(FSFile file) {
            for (FSForkType forkType : this.forkTypes) {
                FSFork fork = file.getForkByType(forkType);
                if (fork == null) continue;
                this.size += fork.getLength();
            }
        }

        @Override
        public boolean cancelTraversal() {
            return this.pm.cancelSignaled();
        }
    }

    public class NullTreeVisitor
    implements TreeVisitor {
        public boolean startDirectory(String[] parentPath, FSFolder folder) {
            return true;
        }

        public void endDirectory(String[] parentPath, FSFolder folder) {
        }

        public void file(FSFile fsf) {
        }

        public void link(FSLink fsl) {
        }

        public void traversalError(String message) {
        }

        public boolean cancelTraversal() {
            return false;
        }
    }

    public static interface TreeVisitor {
        public boolean startDirectory(String[] var1, FSFolder var2);

        public void endDirectory(String[] var1, FSFolder var2);

        public void file(FSFile var1);

        public void link(FSLink var1);

        public void traversalError(String var1);

        public boolean cancelTraversal();
    }
}

