/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.types.hfs.CatKeyRec;
import org.catacombae.hfsexplorer.types.hfs.CdrDirRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFolder;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;

public abstract class CommonHFSCatalogFolderRecord
extends CommonHFSCatalogLeafRecord {
    protected final CommonHFSCatalogKey key;
    protected final CommonHFSCatalogFolder data;

    protected CommonHFSCatalogFolderRecord(CommonHFSCatalogKey key, CommonHFSCatalogFolder data) {
        this.key = key;
        this.data = data;
    }

    public CommonHFSCatalogKey getKey() {
        return this.key;
    }

    public CommonHFSCatalogFolder getData() {
        return this.data;
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFolderRecord.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + "key:");
        this.getKey().print(ps, prefix + " ");
        ps.println(prefix + "data:");
        this.getData().print(ps, prefix + " ");
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CommonHFSCatalogFolderRecord.class.getSimpleName(), "Folder record");
        db.add("key", this.key.getStructElements(), "Catalog key");
        db.add("data", this.data.getStructElements(), "Folder data");
        return db.getResult();
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.getSize()];
        int offset = 0;
        byte[] tempData = this.key.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.data.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        return result;
    }

    public static CommonHFSCatalogFolderRecord create(HFSPlusCatalogKey key, HFSPlusCatalogFolder data) {
        return new HFSPlusImplementation(key, data);
    }

    public static CommonHFSCatalogFolderRecord create(CatKeyRec key, CdrDirRec data) {
        return new HFSImplementation(key, data);
    }

    public static class HFSImplementation
    extends CommonHFSCatalogFolderRecord {
        public HFSImplementation(CatKeyRec key, CdrDirRec data) {
            super(CommonHFSCatalogKey.create(key), CommonHFSCatalogFolder.create(data));
        }

        public int getSize() {
            return this.key.occupiedSize() + this.data.length();
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSCatalogFolderRecord {
        public HFSPlusImplementation(HFSPlusCatalogKey key, HFSPlusCatalogFolder data) {
            super(CommonHFSCatalogKey.create(key), CommonHFSCatalogFolder.create(data));
        }

        public int getSize() {
            return this.key.occupiedSize() + this.data.length();
        }
    }
}

