/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import java.util.Iterator;

public class CellAssignmentCache {
    private GridView m_view;
    private CellAssignment[][] m_grid;

    public CellAssignmentCache(GridView gridView) {
        this.m_view = gridView;
    }

    void addComponent(GridComponent gridComponent) {
        this.checkGrid();
        if (gridComponent == null) {
            FormUtils.safeAssert(false);
            return;
        }
        CellAssignment cellAssignment = this.m_grid[gridComponent.getRow() - 1][gridComponent.getColumn() - 1];
        if (cellAssignment == null) {
            cellAssignment = new CellAssignment();
            cellAssignment.m_comp = gridComponent;
            this.m_grid[gridComponent.getRow() - 1][gridComponent.getColumn() - 1] = cellAssignment;
        } else {
            cellAssignment.m_comp = gridComponent;
        }
        int n = gridComponent.getRow();
        int n2 = gridComponent.getColumn();
        int n3 = gridComponent.getRowSpan();
        int n4 = gridComponent.getColumnSpan();
        if (n3 > 1 || n4 > 1) {
            for (int i = n; i <= n + n3 - 1; ++i) {
                for (int j = n2; j <= n2 + n4 - 1; ++j) {
                    if (i == n && j == n2) continue;
                    CellAssignment cellAssignment2 = this.m_grid[i - 1][j - 1];
                    if (cellAssignment2 == null) {
                        this.m_grid[i - 1][j - 1] = cellAssignment2 = new CellAssignment();
                    }
                    cellAssignment2.m_overlap = gridComponent;
                }
            }
        }
    }

    private void checkGrid() {
        int n = this.m_view.getColumnCount();
        int n2 = this.m_view.getRowCount();
        if (this.m_grid == null || this.m_grid[0].length != n || this.m_grid.length != n2) {
            this.resync();
        }
    }

    public GridComponent getGridComponent(int n, int n2) {
        this.checkGrid();
        try {
            CellAssignment cellAssignment = this.m_grid[n2 - 1][n - 1];
            if (cellAssignment == null) {
                return null;
            }
            return cellAssignment.m_comp;
        }
        catch (Exception exception) {
            this.resync();
            return null;
        }
    }

    public GridComponent getOverlappingComponent(int n, int n2) {
        this.checkGrid();
        CellAssignment cellAssignment = this.m_grid[n2 - 1][n - 1];
        FormUtils.safeAssert(cellAssignment != null);
        FormUtils.safeAssert(cellAssignment.m_comp.getRow() == n2);
        FormUtils.safeAssert(cellAssignment.m_comp.getColumn() == n);
        if (cellAssignment != null) {
            return cellAssignment.m_overlap;
        }
        return null;
    }

    void sync() {
        this.m_grid = null;
    }

    private void resync() {
        int n = this.m_view.getColumnCount();
        int n2 = this.m_view.getRowCount();
        if (this.m_grid == null || this.m_grid[0].length != n || this.m_grid.length != n2) {
            this.m_grid = new CellAssignment[n2][n];
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.m_grid[i][j] = null;
                }
            }
        }
        Iterator iterator = this.m_view.gridIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof GridComponent)) continue;
            GridComponent gridComponent = (GridComponent)e;
            if (gridComponent.getColumn() > n || gridComponent.getRow() > n2) {
                FormUtils.safeAssert(false);
            }
            this.addComponent(gridComponent);
        }
    }

    private static class CellAssignment {
        GridComponent m_comp;
        GridComponent m_overlap;

        private CellAssignment() {
        }
    }
}

