/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.Date;

public class DateField {
    private static final int DATE_LEN = Long.toString(94608000000000L, 36).length();
    private static final long DATE_SHIFT = 63072000000000L;
    public static final String MIN_DATE_STRING = DateField.timeToString(-63072000000000L);
    public static final String MAX_DATE_STRING;

    private DateField() {
    }

    public static String dateToString(Date date) {
        return DateField.timeToString(date.getTime());
    }

    public static String timeToString(long time) {
        if ((time += 63072000000000L) < 0L) {
            throw new IllegalArgumentException("time too early");
        }
        String s = Long.toString(time, 36);
        if (s.length() > DATE_LEN) {
            throw new IllegalArgumentException("time too late");
        }
        if (s.length() < DATE_LEN) {
            StringBuffer sb = new StringBuffer(s);
            while (sb.length() < DATE_LEN) {
                sb.insert(0, 0);
            }
            s = sb.toString();
        }
        return s;
    }

    public static long stringToTime(String s) {
        return Long.parseLong(s, 36) - 63072000000000L;
    }

    public static Date stringToDate(String s) {
        return new Date(DateField.stringToTime(s));
    }

    static {
        char[] buffer = new char[DATE_LEN];
        char c = Character.forDigit(35, 36);
        for (int i = 0; i < DATE_LEN; ++i) {
            buffer[i] = c;
        }
        MAX_DATE_STRING = new String(buffer);
    }
}

