/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;

public class RemoveStackDepthChangeCommand
implements Command {
    private Program program;
    private Address address;

    public RemoveStackDepthChangeCommand(Program program, Address address) {
        this.program = program;
        this.address = address;
    }

    public boolean applyTo(DomainObject obj) {
        return CallDepthChangeInfo.removeStackDepthChange(this.program, this.address);
    }

    public String getName() {
        return "Remove Stack Depth Change";
    }

    public String getStatusMsg() {
        return null;
    }
}

