/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import ghidra.app.merge.MergeConstants;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.TypeDef;
import ghidra.util.UniversalID;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class DataTypePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public Color SOURCE_COLOR = new Color(0, 140, 0);
    private DataType dataType;
    private JTextPane textPane;
    private StyledDocument doc;
    private SimpleAttributeSet pathAttrSet;
    private SimpleAttributeSet nameAttrSet;
    private SimpleAttributeSet sourceAttrSet;
    private SimpleAttributeSet contentAttrSet;
    private SimpleAttributeSet fieldNameAttrSet;
    private SimpleAttributeSet commentAttrSet;
    private SimpleAttributeSet deletedAttrSet;

    DataTypePanel(DataType dataType) {
        super(new BorderLayout());
        this.dataType = dataType;
        this.create();
    }

    void setDataType(DataType dataType) {
        this.dataType = dataType;
        this.textPane.setText("");
        if (dataType instanceof Composite) {
            this.formatCompositeText((Composite)dataType);
        } else if (dataType instanceof Enum) {
            this.formatEnumText((Enum)dataType);
        } else if (dataType instanceof TypeDef) {
            this.formatTypeDefText((TypeDef)dataType);
        } else if (dataType instanceof FunctionDefinition) {
            this.formatFunctionDef((FunctionDefinition)dataType);
        } else {
            this.formatDataType(dataType);
        }
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.doc = this.textPane.getStyledDocument();
        this.add((Component)this.textPane, "Center");
        this.textPane.setEditable(false);
        this.pathAttrSet = new SimpleAttributeSet();
        this.pathAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.pathAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        this.pathAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.pathAttrSet.addAttribute(StyleConstants.Foreground, MergeConstants.CONFLICT_COLOR);
        this.nameAttrSet = new SimpleAttributeSet();
        this.nameAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.nameAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        this.nameAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.sourceAttrSet = new SimpleAttributeSet();
        this.sourceAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.sourceAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        this.sourceAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.sourceAttrSet.addAttribute(StyleConstants.Foreground, this.SOURCE_COLOR);
        this.contentAttrSet = new SimpleAttributeSet();
        this.contentAttrSet.addAttribute(StyleConstants.FontFamily, "Monospaced");
        this.contentAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.contentAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        this.fieldNameAttrSet = new SimpleAttributeSet();
        this.fieldNameAttrSet.addAttribute(StyleConstants.FontFamily, "Monospaced");
        this.fieldNameAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.fieldNameAttrSet.addAttribute(StyleConstants.Foreground, new Color(204, 0, 204));
        this.commentAttrSet = new SimpleAttributeSet();
        this.commentAttrSet.addAttribute(StyleConstants.FontFamily, "Monospaced");
        this.commentAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.commentAttrSet.addAttribute(StyleConstants.Foreground, new Color(0, 204, 51));
        this.deletedAttrSet = new SimpleAttributeSet();
        this.deletedAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.deletedAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.deletedAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.deletedAttrSet.addAttribute(StyleConstants.Foreground, Color.RED);
        this.setDataType(this.dataType);
    }

    private void formatPath(DataType dt) {
        this.insertString("Path: " + dt.getCategoryPath() + "\n\n", this.pathAttrSet);
    }

    private void formatSourceArchive(DataType dt) {
        this.insertString("Source Archive: " + this.getSourceArchiveName(dt) + "\n", this.sourceAttrSet);
    }

    private String getSourceArchiveName(DataType dt) {
        UniversalID sourceID;
        SourceArchive sourceArchive = dt.getSourceArchive();
        UniversalID universalID = sourceID = sourceArchive != null ? sourceArchive.getSourceArchiveID() : null;
        if (sourceID == null) {
            return "Local";
        }
        return sourceArchive.getName();
    }

    private void formatAlignment(Composite composite) {
        long packingValue;
        StringBuffer alignmentBuffer = new StringBuffer();
        if (!composite.isInternallyAligned()) {
            alignmentBuffer.append("Unaligned");
        } else if (composite.isDefaultAligned()) {
            alignmentBuffer.append("Aligned");
        } else if (composite.isMachineAligned()) {
            alignmentBuffer.append("Machine aligned");
        } else {
            long alignment = composite.getMinimumAlignment();
            alignmentBuffer.append("align(" + alignment + ")");
        }
        if (composite.isInternallyAligned() && (packingValue = (long)composite.getPackingValue()) != 0L) {
            alignmentBuffer.append(" pack(" + packingValue + ")");
        }
        this.insertString(alignmentBuffer.toString() + "\n\n", this.sourceAttrSet);
    }

    private void formatCompositeText(Composite comp) {
        int i;
        this.formatSourceArchive((DataType)comp);
        this.formatPath((DataType)comp);
        this.formatAlignment(comp);
        this.insertString(comp.getDisplayName(), this.nameAttrSet);
        this.insertString(" { \n", this.contentAttrSet);
        DataTypeComponent[] components = comp.getComponents();
        int maxLength = 0;
        int maxFieldNameLength = 0;
        for (i = 0; i < components.length; ++i) {
            String fieldName;
            String name = components[i].getDataType().getDisplayName();
            if (name.length() > maxLength) {
                maxLength = name.length();
            }
            if ((fieldName = components[i].getFieldName()) == null) {
                fieldName = " ";
            }
            if (fieldName.length() <= maxFieldNameLength) continue;
            maxFieldNameLength = fieldName.length();
        }
        for (i = 0; i < components.length; ++i) {
            String comment;
            String fieldName = components[i].getFieldName();
            if (fieldName == null) {
                fieldName = "";
            }
            if ((comment = components[i].getComment()) == null) {
                comment = "";
            }
            fieldName = this.pad(fieldName, maxFieldNameLength);
            String typeName = this.pad(components[i].getDataType().getDisplayName(), maxLength);
            this.insertString("    " + typeName + "  ", this.contentAttrSet);
            this.insertString(fieldName + "   ", this.fieldNameAttrSet);
            this.insertString(comment, this.commentAttrSet);
            if (i >= components.length - 1) continue;
            this.insertString("\n", this.contentAttrSet);
        }
        this.insertString("\n }\n", this.contentAttrSet);
    }

    private void formatEnumText(Enum enuum) {
        this.formatSourceArchive((DataType)enuum);
        this.formatPath((DataType)enuum);
        this.insertString(enuum.getDisplayName(), this.nameAttrSet);
        this.insertString(" { \n", this.contentAttrSet);
        StringBuffer sb = new StringBuffer();
        String[] names = enuum.getNames();
        int maxLength = 0;
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= maxLength) continue;
            maxLength = names[i].length();
        }
        long[] values = enuum.getValues();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            String name = enuum.getName(values[i]);
            name = this.pad(name, maxLength);
            sb.append("    " + name + " = 0x" + Long.toHexString(values[i]) + " ");
            if (i >= values.length - 1) continue;
            sb.append("\n");
        }
        sb.append("\n }\n");
        this.insertString(sb.toString(), this.contentAttrSet);
    }

    private void formatTypeDefText(TypeDef td) {
        this.formatSourceArchive((DataType)td);
        this.formatPath((DataType)td);
        this.insertString(td.getDisplayName(), this.nameAttrSet);
        this.insertString("\n", this.contentAttrSet);
        this.insertString("     TypeDef on " + td.getDataType().getDisplayName(), this.contentAttrSet);
    }

    private void formatFunctionDef(FunctionDefinition fd) {
        this.formatSourceArchive((DataType)fd);
        this.formatPath((DataType)fd);
        ParameterDefinition[] vars = fd.getArguments();
        DataType returnType = fd.getReturnType();
        this.insertString(returnType.getDisplayName(), this.contentAttrSet);
        this.insertString("  " + fd.getDisplayName(), this.nameAttrSet);
        this.insertString(" (", this.contentAttrSet);
        boolean hasVarArgs = fd.hasVarArgs();
        if (vars.length == 0 && !hasVarArgs) {
            this.insertString(")", this.contentAttrSet);
            return;
        }
        int maxLength = 0;
        for (int i = 0; i < vars.length; ++i) {
            String typeName = vars[i].getDataType().getDisplayName();
            if (typeName.length() <= maxLength) continue;
            maxLength = typeName.length();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vars.length; ++i) {
            sb.append("\n");
            String name = vars[i].getDataType().getDisplayName();
            name = this.pad(name, maxLength);
            sb.append("    " + name + " " + vars[i].getName());
            if (i >= vars.length - 1 && (vars.length <= 0 || !hasVarArgs)) continue;
            sb.append(",");
        }
        if (hasVarArgs) {
            if (vars.length > 0) {
                sb.append("\n").append("    ");
            }
            sb.append("...");
        }
        sb.append(")");
        this.insertString(sb.toString(), this.contentAttrSet);
    }

    private void formatDataType(DataType dt) {
        if (dt == null) {
            this.insertString("\n\nDeleted", this.deletedAttrSet);
            return;
        }
        this.formatSourceArchive(dt);
        this.formatPath(dt);
        this.insertString(dt.getDisplayName(), this.nameAttrSet);
    }

    private String pad(String str, int length) {
        StringBuffer sb = new StringBuffer(str);
        int len = length - str.length();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void insertString(String str, SimpleAttributeSet attrSet) {
        int offset = this.doc.getLength();
        try {
            this.doc.insertString(offset, str, attrSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

