/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.codebrowser.actions.CodeViewerContextAction;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.app.plugin.core.navigation.NextPreviousBookmarkAction;
import ghidra.app.plugin.core.navigation.NextPreviousDefinedDataAction;
import ghidra.app.plugin.core.navigation.NextPreviousDifferentByteAction;
import ghidra.app.plugin.core.navigation.NextPreviousFunctionAction;
import ghidra.app.plugin.core.navigation.NextPreviousInstructionAction;
import ghidra.app.plugin.core.navigation.NextPreviousLabelAction;
import ghidra.app.plugin.core.navigation.NextPreviousMarkerAction;
import ghidra.app.plugin.core.navigation.NextPreviousNonFunctionAction;
import ghidra.app.plugin.core.navigation.NextPreviousUndefinedAction;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Navigation", shortDescription="Go To Next/Previous Code Unit", description="This plugin moves the current location to the next or previous instruction, defined data, or undefined data in the program.", servicesRequired={GoToService.class})
public class NextPrevCodeUnitPlugin
extends Plugin {
    private DockingAction toggleDirectionAction;
    private AbstractNextPreviousAction instructionAction;
    private AbstractNextPreviousAction dataAction;
    private AbstractNextPreviousAction undefinedAction;
    private AbstractNextPreviousAction functionAction;
    private AbstractNextPreviousAction nonFunctionAction;
    private AbstractNextPreviousAction labelAction;
    private NextPreviousBookmarkAction bookmarkAction;
    private NextPreviousMarkerAction markerAction;
    private NextPreviousDifferentByteAction differentValueAction;

    public NextPrevCodeUnitPlugin(PluginTool pluginTool) {
        super(pluginTool);
        this.createActions();
    }

    private void createActions() {
        int subGroupIndex = 0;
        this.toggleDirectionAction = new ToggleDirectionAction("" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.toggleDirectionAction);
        this.instructionAction = new NextPreviousInstructionAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.instructionAction);
        this.dataAction = new NextPreviousDefinedDataAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.dataAction);
        this.undefinedAction = new NextPreviousUndefinedAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.undefinedAction);
        this.labelAction = new NextPreviousLabelAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.labelAction);
        this.functionAction = new NextPreviousFunctionAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.functionAction);
        this.nonFunctionAction = new NextPreviousNonFunctionAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.nonFunctionAction);
        this.differentValueAction = new NextPreviousDifferentByteAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.differentValueAction);
        this.bookmarkAction = new NextPreviousBookmarkAction(this.tool, this.getName(), "" + subGroupIndex++);
        this.tool.addAction((DockingActionIf)this.bookmarkAction);
    }

    private void updateActions(boolean searchForward) {
        this.instructionAction.setDirection(searchForward);
        this.dataAction.setDirection(searchForward);
        this.undefinedAction.setDirection(searchForward);
        this.functionAction.setDirection(searchForward);
        this.nonFunctionAction.setDirection(searchForward);
        this.labelAction.setDirection(searchForward);
        this.differentValueAction.setDirection(searchForward);
        this.bookmarkAction.setDirection(searchForward);
    }

    private class ToggleDirectionAction
    extends CodeViewerContextAction {
        Icon forwardIcon;
        Icon backwardIcon;
        private boolean isForward;

        ToggleDirectionAction(String subGroup) {
            super("Toggle Code Unit Search Direction", NextPrevCodeUnitPlugin.this.getName());
            this.forwardIcon = ResourceManager.loadImage((String)"images/down.png");
            this.backwardIcon = ResourceManager.loadImage((String)"images/up.png");
            this.isForward = true;
            MenuData menuData = new MenuData(new String[]{"&Navigation", this.getName()}, this.forwardIcon, "NextPrevCodeUnit");
            menuData.setMenuSubGroup(subGroup);
            this.setMenuBarData(menuData);
            this.setToolBarData(new ToolBarData(this.forwardIcon, "NextPrevCodeUnit", subGroup));
            this.setKeyBindingData(new KeyBindingData(84, 640));
            this.setHelpLocation(new HelpLocation("Navigation", this.getName()));
            this.setDescription("Toggle Code Unit Search Direction");
        }

        @Override
        public void actionPerformed(CodeViewerActionContext context) {
            this.isForward = !this.isForward;
            this.getMenuBarData().setIcon(this.isForward ? this.forwardIcon : this.backwardIcon);
            this.getToolBarData().setIcon(this.isForward ? this.forwardIcon : this.backwardIcon);
            NextPrevCodeUnitPlugin.this.updateActions(this.isForward);
        }
    }
}

