/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.MemorySearchAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.task.TaskMonitor;

public class MemSearchTableModel
extends AddressBasedTableModel<MemSearchResult> {
    private SearchInfo searchInfo;
    private ProgramSelection selection;
    private Address startAddress;
    private MemorySearchAlgorithm algorithm;
    private int selectionSize = 1;

    MemSearchTableModel(ServiceProvider serviceProvider, int selectionSize, Program program, SearchInfo searchInfo, Address searchStartAddress, ProgramSelection programSelection) {
        super("Memory Search", serviceProvider, program, null, true);
        this.searchInfo = searchInfo;
        this.startAddress = searchStartAddress;
        this.selection = programSelection;
        this.selectionSize = selectionSize;
    }

    protected void doLoad(Accumulator<MemSearchResult> accumulator, TaskMonitor monitor) throws CancelledException {
        this.algorithm = this.searchInfo.createSearchAlgorithm(this.getProgram(), this.startAddress, this.selection);
        this.algorithm.search(accumulator, monitor);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        Program p = this.getProgram();
        if (p == null) {
            return null;
        }
        ProgramLocation loc = super.getProgramLocation(row, column);
        if (loc != null && p.getMemory().contains(loc.getByteAddress())) {
            return new BytesFieldLocation(p, loc.getByteAddress());
        }
        return null;
    }

    @Override
    public Address getAddress(int row) {
        MemSearchResult result = (MemSearchResult)this.getRowObject(row);
        return result.getAddress();
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        if (this.selectionSize == 1) {
            return super.getProgramSelection(rows);
        }
        int addOn = this.selectionSize - 1;
        AddressSet addressSet = new AddressSet();
        for (int element : rows) {
            Address minAddr;
            Address maxAddr = minAddr = this.getAddress(element);
            try {
                maxAddr = minAddr.addNoWrap((long)addOn);
                addressSet.addRange(minAddr, maxAddr);
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }
}

