/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledAddressTable;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledMethod;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledString;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.DemangledVariable;
import util.demangler.GenericDemangledAddressTable;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledFunction;
import util.demangler.GenericDemangledFunctionPointer;
import util.demangler.GenericDemangledMethod;
import util.demangler.GenericDemangledObject;
import util.demangler.GenericDemangledString;
import util.demangler.GenericDemangledType;
import util.demangler.GenericDemangledVariable;

public class DemangledObjectFactory {
    private DemangledObjectFactory() {
    }

    public static DemangledObject convert(GenericDemangledObject generic) throws DemangledException {
        if (generic instanceof GenericDemangledVariable) {
            return new DemangledVariable((GenericDemangledVariable)generic);
        }
        if (generic instanceof GenericDemangledString) {
            return new DemangledString((GenericDemangledString)generic);
        }
        if (generic instanceof GenericDemangledMethod) {
            return new DemangledMethod((GenericDemangledMethod)generic);
        }
        if (generic instanceof GenericDemangledFunction) {
            return new DemangledFunction((GenericDemangledFunction)generic);
        }
        if (generic instanceof GenericDemangledAddressTable) {
            return new DemangledAddressTable((GenericDemangledAddressTable)generic);
        }
        throw new DemangledException("Unknown GenericDemangledObject: " + generic.getClass());
    }

    public static DemangledType convert(GenericDemangledType generic) {
        if (generic instanceof GenericDemangledFunctionPointer) {
            return new DemangledFunctionPointer((GenericDemangledFunctionPointer)generic);
        }
        if (generic instanceof GenericDemangledDataType) {
            return new DemangledDataType((GenericDemangledDataType)generic);
        }
        return new DemangledType(generic);
    }
}

