/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressPreviewTableModel;
import ghidra.util.task.TaskMonitor;

public class AddressSetTableModel
extends AddressPreviewTableModel {
    private AddressSetView addressSet;

    public AddressSetTableModel(String title, ServiceProvider serviceProvider, Program prog, AddressSetView addressSet, TaskMonitor monitor) {
        super(title, serviceProvider, prog, monitor);
        this.addressSet = addressSet;
    }

    protected void doLoad(Accumulator<Address> accumulator, TaskMonitor monitor) throws CancelledException {
        monitor.initialize(this.addressSet.getNumAddresses());
        AddressIterator iterator = this.addressSet.getAddresses(true);
        for (Address address : iterator) {
            monitor.checkCanceled();
            accumulator.add((Object)address);
            monitor.incrementProgress(1L);
        }
    }
}

