/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import javax.annotation.Nullable;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.AbstractArraySnapshot;
import org.gradle.internal.snapshot.impl.ArrayValueSnapshot;

public class IsolatedArray
extends AbstractArraySnapshot<Isolatable<?>>
implements Isolatable<Object[]> {
    public static final IsolatedArray EMPTY = IsolatedArray.empty(Object.class);
    private final Class<?> arrayType;

    public IsolatedArray(ImmutableList<Isolatable<?>> elements, Class<?> arrayType) {
        super(elements);
        this.arrayType = arrayType;
    }

    public ValueSnapshot asSnapshot() {
        if (this.elements.isEmpty()) {
            return ArrayValueSnapshot.EMPTY;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.elements.size());
        for (Isolatable element : this.elements) {
            builder.add((Object)element.asSnapshot());
        }
        return new ArrayValueSnapshot((ImmutableList<ValueSnapshot>)builder.build());
    }

    public Object[] isolate() {
        Object[] toReturn = (Object[])Array.newInstance(this.arrayType, this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            Isolatable element = (Isolatable)this.elements.get(i);
            toReturn[i] = element.isolate();
        }
        return toReturn;
    }

    @Nullable
    public <S> S coerce(Class<S> type) {
        return null;
    }

    public Class<?> getArrayType() {
        return this.arrayType;
    }

    public static IsolatedArray empty(Class<?> arrayType) {
        return new IsolatedArray(ImmutableList.of(), arrayType);
    }
}

