/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.runtime.ThreadContext;

public class UnboxedFixnum
extends ImmutableLiteral {
    public final long value;

    public UnboxedFixnum(long val) {
        this.value = val;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.UNBOXED_FIXNUM;
    }

    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newFixnum(this.value);
    }

    public int hashCode() {
        return 329 + (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object other) {
        return other instanceof UnboxedFixnum && this.value == ((UnboxedFixnum)other).value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnboxedFixnum(this);
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return "UnboxedFixnum:" + this.value;
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

