/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security;

import com.ca.commons.security.JXTrustManager;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class JXSSLSocketFactory
extends SSLSocketFactory {
    private static SSLSocketFactory factory = null;
    private static JXSSLSocketFactory default_factory = null;
    private static KeyStore clientKeystore;
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static ClassLoader myClassLoader;

    public static void setClassLoader(ClassLoader newLoader) {
        myClassLoader = newLoader;
    }

    private static ClassLoader getClassLoader() {
        if (myClassLoader == null) {
            myClassLoader = ClassLoader.getSystemClassLoader();
        }
        return myClassLoader;
    }

    public static void setDebug(boolean status) {
        if (status) {
            System.setProperty("javax.net.debug", "ssl,handshake,verbose");
        } else {
            System.setProperty("javax.net.debug", " ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String caKeystoreFile, String clientKeystoreFile, char[] caPassphrase, char[] clientPassphrase, String caKeystoreType, String clientKeystoreType, Frame owner) throws GeneralSecurityException, IOException {
        boolean usingSASL = false;
        JXSSLSocketFactory.checkFileSanity(caKeystoreFile, clientKeystoreFile, clientPassphrase);
        if (clientPassphrase != null && clientPassphrase.length > 0 && clientKeystoreFile != null) {
            usingSASL = true;
        }
        if (caKeystoreFile == null && clientKeystoreFile != null) {
            caKeystoreFile = clientKeystoreFile;
        }
        if (caKeystoreType == null) {
            caKeystoreType = DEFAULT_KEYSTORE_TYPE;
        }
        SSLContext sslctx = JXSSLSocketFactory.setSSLContextProtocol();
        KeyManagerFactory clientKeyManagerFactory = null;
        TrustManagerFactory caTrustManagerFactory = null;
        KeyStore caKeystore = null;
        KeyManager[] clientKeyManagers = null;
        if (usingSASL) {
            if (clientKeystoreType == null) {
                clientKeystoreType = DEFAULT_KEYSTORE_TYPE;
            }
            clientKeystore = KeyStore.getInstance(clientKeystoreType);
            if (clientKeystoreFile != null) {
                clientKeystore.load(new FileInputStream(clientKeystoreFile), clientPassphrase);
            }
            clientKeyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            clientKeyManagerFactory.init(clientKeystore, clientPassphrase);
            clientKeyManagers = clientKeyManagerFactory.getKeyManagers();
        } else {
            clientKeystore = null;
        }
        caKeystore = KeyStore.getInstance(caKeystoreType);
        if (caKeystoreFile != null) {
            caKeystore.load(new FileInputStream(caKeystoreFile), caPassphrase);
        }
        String defaultTrustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        caTrustManagerFactory = TrustManagerFactory.getInstance(defaultTrustAlgorithm);
        caTrustManagerFactory.init(caKeystore);
        TrustManager[] caTrustManagers = caTrustManagerFactory.getTrustManagers();
        TrustManager[] trustedServerAndCAManagers = caTrustManagers = JXTrustManager.convert(caTrustManagers, caKeystore, caKeystoreFile, caPassphrase, caKeystoreType, owner);
        sslctx.init(clientKeyManagers, trustedServerAndCAManagers, null);
        factory = sslctx.getSocketFactory();
        Class clazz = JXSSLSocketFactory.class;
        synchronized (clazz) {
            default_factory = new JXSSLSocketFactory();
        }
    }

    private static SSLContext setSSLContextProtocol() throws NoSuchAlgorithmException {
        String protocol = System.getProperty("sslversion", "TLS");
        if (!"TLS".equals(protocol)) {
            System.out.println("SECURITY WARNING: Using non-standard ssl version: '" + protocol + "'");
        }
        SSLContext sslctx = SSLContext.getInstance(protocol);
        return sslctx;
    }

    private static void checkFileSanity(String caKeystoreFile, String clientKeystoreFile, char[] clientPassphrase) throws SSLException {
        if (clientKeystoreFile == null && caKeystoreFile == null) {
            throw new SSLException("SSL Initialisation error: No valid keystore files available.");
        }
        if (caKeystoreFile != null && !new File(caKeystoreFile).exists()) {
            throw new SSLException("SSL Initialisation error: file '" + caKeystoreFile + "' does not exist.");
        }
        if (clientKeystoreFile != null && clientPassphrase != null && !new File(clientKeystoreFile).exists()) {
            throw new SSLException("SSL Initialisation error: file '" + clientKeystoreFile + "' does not exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketFactory getDefault() {
        Class clazz = JXSSLSocketFactory.class;
        synchronized (clazz) {
            if (default_factory == null) {
                default_factory = new JXSSLSocketFactory();
            }
        }
        return default_factory;
    }

    public static KeyStore getClientKeyStore() {
        return clientKeystore;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port, client_host, client_port);
    }

    public Socket createSocket(String host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port, client_host, client_port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException, UnknownHostException {
        return factory.createSocket(socket, host, port, autoclose);
    }

    public String[] getDefaultCipherSuites() {
        return factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return factory.getSupportedCipherSuites();
    }

    static {
        myClassLoader = null;
    }
}

