/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.format.ReportFormat;
import gnu.kawa.functions.LispFormat;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;

class LispJustificationFormat
extends ReportFormat {
    final Format[] segments;
    final int mincol;
    private int start2;

    LispJustificationFormat(LispFormat.TildeLessThan tlt) {
        this.segments = tlt.segments;
        int n = this.mincol = tlt.arg0 == -1073741824 ? 0 : tlt.arg0;
        if (tlt.arg1 != -1073741824) {
            throw new RuntimeException("colinc parameter not implemented");
        }
        if (tlt.arg2 != -1073741824) {
            throw new RuntimeException("minpad parameter not implemented");
        }
        if (tlt.arg3 != -1073741824) {
            throw new RuntimeException("padchar parameter not implemented");
        }
        if (tlt.seenAt) {
            throw new RuntimeException("@ modifier not implemented");
        }
        if (tlt.seenColon) {
            throw new RuntimeException(": modifier not implemented");
        }
    }

    String[] segmentStrings(Object[] args, int start, FieldPosition fpos) {
        String[] strings2 = new String[this.segments.length];
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.segments.length; ++i) {
            Format seg = this.segments[i];
            start = ReportFormat.format(seg, args, start, buffer, fpos);
            strings2[i] = buffer.toString();
            buffer.setLength(0);
        }
        this.start2 = start;
        return strings2;
    }

    static int sumlengths(String[] strings2) {
        int sum = 0;
        for (String s : strings2) {
            sum += s.length();
        }
        return sum;
    }

    int[] computePaddings(String[] strings2) {
        int width = this.mincol;
        int nchars = LispJustificationFormat.sumlengths(strings2);
        int nspaces = Math.max(0, width - nchars);
        int nsegs = this.segments.length;
        int[] paddings = new int[nsegs];
        if (nsegs > 1) {
            int i;
            int q = nspaces / (nsegs - 1);
            int r = nspaces % (nsegs - 1);
            for (i = 1; i < nsegs - r; ++i) {
                paddings[i] = q;
            }
            for (i = nsegs - r; i < nsegs; ++i) {
                paddings[i] = q + 1;
            }
        }
        return paddings;
    }

    static void appendPadding(Appendable dst, int n) throws IOException {
        while (n > 0) {
            dst.append(' ');
            --n;
        }
    }

    @Override
    public int format(Object[] args, int start, Appendable dst, FieldPosition fpos) throws IOException {
        String[] strings2 = this.segmentStrings(args, start, fpos);
        start = this.start2;
        int[] paddings = this.computePaddings(strings2);
        for (int i = 0; i < strings2.length; ++i) {
            LispJustificationFormat.appendPadding(dst, paddings[i]);
            dst.append(strings2[i]);
        }
        return start;
    }

    public String toString() {
        return "LispJustificationFormat[" + this.mincol + "]";
    }
}

