/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Qute {
    private static volatile Engine engine;
    private static volatile boolean cacheByDefault;
    private static final Map<Hash, Template> CACHE;
    private static final Variant PLAIN_TEXT;
    private static final AtomicLong ID_GENERATOR;
    private static final String TEMPLATE_PREFIX = "Qute$$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Engine engine() {
        Engine engine = Qute.engine;
        if (engine != null) return engine;
        Class<Qute> clazz = Qute.class;
        synchronized (Qute.class) {
            if (engine != null) return engine;
            Qute.engine = engine = Qute.newDefaultEngine();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return engine;
        }
    }

    public static void setEngine(Engine engine) {
        Qute.clearCache();
        Qute.engine = engine;
    }

    public static String fmt(String template, Map<String, Object> data) {
        return Qute.fmt(template).dataMap(data).render();
    }

    public static String fmt(String template, Object ... data) {
        return Qute.fmt(template).dataArray(data).render();
    }

    public static Fmt fmt(String template) {
        return new Fmt(template);
    }

    public static void enableCache() {
        cacheByDefault = true;
    }

    public static void disableCache() {
        cacheByDefault = false;
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private static String newId() {
        return TEMPLATE_PREFIX + ID_GENERATOR.incrementAndGet();
    }

    private static Hash hashKey(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return new Hash(md.digest(value.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Engine newDefaultEngine() {
        return Engine.builder().addDefaults().addValueResolver(new ReflectionValueResolver()).addParserHook(new IndexedArgumentsParserHook()).addResultMapper(new HtmlEscaper(ImmutableList.of("text/html", "text/xml"))).build();
    }

    static {
        CACHE = new ConcurrentHashMap<Hash, Template>();
        PLAIN_TEXT = Variant.forContentType("text/plain");
        ID_GENERATOR = new AtomicLong(0L);
    }

    private static final class Hash {
        private final byte[] hash;
        private final int hashCode;

        Hash(byte[] hash) {
            this.hash = hash;
            int prime = 31;
            int result = 1;
            this.hashCode = result = 31 * result + Arrays.hashCode(hash);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Hash other = (Hash)obj;
            return Arrays.equals(this.hash, other.hash);
        }
    }

    public static class IndexedArgumentsParserHook
    implements ParserHook {
        private final Pattern p = Pattern.compile("\\{\\}");
        private final String prefix;

        public IndexedArgumentsParserHook() {
            this(Qute.TEMPLATE_PREFIX);
        }

        public IndexedArgumentsParserHook(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void beforeParsing(ParserHelper parserHelper) {
            if (this.prefix != null && !parserHelper.getTemplateId().startsWith(this.prefix)) {
                return;
            }
            parserHelper.addContentFilter(new Function<String, String>(){

                @Override
                public String apply(String input) {
                    if (!input.contains("{}")) {
                        return input;
                    }
                    StringBuilder builder = new StringBuilder();
                    Matcher m = p.matcher(input);
                    int idx = 0;
                    while (m.find()) {
                        m.appendReplacement(builder, "{data." + idx + "}");
                        ++idx;
                    }
                    m.appendTail(builder);
                    return builder.toString();
                }
            });
        }
    }

    public static final class Fmt {
        private final String template;
        private Map<String, Object> attributes;
        private Map<String, Object> dataMap;
        private boolean cache;
        private Variant variant;

        Fmt(String template) {
            this.template = template;
            this.cache = cacheByDefault;
            this.variant = PLAIN_TEXT;
            this.dataMap = new HashMap<String, Object>();
        }

        public Fmt cache() {
            this.cache = true;
            return this;
        }

        public Fmt noCache() {
            this.cache = false;
            return this;
        }

        public Fmt contentType(String contentType) {
            this.variant = Variant.forContentType(contentType);
            return this;
        }

        public Fmt variant(Variant variant) {
            this.variant = variant;
            return this;
        }

        public Fmt attribute(String key, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Fmt dataArray(Object ... data) {
            this.dataMap.put("data", data);
            return this;
        }

        public Fmt dataMap(Map<String, Object> data) {
            this.dataMap.putAll(data);
            return this;
        }

        public Fmt data(String key, Object data) {
            this.dataMap.put(key, data);
            return this;
        }

        public String render() {
            return this.instance().render();
        }

        public TemplateInstance instance() {
            Engine engine = Qute.engine();
            Template parsed = this.cache ? CACHE.computeIfAbsent(Qute.hashKey(this.template), key -> {
                String id = Qute.newId();
                return engine.parse(this.template, this.variant, id);
            }) : engine.parse(this.template, this.variant, Qute.newId());
            TemplateInstance instance = parsed.instance();
            if (this.attributes != null) {
                this.attributes.forEach(instance::setAttribute);
            }
            this.dataMap.forEach(instance::data);
            return instance;
        }

        public String toString() {
            return this.render();
        }
    }
}

