/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractIndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexMergeConfigurationBuilder;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;

public class IndexWriterConfigurationBuilder
extends AbstractIndexingConfigurationChildBuilder
implements Builder<IndexWriterConfiguration> {
    private final AttributeSet attributes = IndexWriterConfiguration.attributeDefinitionSet();
    private final IndexMergeConfigurationBuilder indexMergeConfigurationBuilder;
    private final Attribute<Integer> commitInterval;
    private final Attribute<Integer> threadPoolSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_THREAD_POOL_SIZE);
    private final Attribute<Integer> queueCount = this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_COUNT);
    private final Attribute<Integer> queueSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_SIZE);
    private final Attribute<Integer> ramBufferSize;
    private final Attribute<Integer> maxBufferedEntries;
    private final Attribute<Boolean> lowLevelTrace;

    IndexWriterConfigurationBuilder(IndexingConfigurationBuilder builder) {
        super(builder);
        this.commitInterval = this.attributes.attribute(IndexWriterConfiguration.INDEX_COMMIT_INTERVAL);
        this.ramBufferSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_RAM_BUFFER_SIZE);
        this.maxBufferedEntries = this.attributes.attribute(IndexWriterConfiguration.INDEX_MAX_BUFFERED_ENTRIES);
        this.lowLevelTrace = this.attributes.attribute(IndexWriterConfiguration.INDEX_LOW_LEVEL_TRACE);
        this.indexMergeConfigurationBuilder = new IndexMergeConfigurationBuilder(builder);
    }

    public IndexMergeConfigurationBuilder merge() {
        return this.indexMergeConfigurationBuilder;
    }

    public IndexWriterConfigurationBuilder threadPoolSize(int value) {
        this.threadPoolSize.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder queueCount(int value) {
        this.queueCount.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder queueSize(int value) {
        this.queueSize.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder commitInterval(int value) {
        this.commitInterval.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder ramBufferSize(int value) {
        this.ramBufferSize.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder maxBufferedEntries(int value) {
        this.maxBufferedEntries.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder setLowLevelTrace(boolean value) {
        this.lowLevelTrace.set((Object)value);
        return this;
    }

    public IndexWriterConfiguration create() {
        return new IndexWriterConfiguration(this.attributes.protect(), this.indexMergeConfigurationBuilder.create());
    }

    public IndexWriterConfigurationBuilder read(IndexWriterConfiguration template) {
        this.attributes.read(template.attributes());
        this.indexMergeConfigurationBuilder.read(template.merge());
        return this;
    }

    public String toString() {
        return "IndexWriterConfigurationBuilder{attributes=" + this.attributes + ", indexMergeConfigurationBuilder=" + this.indexMergeConfigurationBuilder + "}";
    }
}

