/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Field;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.TypeGroup;

public class ClassLiteralExpression
extends Expression {
    private String[] pathList;
    private org.jboss.byteman.rule.type.Type ownerType;
    private Field field;
    private boolean isPublicClass;
    private int classIndex;

    public ClassLiteralExpression(Rule rule, org.jboss.byteman.rule.type.Type type, ParseNode pathTree, String[] pathList) {
        super(rule, type, pathTree);
        this.pathList = pathList;
        this.ownerType = null;
        this.classIndex = -1;
    }

    @Override
    public void bind() throws TypeException {
    }

    @Override
    public org.jboss.byteman.rule.type.Type typeCheck(org.jboss.byteman.rule.type.Type expected) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        this.ownerType = typeGroup.create(this.getPath(this.pathList.length));
        if (this.ownerType == null || this.ownerType.getTargetClass() == null) {
            throw new TypeException("FieldExpression.typeCheck : invalid class literal " + this.getPath(this.pathList.length) + ".class" + this.getPos());
        }
        this.type = typeGroup.ensureType(Class.class);
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return this.ownerType.getTargetClass();
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        mv.visitLdcInsn(Type.getType(this.ownerType.getTargetClass()));
        compileContext.addStackCount(1);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ClassLiteralExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }

    public String getPath(int len) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pathList[0]);
        for (int i = 1; i < len; ++i) {
            buffer.append(".");
            buffer.append(this.pathList[i]);
        }
        return buffer.toString();
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        String sepr = "";
        for (String field : this.pathList) {
            stringWriter.write(sepr);
            stringWriter.write(field);
            sepr = ".";
        }
    }
}

