/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.HTTPException;
import http_parser.HTTPMethod;
import http_parser.HTTPParserUrl;
import http_parser.ParserType;
import http_parser.lolevel.ParserSettings;
import java.nio.ByteBuffer;

public class HTTPParser {
    ParserType type;
    State state;
    HState header_state;
    boolean strict;
    int index;
    int flags;
    int nread;
    long content_length;
    int p_start;
    public int http_major;
    public int http_minor;
    public int status_code;
    public HTTPMethod method;
    public boolean upgrade;
    int header_field_mark = -1;
    int header_value_mark = -1;
    int url_mark = -1;
    int body_mark = -1;
    public boolean HTTP_PARSER_STRICT;

    public HTTPParser() {
        this(ParserType.HTTP_BOTH);
    }

    public HTTPParser(ParserType parserType) {
        this.type = parserType;
        switch (parserType) {
            case HTTP_REQUEST: {
                this.state = State.start_req;
                break;
            }
            case HTTP_RESPONSE: {
                this.state = State.start_res;
                break;
            }
            case HTTP_BOTH: {
                this.state = State.start_req_or_res;
                break;
            }
            default: {
                throw new HTTPException("can't happen, invalid ParserType enum");
            }
        }
    }

    static void p(Object object) {
        System.out.println(object);
    }

    public State parse_url_char(byte by) {
        int n = by & 0xFF;
        if (32 == by) {
            throw new HTTPException("space as url char");
        }
        switch (this.state) {
            case req_spaces_before_url: {
                if (47 == by || 42 == by) {
                    return State.req_path;
                }
                if (!this.isAtoZ(by)) break;
                return State.req_schema;
            }
            case req_schema: {
                if (this.isAtoZ(by)) {
                    return State.req_schema;
                }
                if (58 != by) break;
                return State.req_schema_slash;
            }
            case req_schema_slash: {
                if (47 != by) break;
                return State.req_schema_slash_slash;
            }
            case req_schema_slash_slash: {
                if (47 != by) break;
                return State.req_host_start;
            }
            case req_host_start: {
                if (by == 91) {
                    return State.req_host_v6_start;
                }
                if (!this.isHostChar(by)) break;
                return State.req_host;
            }
            case req_host: {
                if (this.isHostChar(by)) {
                    return State.req_host;
                }
            }
            case req_host_v6_end: {
                switch (by) {
                    case 58: {
                        return State.req_port_start;
                    }
                    case 47: {
                        return State.req_path;
                    }
                    case 63: {
                        return State.req_query_string_start;
                    }
                }
                break;
            }
            case req_host_v6: {
                if (by == 93) {
                    return State.req_host_v6_end;
                }
            }
            case req_host_v6_start: {
                if (!this.isHex(by) && by != 58) break;
                return State.req_host_v6;
            }
            case req_port: {
                switch (by) {
                    case 47: {
                        return State.req_path;
                    }
                    case 63: {
                        return State.req_query_string_start;
                    }
                }
            }
            case req_port_start: {
                if (!this.isDigit(by)) break;
                return State.req_port;
            }
            case req_path: {
                if (this.isNormalUrlChar(n)) {
                    return State.req_path;
                }
                switch (by) {
                    case 63: {
                        return State.req_query_string_start;
                    }
                    case 35: {
                        return State.req_fragment_start;
                    }
                }
                break;
            }
            case req_query_string_start: 
            case req_query_string: {
                if (this.isNormalUrlChar(n)) {
                    return State.req_query_string;
                }
                switch (by) {
                    case 63: {
                        return State.req_query_string;
                    }
                    case 35: {
                        return State.req_fragment_start;
                    }
                }
                break;
            }
            case req_fragment_start: {
                if (this.isNormalUrlChar(n)) {
                    return State.req_fragment;
                }
                switch (by) {
                    case 63: {
                        return State.req_fragment;
                    }
                    case 35: {
                        return State.req_fragment_start;
                    }
                }
                break;
            }
            case req_fragment: {
                if (this.isNormalUrlChar(by)) {
                    return State.req_fragment;
                }
                switch (by) {
                    case 35: 
                    case 63: {
                        return State.req_fragment;
                    }
                }
                break;
            }
        }
        return State.dead;
    }

    public int execute(ParserSettings parserSettings, ByteBuffer byteBuffer) {
        int n;
        this.p_start = n = byteBuffer.position();
        int n2 = byteBuffer.limit() - byteBuffer.position();
        if (0 == n2) {
            switch (this.state) {
                case body_identity_eof: {
                    parserSettings.call_on_message_complete(this);
                    return byteBuffer.position() - this.p_start;
                }
                case dead: 
                case start_req_or_res: 
                case start_res: 
                case start_req: {
                    return byteBuffer.position() - this.p_start;
                }
            }
            throw new HTTPException("empty bytes! " + (Object)((Object)this.state));
        }
        switch (this.state) {
            case header_field: {
                this.header_field_mark = n;
                break;
            }
            case header_value: {
                this.header_value_mark = n;
                break;
            }
            case req_schema: 
            case req_schema_slash: 
            case req_schema_slash_slash: 
            case req_host_start: 
            case req_host: 
            case req_host_v6_end: 
            case req_host_v6: 
            case req_host_v6_start: 
            case req_port: 
            case req_port_start: 
            case req_path: 
            case req_query_string_start: 
            case req_query_string: 
            case req_fragment_start: 
            case req_fragment: {
                this.url_mark = n;
            }
        }
        boolean bl = false;
        int n3 = 0;
        byte by = 0;
        int n4 = 0;
        byte by2 = -1;
        int n5 = 0;
        block117: while (byteBuffer.position() != byteBuffer.limit() || bl) {
            if (!bl) {
                n = byteBuffer.position();
                n3 = byteBuffer.limit();
                by = byteBuffer.get();
                n4 = by & 0xFF;
                by2 = -1;
                n5 = 0;
                if (this.parsing_header(this.state)) {
                    ++this.nread;
                    if (this.nread > 81920) {
                        return this.error(parserSettings, "possible buffer overflow", byteBuffer);
                    }
                }
            }
            bl = false;
            block9 : switch (this.state) {
                case dead: {
                    if (13 == by) continue block117;
                    if (10 == by) break;
                    return this.error(parserSettings, "Connection already closed", byteBuffer);
                }
                case start_req_or_res: {
                    if (13 == by) continue block117;
                    if (10 == by) break;
                    this.flags = 0;
                    this.content_length = -1L;
                    if (72 == by) {
                        this.state = State.res_or_resp_H;
                    } else {
                        this.type = ParserType.HTTP_REQUEST;
                        this.method = this.start_req_method_assign(by);
                        if (null == this.method) {
                            return this.error(parserSettings, "invalid method", byteBuffer);
                        }
                        this.index = 1;
                        this.state = State.req_method;
                    }
                    parserSettings.call_on_message_begin(this);
                    break;
                }
                case res_or_resp_H: {
                    if (84 == by) {
                        this.type = ParserType.HTTP_RESPONSE;
                        this.state = State.res_HT;
                        break;
                    }
                    if (69 != by) {
                        return this.error(parserSettings, "not E", byteBuffer);
                    }
                    this.type = ParserType.HTTP_REQUEST;
                    this.method = HTTPMethod.HTTP_HEAD;
                    this.index = 2;
                    this.state = State.req_method;
                    break;
                }
                case start_res: {
                    this.flags = 0;
                    this.content_length = -1L;
                    switch (by) {
                        case 72: {
                            this.state = State.res_H;
                            break;
                        }
                        case 10: 
                        case 13: {
                            break;
                        }
                        default: {
                            return this.error(parserSettings, "Not H or CR/LF", byteBuffer);
                        }
                    }
                    parserSettings.call_on_message_begin(this);
                    break;
                }
                case res_H: {
                    if (this.strict && 84 != by) {
                        return this.error(parserSettings, "Not T", byteBuffer);
                    }
                    this.state = State.res_HT;
                    break;
                }
                case res_HT: {
                    if (this.strict && 84 != by) {
                        return this.error(parserSettings, "Not T2", byteBuffer);
                    }
                    this.state = State.res_HTT;
                    break;
                }
                case res_HTT: {
                    if (this.strict && 80 != by) {
                        return this.error(parserSettings, "Not P", byteBuffer);
                    }
                    this.state = State.res_HTTP;
                    break;
                }
                case res_HTTP: {
                    if (this.strict && 47 != by) {
                        return this.error(parserSettings, "Not '/'", byteBuffer);
                    }
                    this.state = State.res_first_http_major;
                    break;
                }
                case res_first_http_major: {
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "Not a digit", byteBuffer);
                    }
                    this.http_major = by - 48;
                    this.state = State.res_http_major;
                    break;
                }
                case res_http_major: {
                    if (46 == by) {
                        this.state = State.res_first_http_minor;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "Not a digit", byteBuffer);
                    }
                    this.http_major *= 10;
                    this.http_major += by - 48;
                    if (this.http_major <= 999) continue block117;
                    return this.error(parserSettings, "invalid http major version: ", byteBuffer);
                }
                case res_first_http_minor: {
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "Not a digit", byteBuffer);
                    }
                    this.http_minor = by - 48;
                    this.state = State.res_http_minor;
                    break;
                }
                case res_http_minor: {
                    if (32 == by) {
                        this.state = State.res_first_status_code;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "Not a digit", byteBuffer);
                    }
                    this.http_minor *= 10;
                    this.http_minor += by - 48;
                    if (this.http_minor <= 999) continue block117;
                    return this.error(parserSettings, "invalid http minor version: ", byteBuffer);
                }
                case res_first_status_code: {
                    if (!this.isDigit(by)) {
                        if (32 == by) break;
                        return this.error(parserSettings, "Not a digit (status code)", byteBuffer);
                    }
                    this.status_code = by - 48;
                    this.state = State.res_status_code;
                    break;
                }
                case res_status_code: {
                    if (!this.isDigit(by)) {
                        switch (by) {
                            case 32: {
                                this.state = State.res_status;
                                break block9;
                            }
                            case 13: {
                                this.state = State.res_line_almost_done;
                                break block9;
                            }
                            case 10: {
                                this.state = State.header_field_start;
                                break block9;
                            }
                        }
                        return this.error(parserSettings, "not a valid status code", byteBuffer);
                    }
                    this.status_code *= 10;
                    this.status_code += by - 48;
                    if (this.status_code > 999) {
                        return this.error(parserSettings, "ridiculous status code:", byteBuffer);
                    }
                    if (this.status_code <= 99) continue block117;
                    parserSettings.call_on_status_complete(this);
                    break;
                }
                case res_status: {
                    if (13 == by) {
                        this.state = State.res_line_almost_done;
                        break;
                    }
                    if (10 != by) continue block117;
                    this.state = State.header_field_start;
                    break;
                }
                case res_line_almost_done: {
                    if (this.strict && 10 != by) {
                        return this.error(parserSettings, "not LF", byteBuffer);
                    }
                    this.state = State.header_field_start;
                    break;
                }
                case start_req: {
                    if (13 == by) continue block117;
                    if (10 == by) break;
                    this.flags = 0;
                    this.content_length = -1L;
                    if (!this.isAtoZ(by)) {
                        return this.error(parserSettings, "invalid method", byteBuffer);
                    }
                    this.method = this.start_req_method_assign(by);
                    if (null == this.method) {
                        return this.error(parserSettings, "invalid method", byteBuffer);
                    }
                    this.index = 1;
                    this.state = State.req_method;
                    parserSettings.call_on_message_begin(this);
                    break;
                }
                case req_method: {
                    if (0 == by) {
                        return this.error(parserSettings, "NULL in method", byteBuffer);
                    }
                    byte[] byArray = this.method.bytes;
                    if (32 == by && this.index == byArray.length) {
                        this.state = State.req_spaces_before_url;
                    } else if (byArray[this.index] != by) {
                        if (HTTPMethod.HTTP_CONNECT == this.method) {
                            if (1 == this.index && 72 == by) {
                                this.method = HTTPMethod.HTTP_CHECKOUT;
                            } else if (2 == this.index && 80 == by) {
                                this.method = HTTPMethod.HTTP_COPY;
                            }
                        } else if (HTTPMethod.HTTP_MKCOL == this.method) {
                            if (1 == this.index && 79 == by) {
                                this.method = HTTPMethod.HTTP_MOVE;
                            } else if (1 == this.index && 69 == by) {
                                this.method = HTTPMethod.HTTP_MERGE;
                            } else if (1 == this.index && 45 == by) {
                                this.method = HTTPMethod.HTTP_MSEARCH;
                            } else if (2 == this.index && 65 == by) {
                                this.method = HTTPMethod.HTTP_MKACTIVITY;
                            }
                        } else if (1 == this.index && HTTPMethod.HTTP_POST == this.method) {
                            if (82 == by) {
                                this.method = HTTPMethod.HTTP_PROPFIND;
                            } else if (85 == by) {
                                this.method = HTTPMethod.HTTP_PUT;
                            } else if (65 == by) {
                                this.method = HTTPMethod.HTTP_PATCH;
                            }
                        } else if (2 == this.index) {
                            if (HTTPMethod.HTTP_PUT == this.method) {
                                if (82 == by) {
                                    this.method = HTTPMethod.HTTP_PURGE;
                                }
                            } else if (HTTPMethod.HTTP_UNLOCK == this.method && 83 == by) {
                                this.method = HTTPMethod.HTTP_UNSUBSCRIBE;
                            }
                        } else if (4 == this.index && HTTPMethod.HTTP_PROPFIND == this.method && 80 == by) {
                            this.method = HTTPMethod.HTTP_PROPPATCH;
                        } else {
                            return this.error(parserSettings, "Invalid HTTP method", byteBuffer);
                        }
                    }
                    ++this.index;
                    break;
                }
                case req_spaces_before_url: {
                    if (32 == by) break;
                    this.url_mark = n;
                    if (HTTPMethod.HTTP_CONNECT == this.method) {
                        this.state = State.req_host_start;
                    }
                    this.state = this.parse_url_char(by);
                    if (this.state != State.dead) continue block117;
                    return this.error(parserSettings, "Invalid something", byteBuffer);
                }
                case req_schema: 
                case req_schema_slash: 
                case req_schema_slash_slash: 
                case req_host_start: 
                case req_host_v6: 
                case req_host_v6_start: 
                case req_port_start: {
                    switch (by) {
                        case 10: 
                        case 13: 
                        case 32: {
                            return this.error(parserSettings, "unexpected char in path", byteBuffer);
                        }
                    }
                    this.state = this.parse_url_char(by);
                    if (State.dead != this.state) continue block117;
                    return this.error(parserSettings, "unexpected char in path", byteBuffer);
                }
                case req_host: 
                case req_host_v6_end: 
                case req_port: 
                case req_path: 
                case req_query_string_start: 
                case req_query_string: 
                case req_fragment_start: 
                case req_fragment: {
                    switch (by) {
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            parserSettings.call_on_path(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.state = State.req_http_start;
                            break block9;
                        }
                        case 10: 
                        case 13: {
                            this.http_major = 0;
                            this.http_minor = 9;
                            this.state = 13 == by ? State.req_line_almost_done : State.header_field_start;
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            parserSettings.call_on_path(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            break block9;
                        }
                    }
                    this.state = this.parse_url_char(by);
                    if (State.dead != this.state) continue block117;
                    return this.error(parserSettings, "unexpected char in path", byteBuffer);
                }
                case req_http_start: {
                    switch (by) {
                        case 72: {
                            this.state = State.req_http_H;
                            break block9;
                        }
                        case 32: {
                            break block9;
                        }
                    }
                    return this.error(parserSettings, "error in req_http_H", byteBuffer);
                }
                case req_http_H: {
                    if (this.strict && 84 != by) {
                        return this.error(parserSettings, "unexpected char", byteBuffer);
                    }
                    this.state = State.req_http_HT;
                    break;
                }
                case req_http_HT: {
                    if (this.strict && 84 != by) {
                        return this.error(parserSettings, "unexpected char", byteBuffer);
                    }
                    this.state = State.req_http_HTT;
                    break;
                }
                case req_http_HTT: {
                    if (this.strict && 80 != by) {
                        return this.error(parserSettings, "unexpected char", byteBuffer);
                    }
                    this.state = State.req_http_HTTP;
                    break;
                }
                case req_http_HTTP: {
                    if (this.strict && 47 != by) {
                        return this.error(parserSettings, "unexpected char", byteBuffer);
                    }
                    this.state = State.req_first_http_major;
                    break;
                }
                case req_first_http_major: {
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "non digit in http major", byteBuffer);
                    }
                    this.http_major = by - 48;
                    this.state = State.req_http_major;
                    break;
                }
                case req_http_major: {
                    if (46 == by) {
                        this.state = State.req_first_http_minor;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "non digit in http major", byteBuffer);
                    }
                    this.http_major *= 10;
                    this.http_major += by - 48;
                    if (this.http_major <= 999) continue block117;
                    return this.error(parserSettings, "ridiculous http major", byteBuffer);
                }
                case req_first_http_minor: {
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "non digit in http minor", byteBuffer);
                    }
                    this.http_minor = by - 48;
                    this.state = State.req_http_minor;
                    break;
                }
                case req_http_minor: {
                    if (by == 13) {
                        this.state = State.req_line_almost_done;
                        break;
                    }
                    if (by == 10) {
                        this.state = State.header_field_start;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        return this.error(parserSettings, "non digit in http minor", byteBuffer);
                    }
                    this.http_minor *= 10;
                    this.http_minor += by - 48;
                    if (this.http_minor <= 999) continue block117;
                    return this.error(parserSettings, "ridiculous http minor", byteBuffer);
                }
                case req_line_almost_done: {
                    if (by != 10) {
                        return this.error(parserSettings, "missing LF after request line", byteBuffer);
                    }
                    this.state = State.header_field_start;
                    break;
                }
                case header_field_start: {
                    if (by == 13) {
                        this.state = State.headers_almost_done;
                        break;
                    }
                    if (by == 10) {
                        this.state = State.headers_almost_done;
                        bl = true;
                        break;
                    }
                    by2 = this.token(by);
                    if (0 == by2) {
                        return this.error(parserSettings, "invalid char in header:", byteBuffer);
                    }
                    this.header_field_mark = n;
                    this.index = 0;
                    this.state = State.header_field;
                    switch (by2) {
                        case 67: {
                            this.header_state = HState.C;
                            break block9;
                        }
                        case 80: {
                            this.header_state = HState.matching_proxy_connection;
                            break block9;
                        }
                        case 84: {
                            this.header_state = HState.matching_transfer_encoding;
                            break block9;
                        }
                        case 85: {
                            this.header_state = HState.matching_upgrade;
                            break block9;
                        }
                    }
                    this.header_state = HState.general;
                    break;
                }
                case header_field: {
                    by2 = this.token(by);
                    if (0 != by2) {
                        switch (this.header_state) {
                            case general: {
                                break block9;
                            }
                            case C: {
                                ++this.index;
                                this.header_state = 79 == by2 ? HState.CO : HState.general;
                                break block9;
                            }
                            case CO: {
                                ++this.index;
                                this.header_state = 78 == by2 ? HState.CON : HState.general;
                                break block9;
                            }
                            case CON: {
                                ++this.index;
                                switch (by2) {
                                    case 78: {
                                        this.header_state = HState.matching_connection;
                                        break block9;
                                    }
                                    case 84: {
                                        this.header_state = HState.matching_content_length;
                                        break block9;
                                    }
                                }
                                this.header_state = HState.general;
                                break block9;
                            }
                            case matching_connection: {
                                ++this.index;
                                if (this.index > C.CONNECTION.length || by2 != C.CONNECTION[this.index]) {
                                    this.header_state = HState.general;
                                    break block9;
                                }
                                if (this.index != C.CONNECTION.length - 1) continue block117;
                                this.header_state = HState.connection;
                                break block9;
                            }
                            case matching_proxy_connection: {
                                ++this.index;
                                if (this.index > C.PROXY_CONNECTION.length || by2 != C.PROXY_CONNECTION[this.index]) {
                                    this.header_state = HState.general;
                                    break block9;
                                }
                                if (this.index != C.PROXY_CONNECTION.length - 1) continue block117;
                                this.header_state = HState.connection;
                                break block9;
                            }
                            case matching_content_length: {
                                ++this.index;
                                if (this.index > C.CONTENT_LENGTH.length || by2 != C.CONTENT_LENGTH[this.index]) {
                                    this.header_state = HState.general;
                                    break block9;
                                }
                                if (this.index != C.CONTENT_LENGTH.length - 1) continue block117;
                                this.header_state = HState.content_length;
                                break block9;
                            }
                            case matching_transfer_encoding: {
                                ++this.index;
                                if (this.index > C.TRANSFER_ENCODING.length || by2 != C.TRANSFER_ENCODING[this.index]) {
                                    this.header_state = HState.general;
                                    break block9;
                                }
                                if (this.index != C.TRANSFER_ENCODING.length - 1) continue block117;
                                this.header_state = HState.transfer_encoding;
                                break block9;
                            }
                            case matching_upgrade: {
                                ++this.index;
                                if (this.index > C.UPGRADE.length || by2 != C.UPGRADE[this.index]) {
                                    this.header_state = HState.general;
                                    break block9;
                                }
                                if (this.index != C.UPGRADE.length - 1) continue block117;
                                this.header_state = HState.upgrade;
                                break block9;
                            }
                            case connection: 
                            case content_length: 
                            case transfer_encoding: 
                            case upgrade: {
                                if (32 == by) continue block117;
                                this.header_state = HState.general;
                                break block9;
                            }
                        }
                        return this.error(parserSettings, "Unknown Header State", byteBuffer);
                    }
                    if (58 == by) {
                        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
                        this.header_field_mark = -1;
                        this.state = State.header_value_start;
                        break;
                    }
                    if (13 == by) {
                        this.state = State.header_almost_done;
                        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
                        this.header_field_mark = -1;
                        break;
                    }
                    if (by == 10) {
                        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
                        this.header_field_mark = -1;
                        this.state = State.header_field_start;
                        break;
                    }
                    return this.error(parserSettings, "invalid header field", byteBuffer);
                }
                case header_value_start: {
                    if (32 == by) continue block117;
                    if (9 == by) break;
                    this.header_value_mark = n;
                    this.state = State.header_value;
                    this.index = 0;
                    if (13 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.header_state = HState.general;
                        this.state = State.header_almost_done;
                        break;
                    }
                    if (10 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.state = State.header_field_start;
                        break;
                    }
                    by2 = this.upper(by);
                    switch (this.header_state) {
                        case upgrade: {
                            this.flags |= 0x10;
                            this.header_state = HState.general;
                            break block9;
                        }
                        case transfer_encoding: {
                            if (67 == by2) {
                                this.header_state = HState.matching_transfer_encoding_chunked;
                                break block9;
                            }
                            this.header_state = HState.general;
                            break block9;
                        }
                        case content_length: {
                            if (!this.isDigit(by)) {
                                return this.error(parserSettings, "Content-Length not numeric", byteBuffer);
                            }
                            this.content_length = by - 48;
                            break block9;
                        }
                        case connection: {
                            if (75 == by2) {
                                this.header_state = HState.matching_connection_keep_alive;
                                break block9;
                            }
                            if (67 == by2) {
                                this.header_state = HState.matching_connection_close;
                                break block9;
                            }
                            this.header_state = HState.general;
                            break block9;
                        }
                    }
                    this.header_state = HState.general;
                    break;
                }
                case header_value: {
                    long l;
                    if (13 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.state = State.header_almost_done;
                        break;
                    }
                    if (10 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.state = State.header_almost_done;
                        bl = true;
                        break;
                    }
                    by2 = this.upper(by);
                    switch (this.header_state) {
                        case general: {
                            break;
                        }
                        case connection: 
                        case transfer_encoding: {
                            return this.error(parserSettings, "Shouldn't be here", byteBuffer);
                        }
                        case content_length: {
                            if (32 == by) break;
                            if (!this.isDigit(by)) {
                                return this.error(parserSettings, "Content-Length not numeric", byteBuffer);
                            }
                            l = this.content_length;
                            l *= 10L;
                            if ((l += (long)by - 48L) < this.content_length) {
                                return this.error(parserSettings, "Invalid content length", byteBuffer);
                            }
                            this.content_length = l;
                            break;
                        }
                        case matching_transfer_encoding_chunked: {
                            ++this.index;
                            if (this.index > C.CHUNKED.length || by2 != C.CHUNKED[this.index]) {
                                this.header_state = HState.general;
                                break;
                            }
                            if (this.index != C.CHUNKED.length - 1) continue block117;
                            this.header_state = HState.transfer_encoding_chunked;
                            break;
                        }
                        case matching_connection_keep_alive: {
                            ++this.index;
                            if (this.index > C.KEEP_ALIVE.length || by2 != C.KEEP_ALIVE[this.index]) {
                                this.header_state = HState.general;
                                break;
                            }
                            if (this.index != C.KEEP_ALIVE.length - 1) continue block117;
                            this.header_state = HState.connection_keep_alive;
                            break;
                        }
                        case matching_connection_close: {
                            ++this.index;
                            if (this.index > C.CLOSE.length || by2 != C.CLOSE[this.index]) {
                                this.header_state = HState.general;
                                break;
                            }
                            if (this.index != C.CLOSE.length - 1) continue block117;
                            this.header_state = HState.connection_close;
                            break;
                        }
                        case transfer_encoding_chunked: 
                        case connection_keep_alive: 
                        case connection_close: {
                            if (32 == by) continue block117;
                            this.header_state = HState.general;
                            break;
                        }
                        default: {
                            this.state = State.header_value;
                            this.header_state = HState.general;
                            break;
                        }
                    }
                    continue block117;
                }
                case header_almost_done: {
                    if (this.header_almost_done(by)) continue block117;
                    return this.error(parserSettings, "incorrect header ending, expecting LF", byteBuffer);
                }
                case header_value_lws: {
                    if (32 == by || 9 == by) {
                        this.state = State.header_value_start;
                        break;
                    }
                    this.state = State.header_field_start;
                    bl = true;
                    break;
                }
                case headers_almost_done: {
                    if (10 != by) {
                        return this.error(parserSettings, "header not properly completed", byteBuffer);
                    }
                    if (0 != (this.flags & 8)) {
                        this.state = this.new_message();
                        parserSettings.call_on_headers_complete(this);
                        parserSettings.call_on_message_complete(this);
                        break;
                    }
                    this.state = State.headers_done;
                    if (0 != (this.flags & 0x10) || HTTPMethod.HTTP_CONNECT == this.method) {
                        this.upgrade = true;
                    }
                    if (null != parserSettings.on_headers_complete) {
                        parserSettings.call_on_headers_complete(this);
                    }
                    bl = true;
                    break;
                }
                case headers_done: {
                    if (this.strict && 10 != by) {
                        return this.error(parserSettings, "STRICT CHECK", byteBuffer);
                    }
                    this.nread = 0;
                    if (this.upgrade) {
                        this.state = this.new_message();
                        parserSettings.call_on_message_complete(this);
                        return byteBuffer.position() - this.p_start;
                    }
                    if (0 != (this.flags & 0x20)) {
                        this.state = this.new_message();
                        parserSettings.call_on_message_complete(this);
                        break;
                    }
                    if (0 != (this.flags & 1)) {
                        this.state = State.chunk_size_start;
                        break;
                    }
                    if (this.content_length == 0L) {
                        this.state = this.new_message();
                        parserSettings.call_on_message_complete(this);
                        break;
                    }
                    if (this.content_length != -1L) {
                        this.state = State.body_identity;
                        break;
                    }
                    if (this.type == ParserType.HTTP_REQUEST || !this.http_message_needs_eof()) {
                        this.state = this.new_message();
                        parserSettings.call_on_message_complete(this);
                        break;
                    }
                    this.state = State.body_identity_eof;
                    break;
                }
                case body_identity: {
                    n5 = this.min(n3 - n, this.content_length);
                    this.body_mark = n;
                    if (n5 <= 0) continue block117;
                    parserSettings.call_on_body(this, byteBuffer, n, n5);
                    byteBuffer.position(n + n5);
                    this.content_length -= (long)n5;
                    if (this.content_length != 0L) continue block117;
                    this.state = State.message_done;
                    bl = true;
                    break;
                }
                case body_identity_eof: {
                    n5 = n3 - n;
                    if (n5 <= 0) continue block117;
                    parserSettings.call_on_body(this, byteBuffer, n, n5);
                    byteBuffer.position(n + n5);
                    break;
                }
                case message_done: {
                    this.state = this.new_message();
                    parserSettings.call_on_message_complete(this);
                    break;
                }
                case chunk_size_start: {
                    if (1 != this.nread) {
                        return this.error(parserSettings, "nread != 1 (chunking)", byteBuffer);
                    }
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    by2 = C.UNHEX[n4];
                    if (by2 == -1) {
                        return this.error(parserSettings, "invalid hex char in chunk content length", byteBuffer);
                    }
                    this.content_length = by2;
                    this.state = State.chunk_size;
                    break;
                }
                case chunk_size: {
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    if (13 == by) {
                        this.state = State.chunk_size_almost_done;
                        break;
                    }
                    by2 = C.UNHEX[n4];
                    if (by2 == -1) {
                        if (59 == by || 32 == by) {
                            this.state = State.chunk_parameters;
                            break;
                        }
                        return this.error(parserSettings, "invalid hex char in chunk content length", byteBuffer);
                    }
                    long l = this.content_length;
                    l *= 16L;
                    if ((l += (long)by2) < this.content_length) {
                        return this.error(parserSettings, "invalid content length", byteBuffer);
                    }
                    this.content_length = l;
                    break;
                }
                case chunk_parameters: {
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    if (13 != by) continue block117;
                    this.state = State.chunk_size_almost_done;
                    break;
                }
                case chunk_size_almost_done: {
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    if (this.strict && 10 != by) {
                        return this.error(parserSettings, "expected LF at end of chunk size", byteBuffer);
                    }
                    this.nread = 0;
                    if (0L == this.content_length) {
                        this.flags |= 8;
                        this.state = State.header_field_start;
                        break;
                    }
                    this.state = State.chunk_data;
                    break;
                }
                case chunk_data: {
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    n5 = this.min(n3 - n, this.content_length);
                    if (n5 > 0) {
                        parserSettings.call_on_body(this, byteBuffer, n, n5);
                        byteBuffer.position(n + n5);
                    }
                    if ((long)n5 == this.content_length) {
                        this.state = State.chunk_data_almost_done;
                    }
                    this.content_length -= (long)n5;
                    break;
                }
                case chunk_data_almost_done: {
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    if (this.strict && 13 != by) {
                        return this.error(parserSettings, "chunk data terminated incorrectly, expected CR", byteBuffer);
                    }
                    this.state = State.chunk_data_done;
                    break;
                }
                case chunk_data_done: {
                    if (0 == (this.flags & 1)) {
                        return this.error(parserSettings, "not chunked", byteBuffer);
                    }
                    if (this.strict && 10 != by) {
                        return this.error(parserSettings, "chunk data terminated incorrectly, expected LF", byteBuffer);
                    }
                    this.state = State.chunk_size_start;
                    break;
                }
                default: {
                    return this.error(parserSettings, "unhandled state", byteBuffer);
                }
            }
        }
        n = byteBuffer.position();
        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
        parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
        parserSettings.call_on_path(this, byteBuffer, this.url_mark, n - this.url_mark);
        return byteBuffer.position() - this.p_start;
    }

    int error(ParserSettings parserSettings, String string, ByteBuffer byteBuffer) {
        parserSettings.call_on_error(this, string, byteBuffer, this.p_start);
        this.state = State.dead;
        return byteBuffer.position() - this.p_start;
    }

    public boolean http_message_needs_eof() {
        if (this.type == ParserType.HTTP_REQUEST) {
            return false;
        }
        if (this.status_code / 100 == 1 || this.status_code == 204 || this.status_code == 304 || (this.flags & 0x20) != 0) {
            return false;
        }
        return (this.flags & 1) == 0 && this.content_length == -1L;
    }

    public boolean http_should_keep_alive() {
        if (this.http_major > 0 && this.http_minor > 0 ? 0 != (this.flags & 4) : 0 == (this.flags & 2)) {
            return false;
        }
        return !this.http_message_needs_eof();
    }

    public int parse_url(ByteBuffer byteBuffer, boolean bl, HTTPParserUrl hTTPParserUrl) {
        UrlFields urlFields = UrlFields.UF_MAX;
        UrlFields urlFields2 = UrlFields.UF_MAX;
        hTTPParserUrl.port = 0;
        hTTPParserUrl.field_set = 0;
        this.state = bl ? State.req_host_start : State.req_spaces_before_url;
        int n = byteBuffer.position();
        int n2 = 0;
        byte by = 0;
        block13: while (byteBuffer.position() != byteBuffer.limit()) {
            n2 = byteBuffer.position();
            by = byteBuffer.get();
            this.state = this.parse_url_char(by);
            switch (this.state) {
                case dead: {
                    return 1;
                }
                case req_schema_slash: 
                case req_schema_slash_slash: 
                case req_host_start: 
                case req_host_v6_end: 
                case req_host_v6_start: 
                case req_port_start: 
                case req_query_string_start: 
                case req_fragment_start: {
                    continue block13;
                }
                case req_schema: {
                    urlFields = UrlFields.UF_SCHEMA;
                    break;
                }
                case req_host: 
                case req_host_v6: {
                    urlFields = UrlFields.UF_HOST;
                    break;
                }
                case req_port: {
                    urlFields = UrlFields.UF_PORT;
                    break;
                }
                case req_path: {
                    urlFields = UrlFields.UF_PATH;
                    break;
                }
                case req_query_string: {
                    urlFields = UrlFields.UF_QUERY;
                    break;
                }
                case req_fragment: {
                    urlFields = UrlFields.UF_FRAGMENT;
                    break;
                }
                default: {
                    return 1;
                }
            }
            if (urlFields == urlFields2) {
                ++hTTPParserUrl.field_data[urlFields.getIndex()].len;
                continue;
            }
            hTTPParserUrl.field_data[urlFields.getIndex()].off = n2 - n;
            hTTPParserUrl.field_data[urlFields.getIndex()].len = 1;
            hTTPParserUrl.field_set |= 1 << urlFields.getIndex();
            urlFields2 = urlFields;
        }
        if (bl && hTTPParserUrl.field_set != (1 << UrlFields.UF_HOST.getIndex() | 1 << UrlFields.UF_PORT.getIndex())) {
            return 1;
        }
        switch (this.state) {
            case req_host: 
            case req_host_v6_end: 
            case req_host_v6: 
            case req_host_v6_start: 
            case req_port_start: {
                return 1;
            }
        }
        if (0 != (hTTPParserUrl.field_set & 1 << UrlFields.UF_PORT.getIndex())) {
            int n3 = this.strtoi(byteBuffer, n + hTTPParserUrl.field_data[UrlFields.UF_PORT.getIndex()].off);
            if (n3 > 65535) {
                return 1;
            }
            hTTPParserUrl.port = n3;
        }
        return 0;
    }

    int strtoi(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(n);
        String string = "";
        while (byteBuffer.position() < byteBuffer.limit()) {
            byte by = byteBuffer.get();
            if (Character.isWhitespace((char)by)) continue;
            if (!this.isDigit(by)) break;
            string = string + (char)by;
        }
        return Integer.parseInt(string);
    }

    boolean isDigit(byte by) {
        return by >= 48 && by <= 57;
    }

    boolean isHex(byte by) {
        return this.isDigit(by) || this.lower(by) >= 97 && this.lower(by) <= 102;
    }

    boolean isAtoZ(byte by) {
        byte by2 = this.lower(by);
        return by2 >= 97 && by2 <= 122;
    }

    byte lower(byte by) {
        return (byte)(by | 0x20);
    }

    byte upper(byte by) {
        char c = (char)by;
        return (byte)Character.toUpperCase(c);
    }

    byte token(byte by) {
        if (!this.strict) {
            return by == 32 ? (byte)32 : (byte)C.tokens[by];
        }
        return (byte)C.tokens[by];
    }

    boolean isHostChar(byte by) {
        if (!this.strict) {
            return this.isAtoZ(by) || this.isDigit(by) || 46 == by || 45 == by || 95 == by;
        }
        return this.isAtoZ(by) || this.isDigit(by) || 46 == by || 45 == by;
    }

    boolean isNormalUrlChar(int n) {
        if (!this.strict) {
            return n > 128 || C.normal_url_char[n];
        }
        return C.normal_url_char[n];
    }

    HTTPMethod start_req_method_assign(byte by) {
        switch (by) {
            case 67: {
                return HTTPMethod.HTTP_CONNECT;
            }
            case 68: {
                return HTTPMethod.HTTP_DELETE;
            }
            case 71: {
                return HTTPMethod.HTTP_GET;
            }
            case 72: {
                return HTTPMethod.HTTP_HEAD;
            }
            case 76: {
                return HTTPMethod.HTTP_LOCK;
            }
            case 77: {
                return HTTPMethod.HTTP_MKCOL;
            }
            case 78: {
                return HTTPMethod.HTTP_NOTIFY;
            }
            case 79: {
                return HTTPMethod.HTTP_OPTIONS;
            }
            case 80: {
                return HTTPMethod.HTTP_POST;
            }
            case 82: {
                return HTTPMethod.HTTP_REPORT;
            }
            case 83: {
                return HTTPMethod.HTTP_SUBSCRIBE;
            }
            case 84: {
                return HTTPMethod.HTTP_TRACE;
            }
            case 85: {
                return HTTPMethod.HTTP_UNLOCK;
            }
        }
        return null;
    }

    boolean header_almost_done(byte by) {
        if (this.strict && 10 != by) {
            return false;
        }
        this.state = State.header_value_lws;
        switch (this.header_state) {
            case connection_keep_alive: {
                this.flags |= 2;
                break;
            }
            case connection_close: {
                this.flags |= 4;
                break;
            }
            case transfer_encoding_chunked: {
                this.flags |= 1;
                break;
            }
        }
        return true;
    }

    final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    final int min(int n, long l) {
        return (long)n < l ? n : (int)l;
    }

    State new_message() {
        if (this.HTTP_PARSER_STRICT) {
            return this.http_should_keep_alive() ? this.start_state() : State.dead;
        }
        return this.start_state();
    }

    State start_state() {
        return this.type == ParserType.HTTP_REQUEST ? State.start_req : State.start_res;
    }

    boolean parsing_header(State state) {
        switch (state) {
            case body_identity_eof: 
            case body_identity: 
            case message_done: 
            case chunk_data: 
            case chunk_data_almost_done: 
            case chunk_data_done: {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UrlFields {
        UF_SCHEMA(0),
        UF_HOST(1),
        UF_PORT(2),
        UF_PATH(3),
        UF_QUERY(4),
        UF_FRAGMENT(5),
        UF_MAX(6);

        private final int index;

        private UrlFields(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HState {
        general,
        C,
        CO,
        CON,
        matching_connection,
        matching_proxy_connection,
        matching_content_length,
        matching_transfer_encoding,
        matching_upgrade,
        connection,
        content_length,
        transfer_encoding,
        upgrade,
        matching_transfer_encoding_chunked,
        matching_connection_keep_alive,
        matching_connection_close,
        transfer_encoding_chunked,
        connection_keep_alive,
        connection_close;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        dead,
        start_req_or_res,
        res_or_resp_H,
        start_res,
        res_H,
        res_HT,
        res_HTT,
        res_HTTP,
        res_first_http_major,
        res_http_major,
        res_first_http_minor,
        res_http_minor,
        res_first_status_code,
        res_status_code,
        res_status,
        res_line_almost_done,
        start_req,
        req_method,
        req_spaces_before_url,
        req_schema,
        req_schema_slash,
        req_schema_slash_slash,
        req_host_start,
        req_host_v6_start,
        req_host_v6,
        req_host_v6_end,
        req_host,
        req_port_start,
        req_port,
        req_path,
        req_query_string_start,
        req_query_string,
        req_fragment_start,
        req_fragment,
        req_http_start,
        req_http_H,
        req_http_HT,
        req_http_HTT,
        req_http_HTTP,
        req_first_http_major,
        req_http_major,
        req_first_http_minor,
        req_http_minor,
        req_line_almost_done,
        header_field_start,
        header_field,
        header_value_start,
        header_value,
        header_value_lws,
        header_almost_done,
        chunk_size_start,
        chunk_size,
        chunk_parameters,
        chunk_size_almost_done,
        headers_almost_done,
        headers_done,
        chunk_data,
        chunk_data_almost_done,
        chunk_data_done,
        body_identity,
        body_identity_eof,
        message_done;

    }

    static class C {
        static final int HTTP_MAX_HEADER_SIZE = 81920;
        static final int F_CHUNKED = 1;
        static final int F_CONNECTION_KEEP_ALIVE = 2;
        static final int F_CONNECTION_CLOSE = 4;
        static final int F_TRAILING = 8;
        static final int F_UPGRADE = 16;
        static final int F_SKIPBODY = 32;
        static final byte[] UPCASE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 95, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        static final byte[] CONNECTION = new byte[]{67, 79, 78, 78, 69, 67, 84, 73, 79, 78};
        static final byte[] PROXY_CONNECTION = new byte[]{80, 82, 79, 88, 89, 45, 67, 79, 78, 78, 69, 67, 84, 73, 79, 78};
        static final byte[] CONTENT_LENGTH = new byte[]{67, 79, 78, 84, 69, 78, 84, 45, 76, 69, 78, 71, 84, 72};
        static final byte[] TRANSFER_ENCODING = new byte[]{84, 82, 65, 78, 83, 70, 69, 82, 45, 69, 78, 67, 79, 68, 73, 78, 71};
        static final byte[] UPGRADE = new byte[]{85, 80, 71, 82, 65, 68, 69};
        static final byte[] CHUNKED = new byte[]{67, 72, 85, 78, 75, 69, 68};
        static final byte[] KEEP_ALIVE = new byte[]{75, 69, 69, 80, 45, 65, 76, 73, 86, 69};
        static final byte[] CLOSE = new byte[]{67, 76, 79, 83, 69};
        static final char[] tokens = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '!', '\u0000', '#', '$', '%', '&', '\'', '\u0000', '\u0000', '*', '+', '\u0000', '-', '.', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '_', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '|', '\u0000', '~', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        static final byte[] UNHEX = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        static final boolean[] normal_url_char = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        public static final byte A = 65;
        public static final byte B = 66;
        public static final byte C = 67;
        public static final byte D = 68;
        public static final byte E = 69;
        public static final byte F = 70;
        public static final byte G = 71;
        public static final byte H = 72;
        public static final byte I = 73;
        public static final byte J = 74;
        public static final byte K = 75;
        public static final byte L = 76;
        public static final byte M = 77;
        public static final byte N = 78;
        public static final byte O = 79;
        public static final byte P = 80;
        public static final byte Q = 81;
        public static final byte R = 82;
        public static final byte S = 83;
        public static final byte T = 84;
        public static final byte U = 85;
        public static final byte V = 86;
        public static final byte W = 87;
        public static final byte X = 88;
        public static final byte Y = 89;
        public static final byte Z = 90;
        public static final byte UNDER = 95;
        public static final byte CR = 13;
        public static final byte LF = 10;
        public static final byte DOT = 46;
        public static final byte SPACE = 32;
        public static final byte TAB = 9;
        public static final byte SEMI = 59;
        public static final byte COLON = 58;
        public static final byte HASH = 35;
        public static final byte QMARK = 63;
        public static final byte SLASH = 47;
        public static final byte DASH = 45;
        public static final byte STAR = 42;
        public static final byte NULL = 0;

        C() {
        }
    }
}

