/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) + i64vec4(165l, 133l, 193l, 76l)) => i64vec4(330l, 266l, 386l, 152l)
 * (i64vec4(165l, 133l, 193l, 76l) + i64vec4(80l, -15l, -51l, 0l)) => i64vec4(245l, 118l, 142l, 76l)
 * (i64vec4(80l, -15l, -51l, 0l) + i64vec4(165l, 133l, 193l, 76l)) => i64vec4(245l, 118l, 142l, 76l)
 * (i64vec4(80l, -15l, -51l, 0l) + i64vec4(80l, -15l, -51l, 0l)) => i64vec4(160l, -30l, -102l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + i64vec4(165l, 133l, 193l, 76l)), i64vec4(330l, 266l, 386l, 152l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + i64vec4(80l, -15l, -51l, 0l)), i64vec4(245l, 118l, 142l, 76l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + i64vec4(165l, 133l, 193l, 76l)), i64vec4(245l, 118l, 142l, 76l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + i64vec4(80l, -15l, -51l, 0l)), i64vec4(160l, -30l, -102l, 0l))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
