/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.LineNumber;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class LineNumberTable
extends Attribute
implements Iterable<LineNumber> {
    private static final int MAX_LINE_LENGTH = 72;
    private LineNumber[] lineNumberTable;

    LineNumberTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LineNumber[])null, constant_pool);
        int line_number_table_length = input.readUnsignedShort();
        this.lineNumberTable = new LineNumber[line_number_table_length];
        for (int i = 0; i < line_number_table_length; ++i) {
            this.lineNumberTable[i] = new LineNumber(input);
        }
    }

    public LineNumberTable(int name_index, int length, LineNumber[] line_number_table, ConstantPool constant_pool) {
        super((byte)4, name_index, length, constant_pool);
        this.lineNumberTable = line_number_table;
    }

    public LineNumberTable(LineNumberTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLineNumberTable(), c.getConstantPool());
    }

    @Override
    public void accept(Visitor v) {
        v.visitLineNumberTable(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LineNumberTable c = (LineNumberTable)this.clone();
        c.lineNumberTable = new LineNumber[this.lineNumberTable.length];
        Arrays.setAll(c.lineNumberTable, i -> this.lineNumberTable[i].copy());
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.lineNumberTable.length);
        for (LineNumber lineNumber : this.lineNumberTable) {
            lineNumber.dump(file);
        }
    }

    public LineNumber[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public int getSourceLine(int pos) {
        int l = 0;
        int r = this.lineNumberTable.length - 1;
        if (r < 0) {
            return -1;
        }
        int min_index = -1;
        int min = -1;
        do {
            int i;
            int j;
            if ((j = this.lineNumberTable[i = l + r >>> 1].getStartPC()) == pos) {
                return this.lineNumberTable[i].getLineNumber();
            }
            if (pos < j) {
                r = i - 1;
            } else {
                l = i + 1;
            }
            if (j >= pos || j <= min) continue;
            min = j;
            min_index = i;
        } while (l <= r);
        if (min_index < 0) {
            return -1;
        }
        return this.lineNumberTable[min_index].getLineNumber();
    }

    public int getTableLength() {
        return this.lineNumberTable == null ? 0 : this.lineNumberTable.length;
    }

    @Override
    public Iterator<LineNumber> iterator() {
        return Stream.of(this.lineNumberTable).iterator();
    }

    public void setLineNumberTable(LineNumber[] lineNumberTable) {
        this.lineNumberTable = lineNumberTable;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        StringBuilder line = new StringBuilder();
        String newLine = System.getProperty("line.separator", "\n");
        for (int i = 0; i < this.lineNumberTable.length; ++i) {
            line.append(this.lineNumberTable[i].toString());
            if (i < this.lineNumberTable.length - 1) {
                line.append(", ");
            }
            if (line.length() <= 72 || i >= this.lineNumberTable.length - 1) continue;
            line.append(newLine);
            buf.append((CharSequence)line);
            line.setLength(0);
        }
        buf.append((CharSequence)line);
        return buf.toString();
    }
}

