/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontFileRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public abstract class AbstractFontFileRegistry
implements FontRegistry {
    private static final Logger logger = Logger.getLogger(AbstractFontFileRegistry.class.getName());
    private HashMap seenFiles = new HashMap();

    protected AbstractFontFileRegistry() {
    }

    protected HashMap getSeenFiles() {
        return this.seenFiles;
    }

    protected abstract FileFilter getFileFilter();

    @Override
    public void initialize() {
        this.registerDefaultFontPath();
        Configuration configuration = LibFontBoot.getInstance().getGlobalConfig();
        Iterator extraDirIt = configuration.findPropertyKeys("org.pentaho.reporting.libraries.fonts.extra-font-dirs.");
        while (extraDirIt.hasNext()) {
            String extraDir = (String)extraDirIt.next();
            File extraDirFile = new File(extraDir);
            try {
                if (!extraDirFile.isDirectory()) continue;
                this.registerFontPath(extraDirFile, this.getDefaultEncoding());
            }
            catch (Exception e) {
                logger.warning("Extra font path " + extraDir + " could not be fully registered: " + e);
            }
        }
    }

    protected String getDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.fonts.itext.FontEncoding", EncodingRegistry.getPlatformDefaultEncoding());
    }

    public void registerDefaultFontPath() {
        String encoding = this.getDefaultEncoding();
        this.loadFromCache(encoding);
        String osname = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = this.safeSystemGetProperty("java.home", ".");
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        logger.config("Running on operating system: " + osname);
        logger.config("Character encoding used as default: " + encoding);
        if (this.safeSystemGetProperty("mrj.version", null) != null) {
            String userhome = this.safeSystemGetProperty("user.home", ".");
            logger.config("Detected MacOS (Property 'mrj.version' is present.");
            this.registerFontPath(new File(userhome + "/Library/Fonts"), encoding);
            this.registerFontPath(new File("/Library/Fonts"), encoding);
            this.registerFontPath(new File("/Network/Library/Fonts"), encoding);
            this.registerFontPath(new File("/System/Library/Fonts"), encoding);
        } else if (StringUtils.startsWithIgnoreCase((String)osname, (String)"windows")) {
            this.registerWindowsFontPath(encoding);
        } else {
            logger.config("Assuming unix like file structures");
            this.registerFontPath(new File("/usr/X11R6/lib/X11/fonts"), encoding);
            this.registerFontPath(new File("/usr/share/fonts"), encoding);
        }
        this.registerFontPath(new File(jrepath, "lib" + fs + "fonts"), encoding);
        this.storeToCache(encoding);
        logger.info("Completed font registration.");
    }

    protected void storeToCache(String encoding) {
    }

    protected void loadFromCache(String encoding) {
    }

    private void registerWindowsFontPath(String encoding) {
        logger.config("Found 'Windows' in the OS name, assuming DOS/Win32 structures");
        String fontPath = null;
        String windirs = this.safeSystemGetProperty("java.library.path", null);
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!StringUtils.endsWithIgnoreCase((String)token, (String)"System32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                if (lastBackslash != -1) {
                    fontPath = token.substring(0, lastBackslash) + fs + "Fonts";
                    break;
                }
                int lastSlash = token.lastIndexOf(47);
                if (lastSlash == -1) continue;
                fontPath = token.substring(0, lastSlash) + lastSlash + "Fonts";
                break;
            }
        }
        logger.config("Fonts located in \"" + fontPath + '\"');
        if (fontPath != null) {
            File file = new File(fontPath);
            this.registerFontPath(file, encoding);
        }
    }

    public void registerFontPath(File file, String encoding) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            for (File currentFile : file.listFiles(this.getFileFilter())) {
                if (currentFile.isDirectory()) {
                    this.registerFontPath(currentFile, encoding);
                    continue;
                }
                if (this.isCached(currentFile)) continue;
                this.registerFontFile(currentFile, encoding);
            }
        }
    }

    protected boolean isCached(File file) {
        try {
            FontFileRecord stored = (FontFileRecord)this.seenFiles.get(file.getCanonicalPath());
            if (stored == null) {
                return false;
            }
            FontFileRecord rec = new FontFileRecord(file);
            if (!stored.equals(rec)) {
                this.seenFiles.remove(rec);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void registerFontFile(String filename, String encoding) {
        File file = new File(filename);
        this.registerFontFile(file, encoding);
    }

    public synchronized void registerFontFile(File file, String encoding) {
        if (this.getFileFilter().accept(file) && file.exists() && file.isFile() && file.canRead()) {
            try {
                if (this.addFont(file, encoding)) {
                    FontFileRecord value = new FontFileRecord(file);
                    this.seenFiles.put(file.getCanonicalPath(), value);
                }
            }
            catch (Exception e) {
                logger.warning("Font " + file + " is invalid. Message: " + e);
            }
        }
    }

    protected abstract boolean addFont(File var1, String var2) throws IOException;

    protected String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    protected boolean isCacheValid(HashMap cachedSeenFiles) {
        for (Map.Entry entry : cachedSeenFiles.entrySet()) {
            String fullFileName = (String)entry.getKey();
            FontFileRecord fontFileRecord = (FontFileRecord)entry.getValue();
            File fontFile = new File(fullFileName);
            if (!fontFile.isFile() || !fontFile.exists()) {
                return false;
            }
            if (fontFile.length() != fontFileRecord.getFileSize()) {
                return false;
            }
            if (fontFile.lastModified() == fontFileRecord.getLastAccessTime()) continue;
            return false;
        }
        return true;
    }

    protected File createStorageLocation() {
        String homeDirectory = this.safeSystemGetProperty("user.home", null);
        if (homeDirectory == null) {
            return null;
        }
        File homeFile = new File(homeDirectory);
        if (!homeFile.isDirectory()) {
            return null;
        }
        return new File(homeFile, ".pentaho/caches/libfonts");
    }
}

